package clinical.web.dd;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

import clinical.utils.Assertion;
import clinical.utils.FileUtils;
import clinical.utils.XCEDEUtils;
import clinical.xml.xcede2.AnalysisT;
import clinical.xml.xcede2.LevelDataRefsT;
import clinical.xml.xcede2.XCEDE;

/**
 * @author I. Burak Ozyurt
 * @version $Id: XCEDE2AnalysisMerger.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class XCEDE2AnalysisMerger {

	public List<File> findXCEDEFiles(File dir) throws Exception {
		if (!dir.exists() || !dir.isDirectory())
			throw new Exception("Not a valid directory :" + dir);
		File[] files = dir.listFiles();
		List<File> xcedeFiles = new ArrayList<File>(10);
		boolean foundProvenance = false;
		for (File f : files) {
			if (f.isFile() && f.getName().endsWith(".xml")
					&& !f.getName().equals("merged.xml")) {
				if (f.getName().equals("provenance.xml")) {
					foundProvenance = true;
				}
				if (isXCEDE2File(f)) {
					xcedeFiles.add(f);
				}
			}
		}
		if (!foundProvenance)
			throw new Exception(
					"No XCEDE provenance.xml file has been found in dir:" + dir);
		return xcedeFiles;
	}

	
	
	public static boolean isXCEDE2File(File f) {
		BufferedReader in = null;
		try {
			in = new BufferedReader(new FileReader(f));
			String line;
			while ((line = in.readLine()) != null) {
				if (line.indexOf("http://www.xcede.org/xcede-2") != -1) {
					return true;
				}
			}
		} catch (IOException iox) {
			System.err.println(iox);
			return false;
		} finally {
			FileUtils.close(in);
		}
		return false;
	}

	public XCEDE merge(List<File> xcedeFiles) throws Exception {
		List<XCEDE> xcedeList = new ArrayList<XCEDE>(xcedeFiles.size());
		XCEDE theRoot = null;
		for (File file : xcedeFiles) {
			XCEDE xcede = XCEDEUtils.unmarshal(file);
			List<Object> aList = xcede
					.getAnnotationListOrRevisionListOrProject();
			if (!aList.isEmpty() && aList.get(0) instanceof AnalysisT) {
				xcedeList.add(xcede);
				AnalysisT a = (AnalysisT) aList.get(0);
				if (!a.getInput().isEmpty() && !a.getProvenance().isEmpty()) {
					theRoot = xcede;
					LevelDataRefsT ldr = a.getOutput().get(0);
					System.out.println(ldr.getAnalysisID());
				}
			}
		}
		Assertion.assertNotNull(theRoot);
		List<Object> analysisList = theRoot
				.getAnnotationListOrRevisionListOrProject();
		for (XCEDE xcede : xcedeList) {
			if (xcede != theRoot) {
				AnalysisT a = (AnalysisT) xcede
						.getAnnotationListOrRevisionListOrProject().get(0);
				analysisList.add(a);
			}
		}
		return theRoot;
	}

	public void saveMerged(XCEDE xcede, File xmlFile) throws Exception {
		BufferedOutputStream bout = null;
		try {
			bout = new BufferedOutputStream(new FileOutputStream(xmlFile));
			JAXBContext jc = JAXBContext.newInstance(XCEDE.class);
			Marshaller marshaller = jc.createMarshaller();
			marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT,
					new Boolean(true));

			marshaller.marshal(xcede, bout);

		} finally {
			FileUtils.close(bout);
		}

	}

	// test driver
	public static void main(String[] args) throws Exception {
		String rootDir = "/home/bozyurt/work/fsanalysis/PhaseII_struct__0064/Data/001029291693/scanVisit__0010__0002/MRI__0001/t1/Analysis/PhaseII_struct__0010__0001";
		rootDir = "/home/bozyurt/work/fsanalysis/fBIRNPhaseII__0010/Data/001029291693/scanVisit__0010__0002/MRI__0001/t1/Analysis/FreeSurfer__0010__0001";
		List<File> xcedeFiles = new ArrayList<File>(10);
		xcedeFiles.add(new File(rootDir, "provenance.xml"));
		xcedeFiles.add(new File(rootDir, "aseg.stats.xml"));
		xcedeFiles.add(new File(rootDir, "lh.aparc.stats.xml"));
		xcedeFiles.add(new File(rootDir, "rh.aparc.stats.xml"));
		xcedeFiles.add(new File(rootDir, "lh.aparc.a2005s.stats.xml"));
		xcedeFiles.add(new File(rootDir, "rh.aparc.a2005s.stats.xml"));

		File mergedFile = new File(rootDir, "merged.xml");

		XCEDE2AnalysisMerger m = new XCEDE2AnalysisMerger();
		XCEDE xcede = m.merge(xcedeFiles);

		m.saveMerged(xcede, mergedFile);
	}
}
