package clinical.web.forms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.LabelValueBean;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.server.vo.Expsegment;
import clinical.server.vo.Protocol;
import clinical.web.Constants;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.UserInfo;
import clinical.web.common.query.QueryPartInfo;
import clinical.web.common.query.SearchPredicate;
import clinical.web.common.vo.AsScoreInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.exception.BaseException;
import clinical.web.helpers.ExperimentSelector;
import clinical.web.helpers.HeaderInfo;
import clinical.web.helpers.ScoreValueSummary;
import clinical.web.helpers.ScoreValueSummaryHeader;
import clinical.web.helpers.SearchResultsIterator;
import clinical.web.helpers.SubCorticalVarInfo;
import clinical.web.helpers.ProtocolSelector;
import clinical.web.vo.QueryInfo;
import clinical.web.vo.QuerySummary;
import clinical.web.vo.SubjectAsScoreValueSummary;

/**
 * 
 * @version $Id: AsQueryBuilderForm.java,v 1.19.2.1 2008/06/18 00:45:12 bozyurt
 *          Exp $
 * @author I. Burak Ozyurt
 */

public class AsQueryBuilderForm extends ActionForm {
	private static final long serialVersionUID = -6722513074008349889L;
	private List<AssessmentSelectionInfo> assessments = new LinkedList<AssessmentSelectionInfo>();
	private List<QueryPartInfo> queryParts = new ArrayList<QueryPartInfo>();
	private List<ScoreValueSummary> summaryList = new LinkedList<ScoreValueSummary>();
	private List<SubCorticalVarInfo> subcorticalVars = new LinkedList<SubCorticalVarInfo>();
	/** */
	private List<LabelValueBean> statNamePageList;
	private String selectedStatPage;
	private String statPageURL;
	private ScoreValueSummaryHeader svHeader;
	private SearchResultsIterator searchResultsIter;
	private SearchResultsIterator qsResultsIter;
	private String[] combinators;

	private StoredQuerySelector savedQuerySelector;

	private boolean savedQueryLoaded;
	private boolean allowMediatedQuery;

	private String expandCollapseKey;
	/* used for experiment selection for the assessment query */
	private ExperimentSelector expSelector;

	private QueryScopeSelector queryScopeSelector;

	/** a list of SubjectAsScoreValueSummary objects */
	private List<SubjectAsScoreValueSummary> sasvsList;
	private Log log = LogFactory.getLog("clinical");

	/** query building action performed currently */
	private String state = Constants.SEL_ASSESSMENT;

	private QueryInfo queryInfo;
	private List<QuerySummary> qsList;
	private String caQueryString;
	private String ddQueryString;
	private boolean supportAnalysisQuery;
	private boolean supportAssessmentQuery;
	
	/********* Jinran added for Imaging query ******************/
	private ProtocolSelector proSelector; 
	private String[] selectedProtocols;	
	private String[] allProtocols;
	private String[] selectedSegments;
	private String[] allSegments;	
	private List<Expsegment> listExpSegments;
	private String[] selectedDataTypes;
	private String[] selectedProVers;
	/***********************************************************/

	public AsQueryBuilderForm() {
		if (log.isDebugEnabled()) {
			log.debug("*** new AsQueryBuilderForm created");
		}

		queryScopeSelector = new QueryScopeSelector();
	}

	public void setStatPageURL(String newStatPageURL) {
		this.statPageURL = newStatPageURL;
	}

	public String getStatPageURL() {
		return this.statPageURL;
	}

	public void populateStatNamePageList(
			LinkedHashMap<String, String> namePageMap) {
		statNamePageList = new ArrayList<LabelValueBean>(namePageMap.size());
		for (Map.Entry<String, String> entry : namePageMap.entrySet()) {
			LabelValueBean lvb = new LabelValueBean(entry.getKey(), entry
					.getValue());
			statNamePageList.add(lvb);
		}
	}

	public Collection<LabelValueBean> getStatNamePageList() {
		return statNamePageList;
	}

	public void setSelectedStatPage(String newSelectedStatPage) {
		this.selectedStatPage = newSelectedStatPage;
	}

	public String getSelectedStatPage() {
		return this.selectedStatPage;
	}

	public void addAssessment(AssessmentSelectionInfo asi) {
		assessments.add(asi);
	}

	public void addQueryPart(QueryPartInfo queryPart) {
		queryParts.add(queryPart);
	}

	public void addSubcorticalVar(SubCorticalVarInfo scvi) {
		subcorticalVars.add(scvi);
	}

	public void clearSubcorticalVars() {
		subcorticalVars.clear();
	}

	public void clearQueryParts() {
		queryParts.clear();
		combinators = null;
	}

	// to select stored queries
	public void setSavedQuerySelector(StoredQuerySelector newSavedQuerySelector) {
		this.savedQuerySelector = newSavedQuerySelector;
	}

	public StoredQuerySelector getSavedQuerySelector() {
		return this.savedQuerySelector;
	}

	public void setSavedQueryLoaded(boolean newSavedQueryLoaded) {
		this.savedQueryLoaded = newSavedQueryLoaded;
	}

	public boolean getSavedQueryLoaded() {
		return this.savedQueryLoaded;
	}

	public void setAllowMediatedQuery(boolean newAllowMediatedQuery) {
		this.allowMediatedQuery = newAllowMediatedQuery;
	}

	public boolean getAllowMediatedQuery() {
		return this.allowMediatedQuery;
	}

	/**
	 * Returns a list of <code>AssessmentSelectionInfo</code> objects
	 * 
	 * @return a list of <code>AssessmentSelectionInfo</code> objects
	 */
	public List<AssessmentSelectionInfo> getAssessments() {
		return assessments;
	}

	/**
	 * 
	 * @return a list of <code>QueryPartInfo</code> objects
	 */
	public List<QueryPartInfo> getQueryParts() {
		if (log.isDebugEnabled())
			log.debug("getQueryParts:" + queryParts);
		return queryParts;
	}

	/**
	 * 
	 * @return a list of <code>SubCorticalVarInfo</code> objects
	 */
	public List<SubCorticalVarInfo> getSubcorticalVars() {
		return subcorticalVars;
	}

	// indexed property
	public String getCombinator(int idx) {
		return combinators[idx];
	}

	public String[] getCombinators() {
		return combinators;
	}

	// indexed property
	public QueryPartInfo getQp(int idx) {
		return queryParts.get(idx);
	}

	// indexed property
	public SubCorticalVarInfo getSv(int idx) {
		return subcorticalVars.get(idx);
	}

	public AssessmentSelectionInfo getAsi(int idx) {
		if (log.isDebugEnabled())
			log.debug("getAsi: size=" + assessments.size() + ", idx=" + idx);
		if (idx > assessments.size())
			return null;
		return assessments.get(idx);
	}

	public String getState() {
		return this.state;
	}

	public void setState(String newState) {
		this.state = newState;
		log.info("**** State is set to " + newState);
	}

	public void setExpSelector(ExperimentSelector newExpSelector) {
		this.expSelector = newExpSelector;
	}

	public ExperimentSelector getExpSelector() {
		// log.info("getExpSelector(): " + this.expSelector);
		return this.expSelector;
	}

	public void setSvHeader(ScoreValueSummaryHeader svHeader) {
		this.svHeader = svHeader;
	}

	public void setSummaryList(List<ScoreValueSummary> summaryList) {
		this.summaryList = summaryList;
	}

	public List<ScoreValueSummary> getSummaryList() {
		return summaryList;
	}

	public List<HeaderInfo> getHeaders() {
		return svHeader.getHeaders();
	}

	public int getHeadersColumnCount() {
		int size = 0;
		try {
			for (HeaderInfo hi : svHeader.getHeaders()) {
				size += hi.getSize();
			}
		} catch (RuntimeException t) {
			t.printStackTrace();
			throw t;
		}

		if (size == 0) {
			size = 1;
		}
		return size;
	}

	/**
	 * returns the total number of columns for the header divided by 2
	 * 
	 * @return
	 */
	public int getFirstHalfOfTotColumnCount() {
		int numCols = getHeadersColumnCount();
		return (numCols + 2) / 2;
	}

	public int getSecondHalfOfTotColumnCount() {
		int numCols = getHeadersColumnCount();
		return numCols + 2 - (numCols + 2) / 2;
	}

	public void clean() {
		this.state = Constants.SEL_ASSESSMENT;
		queryParts.clear();

		if (assessments != null) {
			assessments.clear();
			/*
			 * for (Iterator<AssessmentSelectionInfo> it = assessments.iterator();
			 * it .hasNext();) { AssessmentSelectionInfo asi = it.next(); if
			 * (asi.isSelected()) { asi.getScores().clear(); } }
			 */
		}
		resetCollectQuery();
		searchResultsIter = null;
		qsResultsIter = null;
		subcorticalVars.clear();
	}

	public void resetUserSelections() {
		for (Iterator<AssessmentSelectionInfo> it = assessments.iterator(); it
				.hasNext();) {
			AssessmentSelectionInfo asi = it.next();
			if (asi.isSelected()) {
				asi.setSelected(false);
				asi.getScores().clear();
			}
		}
		subcorticalVars.clear();
	}

	public void reset(ActionMapping mapping, HttpServletRequest request) {
		System.out.println("XXXXXXXX in RESET");
		if (state.equals(Constants.COLLECT_QUERY)) {
			resetCollectQuery();
		} else {
			for (Iterator<AssessmentSelectionInfo> it = assessments.iterator(); it
					.hasNext();) {
				AssessmentSelectionInfo asi = it.next();
				if (state.equals(Constants.SEL_ASSESSMENT)) {
					asi.setSelected(false);
				} else if (state.equals(Constants.SEL_SCORE)) {
					if (asi.isSelected()) {
						for (AsScoreInfo si : asi.getScores()) {
							si.setSelected(false);
						}
					}
				}
			}// for
		}
	}

	public void resetCollectQuery() {
		for (Iterator<QueryPartInfo> it = getQueryParts().iterator(); it
				.hasNext();) {
			QueryPartInfo qpi = it.next();
			qpi.setOperator(SearchPredicate.EQUAL);
			qpi.setRhs("");
			if (qpi.getScoreInfo() != null) {
				if (!qpi.getScoreInfo().getType().equals("varchar")) {
					qpi.setLowBound("");
					qpi.setUppBound("");
				}
			}
		}
		setSummaryList(null);
		setSvHeader(null);
	}

	public void setCombinator(int idx, String value) {
		combinators[idx] = value;
	}

	public void setCombinators(String[] combinators) {
		this.combinators = combinators;
	}

	public void setAsSelected(int idx, boolean value) {
		assessments.get(idx).setSelected(value);
	}

	/*
	 * public SearchResultsIterator getSearchResultsIterator() { return
	 * getSearchResultsIterator(false); }
	

	public SearchResultsIterator getSearchResultsIterator(boolean forceRenew) {
		if (forceRenew) {
			searchResultsIter = new SearchResultsIterator(summaryList, 20);
		} else {

			if (searchResultsIter == null && summaryList != null) {
				searchResultsIter = new SearchResultsIterator(summaryList, 20);
			}
		}
		return searchResultsIter;
	}
*/
	
	public SearchResultsIterator getQsSearchResultsIter() {
		return getQsSearchResultsIter(false);
	}

	public SearchResultsIterator getQsSearchResultsIter(boolean forceRenew) {
		if (forceRenew) {
			qsResultsIter = new SearchResultsIterator(qsList, 10);
		} else {
			if (qsResultsIter == null && qsList != null)
				qsResultsIter = new SearchResultsIterator(qsList, 10);
		}
		return qsResultsIter;
	}

	// for tree expand/collapse support
	public void setExpandCollapseKey(String newExpandCollapseKey) {
		this.expandCollapseKey = newExpandCollapseKey;
	}

	public String getExpandCollapseKey() {
		return this.expandCollapseKey;
	}

	// validation
	public ActionErrors validate(ActionMapping mapping,
			HttpServletRequest request) {
		ActionErrors errors = new ActionErrors();

		return errors;
	}

	public List<SubjectAsScoreValueSummary> getSasvsList() {
		return sasvsList;
	}

	public void setSasvsList(List<SubjectAsScoreValueSummary> sasvsList) {
		this.sasvsList = sasvsList;
	}

	public QueryScopeSelector getQueryScopeSelector() {
		return queryScopeSelector;
	}

	public QueryInfo getQueryInfo() {
		return queryInfo;
	}

	public void setQueryInfo(QueryInfo queryInfo) {
		this.queryInfo = queryInfo;
	}

	public List<QuerySummary> getQsList() {
		return qsList;
	}

	public void setQsList(List<QuerySummary> qsList) {
		this.qsList = qsList;
	}

	public String getCaQueryString() {
		return caQueryString;
	}

	public void setCaQueryString(String caQueryString) {
		this.caQueryString = caQueryString;
	}

	public String getDdQueryString() {
		return ddQueryString;
	}

	public void setDdQueryString(String ddQueryString) {
		this.ddQueryString = ddQueryString;
	}

	public void setSupportAnalysisQuery(boolean supportAnalysisQuery) {
		this.supportAnalysisQuery = supportAnalysisQuery;
	}

	public boolean isSupportAnalysisQuery() {
		return supportAnalysisQuery;
	}

	public void setSupportAssessmentQuery(boolean supportAssessmentQuery) {
		this.supportAssessmentQuery = supportAssessmentQuery;
	}

	public boolean isSupportAssessmentQuery() {
		return supportAssessmentQuery;
	}

	//Jinran added. To clear all items in assessment.
	public void deleteAssessment(){
		if(this.assessments!=null){
			this.assessments.clear();	
		}
	}

	public void setProSelector(ProtocolSelector proSelector) {
		this.proSelector = proSelector;
	}

	public ProtocolSelector getProSelector() {
		return proSelector;
	}
	
	public List<Protocol> getProtocols(String dbID, UserInfo ui)throws BaseException {
		IDBCache dbCache = ServiceFactory.getDBCache(dbID);
		List<Protocol> protocols = dbCache.getProtocols(ui, false);
		return protocols;
	}

	public List<Expsegment> getExpSegments(String dbID, UserInfo ui)throws BaseException {
		IDBCache dbCache = ServiceFactory.getDBCache(dbID);
		List<Expsegment> expSegments = dbCache.getExpsegments(ui, false);
		return expSegments;
	}
	
	public void setSelectedProtocols(String[] selectedProtocols) {
		this.selectedProtocols = selectedProtocols;
	}

	public String[] getSelectedProtocols() {
		return selectedProtocols;
	}

	public void setAllProtocols(String[] allProtocols) {
		this.allProtocols = allProtocols;
	}

	public String[] getAllProtocols() {
		String[] allPros = new String[proSelector.getProtocolCols().size()];
		int i = 0;
		for(LabelValueBean lvb : this.proSelector.getProtocolCols()){
			allPros[i++] = lvb.getLabel();
		}		
		return allPros;
	}

	public void setSelectedSegments(String[] selectedSegments) {
		this.selectedSegments = selectedSegments;
	}

	public String[] getSelectedSegments() {
		return selectedSegments;
	}

	public void setAllSegments(String[] allSegments) {
		this.allSegments = allSegments;
	}

	public String[] getAllSegments() {
		return allSegments;
	}

	public void setListExpSegments(List<Expsegment> listExpSegments) {
		this.listExpSegments = listExpSegments;
	}

	public List<Expsegment> getListExpSegments() {
		return listExpSegments;
	}

	public void setSelectedDataTypes(String[] selectedDataTypes) {
		this.selectedDataTypes = selectedDataTypes;
	}

	public String[] getSelectedDataTypes() {
		return selectedDataTypes;
	}

	public void setSelectedProVers(String[] selectedProVers) {
		this.selectedProVers = selectedProVers;
	}

	public String[] getSelectedProVers() {
		return selectedProVers;
	}
	
	public String getJSONStr() {
		try {
			JSONArray jsArr = toJSON();
			return jsArr.toString(2);
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return "[]";
	}

	public JSONArray toJSON() throws JSONException {
		JSONArray jsArr = new JSONArray();
		for (Object qs : getQsSearchResultsIter().getData() ) {
			QuerySummary qqss = (QuerySummary)qs;			
			jsArr.put(qqss.toJSON(new JSONObject()));
		}
		return jsArr;
	}
}
