package clinical.web.forms;

import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SaveQueryForm.java 547 2012-02-22 18:19:37Z jinranc $
 */
public class SaveQueryForm extends ActionForm {
	private static final long serialVersionUID = 3704380998091316846L;
	protected String description = "";
	public List<String> storedQueryDescriptions = new LinkedList<String>();
	public List<StoredQuery> storedQueryIdDesc = new LinkedList<StoredQuery>(); //Jinran added
	
	private StoredQuerySelector savedQuerySelector = new StoredQuerySelector(); //Jinran added
	
	private String saveProtocols; //Jinran added
	private String saveVersions; //Jinran added
	private String saveTypes; //Jinran added

	
	public SaveQueryForm() {
	}

	public void setDescription(String newDescription) {
		this.description = newDescription;
	}

	public String getDescription() {
		return this.description;
	}

	public void addStoredQueryDescription(String description) {
		storedQueryDescriptions.add(description);
	}

	public List<String> getStoredQueryDescriptions() {
		return storedQueryDescriptions;
	}

	public ActionErrors validate(ActionMapping mapping,
			HttpServletRequest request) {
		ActionErrors errors = new ActionErrors();
		/** @todo */
		return errors;
	}

	public void reset(ActionMapping mapping, HttpServletRequest request) {

	}

	//Jinran added
	public void addStoredQueryIdDesc(String description, BigDecimal id){
		StoredQuery sq = new StoredQuery();
		sq.setQueryDescription(description);
		sq.setQueryId(id);
		this.storedQueryIdDesc.add(sq);
	}
	
	public List<StoredQuery> getStoredQueryIdDesc(){
		return this.storedQueryIdDesc;
	}
	
	public void setSavedQuerySelector(StoredQuerySelector savedQuerySelector) {
		this.savedQuerySelector = savedQuerySelector;
	}

	public StoredQuerySelector getSavedQuerySelector() {
		return savedQuerySelector;
	}

	public void setSaveProtocols(String saveProtocols) {
		this.saveProtocols = saveProtocols;
	}

	public String getSaveProtocols() {
		return saveProtocols;
	}

	public void setSaveVersions(String saveVersions) {
		this.saveVersions = saveVersions;
	}

	public String getSaveVersions() {
		return saveVersions;
	}

	public void setSaveTypes(String saveTypes) {
		this.saveTypes = saveTypes;
	}

	public String getSaveTypes() {
		return saveTypes;
	}

	public class StoredQuery{
		private BigDecimal queryId;
		private String queryDescription;
		
		public BigDecimal getQueryId(){
			return queryId;
		}
		
		public void setQueryId(BigDecimal value){
			this.queryId = value;
		}
		
		public String getQueryDescription(){
			return queryDescription;
		}
		
		public void setQueryDescription(String value){
			this.queryDescription = value;
		}
	}
	
	//Jinran added
}
