package clinical.web.game;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * Represents state information about a particular question, on a particular
 * form page
 * 
 * @author I. Burak Ozyurt
 * @version $Id: PageQuestionInfo.java 91 2009-08-17 23:38:26Z bozyurt $
 * 
 */
public class PageQuestionInfo {
	private int pageNumber;
	private int questionNumber;
	private String type;
	private int minAnswer;
	private int maxAnswer;
	private List<String> scoreNames = new LinkedList<String>();
	private Map<String, Integer> scoreNameIDMAp = null;

	public PageQuestionInfo(int pageNumber, int questionNumber, String type) {
		this(pageNumber, questionNumber, type, 1, 1);
	}

	public PageQuestionInfo(int pageNumber, int questionNumber, String type,
			int minAnswer, int maxAnswer) {
		this.pageNumber = pageNumber;
		this.questionNumber = questionNumber;
		this.type = type;
		this.minAnswer = minAnswer;
		this.maxAnswer = maxAnswer;
	}

	public int getPageNumber() {
		return pageNumber;
	}

	public int getQuestionNumber() {
		return questionNumber;
	}

	public String getType() {
		return type;
	}

	public int getMinAnswer() {
		return minAnswer;
	}

	public int getMaxAnswer() {
		return maxAnswer;
	}

	public void addScoreName(String scoreName) {
		scoreNames.add(scoreName);
	}

	public List<String> getScoreNames() {
		return scoreNames;
	}

	public boolean isMultiAnswer() {
		return type.equals("multiple-answer");
	}

	public void addScoreNameIDAssoc(String scoreName, Integer id) {
		if (scoreNameIDMAp == null) {
			scoreNameIDMAp = new HashMap<String, Integer>(3);
		}
		scoreNameIDMAp.put(scoreName, id);
	}

	public Integer getIDForScoreName(String scoreName) {
		return scoreNameIDMAp.get(scoreName);
	}
}