package clinical.web.game.forms;

import java.util.*;
import javax.servlet.http.*;
import java.text.*;

import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;
/**
  *
  * @version $Id: QuickMoodForm.java 91 2009-08-17 23:38:26Z bozyurt $
  * @author Generated by Clinical Assessment Layout Manager (CALM)
  */

public class QuickMoodForm extends ActionForm {

    private String wideAwake= "";
    private String relaxed= "";
    private String depressed= "";
    private String friendly= "";
    private String anxious= "";
    private String clumsy= "";
    private String cheerful= "";
    private String drowsy= "";
    private String aggressive= "";
    private String clearHeaded= "";
    private String wellCoordinated= "";
    private String confused= "";
    private String date = "";
    private String time = "";
    private String informantid = "";
    private String informantrelation = "";
    private DynamicDropDownSelector clinicalrater;

    // variables standard for each generated Assessment Struts Form Bean
    private String assessmentID;
    private String subjectID;
    private String experimentID;
    private String visitID;
    private String segmentID;
    private int currentPageIdx = 1;
    private String selectedQuestion = "";
    private String skippedQuestions = "";
    private String dataClassificationForSkipped = "";

    private static Map pageQuestionsMap;
    private static Map variableMap = null;
    private static Map mandatoryFieldMetaDataMap = null;

    public QuickMoodForm() {
    }

    public String getWideAwake() {  return this.wideAwake; }
    public String getRelaxed() {  return this.relaxed; }
    public String getDepressed() {  return this.depressed; }
    public String getFriendly() {  return this.friendly; }
    public String getAnxious() {  return this.anxious; }
    public String getClumsy() {  return this.clumsy; }
    public String getCheerful() {  return this.cheerful; }
    public String getDrowsy() {  return this.drowsy; }
    public String getAggressive() {  return this.aggressive; }
    public String getClearHeaded() {  return this.clearHeaded; }
    public String getWellCoordinated() {  return this.wellCoordinated; }
    public String getConfused() {  return this.confused; }
    public String getDate() {  return this.date; }
    public String getTime() {  return this.time; }
    public String getInformantid() {  return this.informantid; }
    public String getInformantrelation() {  return this.informantrelation; }
    public DynamicDropDownSelector getClinicalrater() {  return this.clinicalrater; }

    public void setWideAwake(String newValue) {  this.wideAwake = newValue; }
    public void setRelaxed(String newValue) {  this.relaxed = newValue; }
    public void setDepressed(String newValue) {  this.depressed = newValue; }
    public void setFriendly(String newValue) {  this.friendly = newValue; }
    public void setAnxious(String newValue) {  this.anxious = newValue; }
    public void setClumsy(String newValue) {  this.clumsy = newValue; }
    public void setCheerful(String newValue) {  this.cheerful = newValue; }
    public void setDrowsy(String newValue) {  this.drowsy = newValue; }
    public void setAggressive(String newValue) {  this.aggressive = newValue; }
    public void setClearHeaded(String newValue) {  this.clearHeaded = newValue; }
    public void setWellCoordinated(String newValue) {  this.wellCoordinated = newValue; }
    public void setConfused(String newValue) {  this.confused = newValue; }
    public void setDate(String newValue) {  this.date = newValue; }
    public void setTime(String newValue) {  this.time = newValue; }
    public void setInformantid(String newValue) {  this.informantid = newValue; }
    public void setInformantrelation(String newValue) {  this.informantrelation = newValue; }
    public void setClinicalrater(DynamicDropDownSelector newValue) {  this.clinicalrater = newValue; }

                    
                    
                    


    public String getAssessmentID() {  return this.assessmentID; }
    public String getSubjectID() {  return this.subjectID; }
    public String getExperimentID() {  return this.experimentID; }
    public String getVisitID() {  return this.visitID; }
    public String getSegmentID() {  return this.segmentID; }
    public int getCurrentPageIdx() {  return this.currentPageIdx; }
    public String getSelectedQuestion() {  return this.selectedQuestion; }
    public String getSkippedQuestions() {  return this.skippedQuestions; }
    public String getDataClassificationForSkipped() {  return this.dataClassificationForSkipped; }

    public void setAssessmentID(String newValue) {  this.assessmentID = newValue; }
    public void setSubjectID(String newValue) {  this.subjectID = newValue; }
    public void setExperimentID(String newValue) {  this.experimentID = newValue; }
    public void setVisitID(String newValue) {  this.visitID = newValue; }
    public void setSegmentID(String newValue) {  this.segmentID = newValue; }
    public void setCurrentPageIdx(int newValue) {  this.currentPageIdx = newValue; }
    public void setSelectedQuestion(String newValue) {  this.selectedQuestion = newValue; }
    public void setSkippedQuestions(String newValue) {  this.skippedQuestions = newValue; }
    public void setDataClassificationForSkipped(String newValue) {  this.dataClassificationForSkipped = newValue; }

    
public static class PageVariableInfo {
      int pageNumber;
      String formVarName;
      String dbVarName;
      Map metaDataMap;
      public PageVariableInfo(int pageNumber, String formVarName, String dbVarName) {
        this.pageNumber = pageNumber;
        this.formVarName = formVarName;
        this.dbVarName = dbVarName;
      }

      public int getPageNumber() { return this.pageNumber; }
      public String getFormVarName() { return this.formVarName; }
      public String getDbVarName() { return this.dbVarName; }
      public void addMetaData(String name, String value) {
        if (metaDataMap == null) {
          metaDataMap = new HashMap(3);
        }
        metaDataMap.put(name, value);
      }
      public Map getMetaDataMap() { return metaDataMap; }
    }

    private final static String assessmentName = "quick mood scale";

    public static String getAssessmentName() { return assessmentName; }

    public static Map getVariableMap() {
      synchronized(QuickMoodForm.class) {
        if (variableMap == null) {
      variableMap = new LinkedHashMap();
      PageVariableInfo pvi = null;

          variableMap.put("wide awake", pvi = new PageVariableInfo(1,"wideAwake","wide awake") );
          variableMap.put("relaxed", pvi = new PageVariableInfo(1,"relaxed","relaxed") );
          variableMap.put("depressed", pvi = new PageVariableInfo(1,"depressed","depressed") );
          variableMap.put("friendly", pvi = new PageVariableInfo(1,"friendly","friendly") );
          variableMap.put("anxious", pvi = new PageVariableInfo(1,"anxious","anxious") );
          variableMap.put("clumsy", pvi = new PageVariableInfo(1,"clumsy","clumsy") );
          variableMap.put("cheerful", pvi = new PageVariableInfo(1,"cheerful","cheerful") );
          variableMap.put("drowsy", pvi = new PageVariableInfo(1,"drowsy","drowsy") );
          variableMap.put("aggressive", pvi = new PageVariableInfo(1,"aggressive","aggressive") );
          variableMap.put("clear-headed", pvi = new PageVariableInfo(1,"clearHeaded","clear-headed") );
          variableMap.put("well coordinated", pvi = new PageVariableInfo(1,"wellCoordinated","well coordinated") );
          variableMap.put("confused", pvi = new PageVariableInfo(1,"confused","confused") );
        }
      }
      return variableMap;
    }
    public static Map getMandatoryFieldMetaDataMap() {
      if (mandatoryFieldMetaDataMap == null) {
        mandatoryFieldMetaDataMap = new HashMap(3);
        Map mdMap = new HashMap(3);
        mandatoryFieldMetaDataMap.put("clinicalrater",mdMap);
        mdMap.put("query","select a.name from nc_databaseuser a, nc_userclass b where a.userclass = b.uniqueid and b.name = 'researcher'");
      }
      return mandatoryFieldMetaDataMap;
    }


 public static class PageQuestionInfo {
    int pageNumber;
    int questionNumber;
    String type;
    int minAnswer;
    int maxAnswer;
    List scoreNames = new LinkedList();
    Map scoreNameIDMAp = new HashMap(3);

    public PageQuestionInfo(int pageNumber, int questionNumber, String type) {
      this(pageNumber, questionNumber, type, 1, 1);
    }

    public PageQuestionInfo(int pageNumber, int questionNumber, String type,
                            int minAnswer, int maxAnswer)
    {
      this.pageNumber = pageNumber;
      this.questionNumber = questionNumber;
      this.type = type;
      this.minAnswer = minAnswer;
      this.maxAnswer = maxAnswer;
    }

    public int getPageNumber() { return pageNumber; }
    public int getQuestionNumber() { return questionNumber; }
    public String getType() { return type; }
    public int getMinAnswer() { return minAnswer; }
    public int getMaxAnswer() { return maxAnswer; }

    public void addScoreNameIDAssoc(String scoreName, int id) {
       scoreNameIDMAp.put(scoreName, new Integer(id));
    }

    public Integer getIDForScoreName(String scoreName) {
       return (Integer) scoreNameIDMAp.get(scoreName);
    }

    public void addScoreName(String scoreName) {
      scoreNames.add(scoreName);
    }

    public List getScoreNames() { return scoreNames; }
  }


    public static Map getPageQuestionsMap() {
      synchronized(QuickMoodForm.class) {
        if (pageQuestionsMap == null) {
          pageQuestionsMap = new LinkedHashMap();

          List list = null;
          PageQuestionInfo pqi = null;
          list = new LinkedList();
          pageQuestionsMap.put( new Integer(1), list);
          list.add( pqi = new PageQuestionInfo(1,10,"regular") );
          pqi.addScoreName("clear-headed");
          pqi.addScoreNameIDAssoc("clear-headed",0);
          list.add( pqi = new PageQuestionInfo(1,3,"regular") );
          pqi.addScoreName("depressed");
          pqi.addScoreNameIDAssoc("depressed",0);
          list.add( pqi = new PageQuestionInfo(1,5,"regular") );
          pqi.addScoreName("anxious");
          pqi.addScoreNameIDAssoc("anxious",0);
          list.add( pqi = new PageQuestionInfo(1,7,"regular") );
          pqi.addScoreName("cheerful");
          pqi.addScoreNameIDAssoc("cheerful",0);
          list.add( pqi = new PageQuestionInfo(1,2,"regular") );
          pqi.addScoreName("relaxed");
          pqi.addScoreNameIDAssoc("relaxed",0);
          list.add( pqi = new PageQuestionInfo(1,9,"regular") );
          pqi.addScoreName("aggressive");
          pqi.addScoreNameIDAssoc("aggressive",0);
          list.add( pqi = new PageQuestionInfo(1,11,"regular") );
          pqi.addScoreName("well coordinated");
          pqi.addScoreNameIDAssoc("well coordinated",0);
          list.add( pqi = new PageQuestionInfo(1,4,"regular") );
          pqi.addScoreName("friendly");
          pqi.addScoreNameIDAssoc("friendly",0);
          list.add( pqi = new PageQuestionInfo(1,8,"regular") );
          pqi.addScoreName("drowsy");
          pqi.addScoreNameIDAssoc("drowsy",0);
          list.add( pqi = new PageQuestionInfo(1,12,"regular") );
          pqi.addScoreName("confused");
          pqi.addScoreNameIDAssoc("confused",0);
          list.add( pqi = new PageQuestionInfo(1,1,"regular") );
          pqi.addScoreName("wide awake");
          pqi.addScoreNameIDAssoc("wide awake",0);
          list.add( pqi = new PageQuestionInfo(1,6,"regular") );
          pqi.addScoreName("clumsy");
          pqi.addScoreNameIDAssoc("clumsy",0);
        }
      }
      return pageQuestionsMap;
    }

    private String q10_notes = "";
    private String q3_notes = "";
    private String q5_notes = "";
    private String q7_notes = "";
    private String q2_notes = "";
    private String q9_notes = "";
    private String q11_notes = "";
    private String q4_notes = "";
    private String q8_notes = "";
    private String q12_notes = "";
    private String q1_notes = "";
    private String q6_notes = "";

    public String getQ10_notes() {  return this.q10_notes; }
    public void setQ10_notes(String newValue) {  this.q10_notes = newValue; }
    public String getQ3_notes() {  return this.q3_notes; }
    public void setQ3_notes(String newValue) {  this.q3_notes = newValue; }
    public String getQ5_notes() {  return this.q5_notes; }
    public void setQ5_notes(String newValue) {  this.q5_notes = newValue; }
    public String getQ7_notes() {  return this.q7_notes; }
    public void setQ7_notes(String newValue) {  this.q7_notes = newValue; }
    public String getQ2_notes() {  return this.q2_notes; }
    public void setQ2_notes(String newValue) {  this.q2_notes = newValue; }
    public String getQ9_notes() {  return this.q9_notes; }
    public void setQ9_notes(String newValue) {  this.q9_notes = newValue; }
    public String getQ11_notes() {  return this.q11_notes; }
    public void setQ11_notes(String newValue) {  this.q11_notes = newValue; }
    public String getQ4_notes() {  return this.q4_notes; }
    public void setQ4_notes(String newValue) {  this.q4_notes = newValue; }
    public String getQ8_notes() {  return this.q8_notes; }
    public void setQ8_notes(String newValue) {  this.q8_notes = newValue; }
    public String getQ12_notes() {  return this.q12_notes; }
    public void setQ12_notes(String newValue) {  this.q12_notes = newValue; }
    public String getQ1_notes() {  return this.q1_notes; }
    public void setQ1_notes(String newValue) {  this.q1_notes = newValue; }
    public String getQ6_notes() {  return this.q6_notes; }
    public void setQ6_notes(String newValue) {  this.q6_notes = newValue; }
    
    public void reset(ActionMapping mapping, HttpServletRequest request) {
    }
}
