package clinical.web.helpers;

import java.io.Serializable;
import java.util.LinkedHashMap;

import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: JSURLGenerator.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class JSURLGenerator implements XYURLGenerator, Serializable {
    protected String jsFunctionName = "showInfo";  
    protected int actualSeries= -1;
    protected LinkedHashMap<String, String> indexMap = new LinkedHashMap<String, String>();
	private static final long serialVersionUID = 1L;
	
	public JSURLGenerator(int actualSeries) {
		super();
		this.actualSeries = actualSeries;
	}

	public JSURLGenerator(String jsFunctionName) {
		super();
		this.jsFunctionName = jsFunctionName;
	}

	public JSURLGenerator() {}

	public String generateURL(XYDataset dataset, int series, int item) {
		StringBuffer keyBuf = new StringBuffer();
		keyBuf.append(series).append('_').append(item);
		StringBuffer valueBuf = new StringBuffer();
		valueBuf.append( dataset.getX(series, item)).append('_');
		valueBuf.append(dataset.getY(series, item));
		indexMap.put(keyBuf.toString(), valueBuf.toString());
		StringBuffer buf = new StringBuffer();
		buf.append("onclick=\"").append(jsFunctionName);
		buf.append("(event,this,");
		if ( actualSeries != -1) {
			buf.append(actualSeries);
		} else {
			buf.append(series);
		}
		buf.append(',').append(item);
		buf.append(");\"");
		
		return buf.toString();		
	}

	public LinkedHashMap<String, String> getIndexMap() {
		return indexMap;
	}

	public int getActualSeries() {
		return actualSeries;
	}
}

