package clinical.web.helpers;

import java.util.List;

import clinical.web.common.query.QueryPartInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: StoredQueryDescription.java,v 1.2 2006/05/02 01:01:30 bozyurt
 *          Exp $
 */
public class StoredQueryDescription {
	/* a list of <code>QueryPartInfo</code> objects representing the query */
	protected List<QueryPartInfo> queryParts;
	protected int expID = ExperimentSelector.ALL_EXPERIMENTS;

	public StoredQueryDescription() {
	}

	public StoredQueryDescription(int expID) {
		this.expID = expID;
	}

	public void setExpID(int newExpID) {
		this.expID = newExpID;
	}

	public int getExpID() {
		return this.expID;
	}

	public List<QueryPartInfo> getQueryParts() {
		return queryParts;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer(56);
		buf.append("StoredQueryDescription::[");
		buf.append("expID=").append(expID);
		buf.append(']');
		return buf.toString();
	}

}
