package clinical.web.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import clinical.utils.DateTimeUtils;
import clinical.web.vo.Study;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: StudyFormInfo.java 91 2009-08-17 23:38:26Z bozyurt $
 */

public class StudyFormInfo {
	protected Study study;
	protected String date = "";
	protected String time = "";
	protected String description = "";
	protected String name;
	protected List<SegmentFormInfo> segmentFormInfos = new ArrayList<SegmentFormInfo>(
			2);
	protected boolean dirty = false;
	protected boolean defaultStudy;

	public StudyFormInfo(Study study) {
		this.study = study;
		if (study.getTimeStamp() != null) {
			// get time part from the timestamp
			this.time = DateTimeUtils.extractTimePart(study.getTimeStamp());
			this.date = DateTimeUtils.formatTimestampToDate(study
					.getTimeStamp());
		}
		if (study.getDescription() != null) {
			description = study.getDescription();
		}
		name = study.getName();
	}

	public void setDefaultStudy(boolean newDefaultStudy) {
		this.defaultStudy = newDefaultStudy;
	}

	public boolean isDefaultStudy() {
		return this.defaultStudy;
	}

	public String getDefaultStudyAsString() {
		return String.valueOf(defaultStudy);
	}

	public void clearSegmentFormInfos() {
		segmentFormInfos.clear();
	}

	public void addSegmentFormInfo(SegmentFormInfo sfi) {
		segmentFormInfos.add(sfi);
	}

	public List<SegmentFormInfo> getSegmentFormInfos() {
		return Collections.unmodifiableList(segmentFormInfos);
	}

	public void setDirty(boolean newDirty) {
		this.dirty = newDirty;
	}

	public boolean isDirty() {
		return this.dirty;
	}

	// ---------------------- setters --------------

	public void setTime(String newTime) {
		this.time = newTime;
		// update the Study
		study.setTimeStamp(DateTimeUtils.prepareTimeStamp(DateTimeUtils
				.toTimeStamp(date), time));
		setDirty(true);
	}

	public void setDescription(String newDescription) {
		this.description = newDescription;
		// update the Study
		study.setDescription(this.description);
		setDirty(true);
	}

	public void setName(String newName) {
		this.name = newName;
		// update the Study
		study.setName(this.name);
		setDirty(true);
	}

	// ---------------------- getters --------------
	public String getDate() {
		return this.date;
	}

	public String getTime() {
		return this.time;
	}

	public String getDescription() {
		return this.description;
	}

	public String getName() {
		return this.name;
	}

	public Study getStudy() {
		return this.study;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer(152);
		buf.append("StudyFormInfo::[");
		buf.append("study=").append(study);
		buf.append(", date=").append(date);
		buf.append(", time=").append(time);
		buf.append(", description=").append(description);
		buf.append(", name=").append(name);
		buf.append("\nSegmentFormInfos");
		for (Iterator<SegmentFormInfo> iter = segmentFormInfos.iterator(); iter
				.hasNext();) {
			SegmentFormInfo sfi = iter.next();
			buf.append('\n').append(sfi.toString());
		}
		buf.append(']');
		return buf.toString();
	}
}
