package clinical.web.vo;

import java.text.*;

import org.apache.commons.logging.*;
import clinical.web.Constants;

/**
 * Represents a single assessment value
 * @author I. Burak Ozyurt
 * @version $Id: ScoreValue.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class ScoreValue {
  protected String value;
  protected String displayValue;
  protected String reason;
  protected String name;

  /** 1 based the index of the score value for multiple answer scores*/
  protected int scoreOrder;
  boolean floatType = false;
  protected Integer classification;
  protected Integer entryID;
  protected Integer keyerID;
  protected Integer raterID;

  /* not always set test before using */
  protected String scoreType;
  ScoreValue next = null;

  protected static NumberFormat numberFormat = NumberFormat.getInstance();
  private static Log log = LogFactory.getLog(AssessmentScoreValues.class);

  static {
    numberFormat.setMinimumFractionDigits(2);
    numberFormat.setMaximumFractionDigits(2);
    numberFormat.setGroupingUsed(false);
  }

  public ScoreValue(String name, String value, int scoreOrder) {
    this.name = name;
    this.value = value;
    this.scoreOrder = scoreOrder;
  }

  public ScoreValue(ScoreValue other) {
    name = other.name;
    value = other.value;
    scoreOrder = other.scoreOrder;
    classification = other.classification;
    entryID = other.entryID;
    keyerID = other.keyerID;
    raterID = other.raterID;
    scoreType = other.scoreType;
  }

  public String getName() {
    return name;
  }

  public String getValue() {
    if (value == null) {
      return "";
    }
    if (floatType) {
      try {
        return numberFormat.format(Float.parseFloat(value));
      } catch (NumberFormatException nf) {
        log.error("", nf);
        return "ERR";
      }
    }
    return value;
  }

  public String getDisplayValue() {
    if (value == null) {
      if (classification == null ||
          (reason != null && reason.equals(Constants.MISSING_VALUE_CLASSIFICATION)))
      {
        // missing value
        return "--";
      } else {
        return "*";
      }
    }
    if (floatType) {
      try {
        return numberFormat.format(Float.parseFloat(value));
      } catch (NumberFormatException nf) {
        log.error("", nf);
        return "ERR";
      }
    }
    return value;
  }

  public String getUncorrectedValue() {
    return value;
  }

  public void setReason(String newReason) {
    this.reason = newReason;
  }

  public String getReason() {
    return this.reason;
  }

  public int getScoreOrder() {
    return scoreOrder;
  }

  public void setValue(String newValue) {
    this.value = newValue;
  }

  public void setNext(ScoreValue newNext) {
    this.next = newNext;
  }

  public ScoreValue getNext() {
    return this.next;
  }


  //---------------------- setters --------------
  public void setClassification(Integer newClassification) {
    this.classification = newClassification;
  }

  public void setEntryID(Integer newEntryID) {
    this.entryID = newEntryID;
  }

  public void setKeyerID(Integer newKeyerID) {
    this.keyerID = newKeyerID;
  }

  public void setRaterID(Integer newRaterID) {
    this.raterID = newRaterID;
  }

  public void setScoreType(String newType) {
    this.scoreType = newType;
  }

  //---------------------- getters --------------
  public Integer getClassification() {
    return this.classification;
  }

  public Integer getEntryID() {
    return this.entryID;
  }

  public Integer getKeyerID() {
    return this.keyerID;
  }

  public Integer getRaterID() {
    return this.raterID;
  }

  public String getScoreType() {
    return scoreType;
  }

  public String toString() {
    StringBuffer sb = new StringBuffer(128);
    sb.append("ScoreValue::[");
    sb.append("name=").append(name).append(",value=").append(value);
    if (classification != null) {
      sb.append(",classification=").append(classification);
    }
    if (entryID != null) {
      sb.append(",entryid=").append(entryID);
    }
    sb.append(']');
    return sb.toString();
  }
}
