<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>

<style>
.acb {
  margin-bottom:0.5em;
}

#autoCompleteMenu ul {
  width: 30em;
}
</style>

<script type="text/javascript">
  var helpSystem = null;
  window.addOnLoadListener(onLoadHandler);
  
  function onLoadHandler() {
    var options = [];
    var url = '<html:rewrite page="/help.do?context=as_query"/>';
    helpSystem = new bal.AjaxHelpSystem(url, options);
    handleAnalysisReportsPopulation();
  }
  
</script>
  
<div class="error">
<html:errors/>
</div>

<br>

<script>
 var arqi = <c:out value="${asSelectForm.queryInfo.arqi.asJSON}" escapeXml="false" />;
 
 function handleAnalysisReportsPopulation() {
     var anSelector = $('analysisSel');
     var repSelector = $('reportSel');
     if ( !anSelector) return;
     var aetiList = arqi.aetiList;
     var anSelIdx = 0;
     var repSelIdx = 0;
     if (anSelector.options.length == 0) {
         for(var i = 0; i < aetiList.length; i++) {
             var an = aetiList[i].analysis;
             var option = new Option( an.name, an.id);
             if ( i == 0) { 
               option.selected = true;
               anSelIdx = i;
             }
             try {
               anSelector.add(option,null);
             } catch(e) {
               anSelector.add(option,-1);
             }
             if ( i == 0) {
                for(var j = 0; j <  aetiList[i].exTupleSet.length; j++) {
                   var et = aetiList[i].exTupleSet[j];
                   var opt = new Option(et.name,et.id);
                   try {
                     repSelector.add(opt, null);
                   } catch(e) {
                      repSelector.add(opt, -1);
                   } 
                   if (j == 0) { 
                      opt.selected = true;
                      repSelIdx = j;     
                   }
                }
             }
         }
         prepMeasTypePanel(anSelIdx, repSelIdx, 'mtp');
         prepMGroupNamePanel2(anSelIdx, repSelIdx, 'mgnp');
     }  else {
         var selAnId = anSelector.options[ anSelector.selectedIndex ].value;
         //TODO
     } 
  }
  
  function handleReportChange() {
     var anSelector = $('analysisSel');
     var repSelector = $('reportSel');
     if ( !anSelector) return;
     $('mtp').innerHTML="";
     $('mgnACField').value = '';
     prepMeasTypePanel(anSelector.selectedIndex, repSelector.selectedIndex, 'mtp');
     prepMGroupNamePanel2(anSelector.selectedIndex, repSelector.selectedIndex, 'mgnp');
  }

  function handleAddQueryPart() {
     var anSelector = $('analysisSel');
     var repSelector = $('reportSel');
     if ( !anSelector) return false;
     var mgnACField = $('mgnACField');
     if ( !mgnACField || !mgnACField.value) {
        //TODO validation
		  alert("Empty Field!");
        return false;
     } 
     var etc = findETC(anSelector.selectedIndex, repSelector.selectedIndex);
     if ( etc) {       
       var div = $('qbp');
       for(var i = 0; i < etc.tupleCols.length; i++) {
           var idPrefix = etc.etID + "__" + etc.tupleCols[i].colName + 
              "__" + mgnACField.value;
           var cbId =  etc.etID + "__" + etc.tupleCols[i].colName;  
           var cb = $(cbId);
	   /*
	   if (cb && cb.checked) {
             alert("cbId:" + cbId + " cb:" + cb 
	        + " cb.checked:" + cb.checked
		+ " isValidAnatomicalEntity: " + 
		isAValidAnatomicalEntity(mgnACField.value, etc.etID));
	   } */
           if (cb && cb.checked 
	          && isAValidAnatomicalEntity(mgnACField.value, etc.etID)) {
               var mgQPartPanel = $(mgnACField.value);
               if (!mgQPartPanel) {
                  mgQPartPanel = utils.newDomNode('div',mgnACField.value);
                  div.appendChild(mgQPartPanel);
                  new Insertion.Bottom(mgQPartPanel,
                    "<p><b>" + mgnACField.value + "</b></p>");
               }
               var tc =  etc.tupleCols[i];
               var useConnector = isConnectorRequired();
					addQueryPart(mgQPartPanel,idPrefix, tc.colName, tc.colType, tc.unit, useConnector);	       
           }
       }       
     }
     mgnACField.value = '';
     return false;
  }
  
  function isAValidAnatomicalEntity(ae, etID) {
     var list = arqi.extTuple2MGNameList;
     for(var i = 0; i < list.length; i++) {
         if ( list[i].etID == etID) {
	    var mgNames = list[i].measGroupNames;
	    for(var j = 0; j < mgNames.length; j++)
	       if (mgNames[j] == ae) return true;
	 }
     }
     return false;
  }
  
  function isConnectorRequired() {
     var div = $('qbp');
     var els = div.getElementsByTagName('div');
     if (!els) return false;
     for(var i = 0; i < els.length; i++) {
        var mtDivs = els[i].getElementsByTagName('div');
        for(var j = 0; j < mtDivs.length; j++) {
	   if (mtDivs[j].id) {
	       var toks = mtDivs[j].id.split('__');
	       var etc = (toks) ? findMatchingETC(toks[0]) : null;
	       if (etc) return true;
	   }
	}
     }
     return false;
  }

  function setMGNameField(value) {
     var field = $('mgnACField');
     if (field) {
        field.value = value;
        var div = $('mgnp');
        if (div && div.popupViewer)
           div.popupViewer.hide();
     }
     return false;
  }
  
  function showAllMGNames(evt, elem) {
     if (!elem) return false;
     var mx = 0, my = 0;
     if (!evt) 
       evt = window.event;
     if (evt.pageX || evt.pageY)      {
       mx = evt.pageX;
       my = evt.pageY;
     } else if (evt.clientX || evt.clientY)   {
       mx = evt.clientX + document.body.scrollLeft
         + document.documentElement.scrollLeft;
       my = evt.clientY + document.body.scrollTop
         + document.documentElement.scrollTop;
     }
     var mgNames = findSelectedMGNameList();
     if (!mgNames) return false;
     var content = "<table border='0' cellspacing='0' cellpadding='2'>";
     var noCols = 2;
     var noRows = Math.floor(mgNames.length / noCols);
     if ( (mgNames.length % noCols) > 0) noRows++;
     for(var i = 0; i < noRows; i++) {
        content += "\n<tr>";
        for(var j = 0; j < noCols; j++) {
           content += "<td>";
           var idx = i * noCols + j;
           if ( idx < mgNames.length) { 
              //content += "<a href='javascript:{}'  onclick=\"return setMgNameField('"
              // + mgNames[idx]  + "');\">" + mgNames[idx] + "</a>";
              content += "<a href='#' class='selectionlink' onclick=\"return setMGNameField('"
               + mgNames[idx] + "');\">" + mgNames[idx] + "</a>";
           } else 
           content += "&nbsp;";
           content += "</td>"
        }
        content += "</tr>";
     }
     bal.Popup.showPopup(mx, my, elem.parentNode, content);
     return false;
  }
  
  function buildMGQueryParts() {
     var anSelector = $('analysisSel');
     if ( !anSelector) return;
     var div = $('qbp');
     var els = $A(div.getElementsByTagName('div'));
     if (!els) {
        alert("At least one criterion needs to be specified for querying!");
	     return false;
     }
     var etSet = arqi.aetiList[anSelector.selectedIndex].exTupleSet;
     var mgpiJSON = "{mgQPIList: [";
     var first = true;
    // var desc = "";
    // desc =els.inject(desc, function(s,value, idx) { 
    //     if (value && value.id) s += value.id + "\n"; return s; } );
    // alert("els:" + desc);
	 var count = 0;
    for(var i = 0; i < els.length; i++) {
		 var mgName = els[i].id;
		 if (mgName.indexOf("__") != -1) continue;
		 var mtDivs = els[i].getElementsByTagName('div');	  
		 for(var j = 0; j < mtDivs.length; j++) {
	        if (!mtDivs[j] || !utils.strEndsWith(mtDivs[j].id,"__qp")) continue;
	    //alert("mtDivs[" + j + "]:" + mtDivs[j].id);
	   	 var toks = mtDivs[j].id.split('__');	    
			 var etc = (toks) ? findMatchingETC(toks[0]) : null;
			 if (!etc) continue;                         
        	 var idPrefix = toks[0] + "__" + toks[1] + "__" + mgName;                 
			 var tc = findMatchingTupleCol(etc, toks[1]);
        	 if (!tc) continue;
          if (first) 
				 first = false;
			 else mgpiJSON += ", ";
			 //TODO hardcoded mgName !!
			 mgpiJSON += " {\"tqi\": { mgName: 'anatomicalEntity', ";
			 mgpiJSON += "varName: '" + mgName + "', tupleName:'"; 
			 mgpiJSON +=  findMatchingTupleName(etSet, etc.etID) + "',\n\t ctdi : {";
			 mgpiJSON += "columnName: '" + tc.colName + "', columnType:'";
			 mgpiJSON += tc.colType + "', extendedTupleID:" + etc.etID + "}},\n";
	       
			 mgpiJSON += "connector: '";
			 var andRB = $(idPrefix + "__and");
			 if (andRB) {
				 mgpiJSON += (andRB.checked) ? "AND'," : "OR',";
			 } else {
				 mgpiJSON += "NONE',";
			 }
			 var sel = $(idPrefix + "__operator");
			 mgpiJSON += "operator: " + sel.options[sel.selectedIndex].value;
			 var rhs = $(idPrefix + "__rhs");
			 if (rhs && rhs.value) {
				 var rhsVal = utils.trim(rhs.value);
	       if ( rhsVal.length > 0) 
	          mgpiJSON += ", rhs : '" + rhsVal + "'";		    
	    }
	    var lowBound = $(idPrefix + "__lb");
	    if (lowBound && lowBound.value) {
	       var val = utils.trim(lowBound.value);
	       if ( val.length > 0)  
				 mgpiJSON += ", lowBound: '" + val + "'";
	    }		 
		 var uppBound = $(idPrefix + "__ub");
	    if (uppBound && uppBound.value) {
	       var val = utils.trim(uppBound.value);
	    	 if ( val.length > 0)  
				 mgpiJSON += ", uppBound: '" + val + "'";
	    }  
	    mgpiJSON += "}\n";   
		 count++;
		 }// j
     } //i
     mgpiJSON += "]}\n";
	  if (count == 0) {
		  alert("At least one score is necessary for querying clinical data!");
		  return null;			  
	  }
     // alert(mgpiJSON);
     return mgpiJSON;
  }
  
  function findMatchingTupleName(etID, etSet) {
     for(var i = 0; i < etSet.length; i++) 
		  if (etSet[i].id == etID)
		  	  return etSet[i].name;
	  return null;
  }

  function findMatchingETC(etID) {
     var list = arqi.extTupleColsList;
     for(var i = 0; i < list.length; i++) {
       if (list[i].etID == etID) 
			 return list[i];       
     }
     return null;
  }

  function findMatchingTupleCol(etc, colName) {
    var list = etc.tupleCols;
    for(var i  = 0; i < list.length; i++) {
      if (list[i].colName == colName) 
         return list[i];
    }
    return null;
  }

  function findSelectedMGNameList() {
     var anSelector = $('analysisSel');
     var repSelector = $('reportSel');
     if ( !anSelector) return  null;
     var et = arqi.aetiList[anSelector.selectedIndex].exTupleSet[repSelector.selectedIndex];
     var list = arqi.extTuple2MGNameList;
     for(var i = 0; i < list.length; i++) {
         if (list[i].etID == et.id) 
	    return list[i].measGroupNames;
     }
     return null;
  }
  
  function findETC(anSelIdx, repSelIdx) {
      var et = arqi.aetiList[anSelIdx].exTupleSet[repSelIdx];
      var list = arqi.extTupleColsList;
      for(var i = 0; i < list.length; i++) {
          if (list[i].etID == et.id) {
             return list[i];
          }
      }
      return null;
  }
  
  function prepMeasTypePanel(anSelIdx, repSelIdx, divId) {     
      var etc = findETC(anSelIdx, repSelIdx);
      if ( etc) {
         var div = $(divId);
         var tblEl = buildMTypeTable(etc);
         div.appendChild(tblEl);
         new Insertion.Before(tblEl,"<h3>Measurement Types</h3>");
      }                    
  }
  
  function prepMGroupNamePanel2(anSelIdx, repSelIdx, divId) {
      var et = arqi.aetiList[anSelIdx].exTupleSet[repSelIdx];
      var list = arqi.extTuple2MGNameList;
      var mgnObj = null;
      for(var i = 0; i < list.length; i++) {
          if (list[i].etID == et.id) {
             mgnObj = list[i];
             break;
          }
      }
      if (mgnObj) {
          new Autocompleter.Local('mgnACField', 'autoCompleteMenu', 
            mgnObj.measGroupNames, {choices : 20} );		 
      }             
  }
  
  
  function prepMGroupNamePanel(anSelIdx, repSelIdx, divId) {
      var et = arqi.aetiList[anSelIdx].exTupleSet[repSelIdx];
      var list = arqi.extTuple2MGNameList;
      var mgnObj = null;
      for(var i = 0; i < list.length; i++) {
          if (list[i].etID == et.id) {
             mgnObj = list[i];
             break;
          }
      }
      if (mgnObj) {
         var div = $(divId);
         var tblEl = buildMGroupNameTable(mgnObj);
         div.appendChild(tblEl);
         new Insertion.Before(tblEl,"<div><b>Anatomical Entities</b></div>");
      }       
  }
  
  function buildMTypeTable(etc) {
     var tblEl = utils.newDomNode("table");
     tblEl.setStyle({ "border-width" : "0px", padding: "3px" });
     var noCols = 5;
     var tupleCols = $A(etc.tupleCols);
     // no measurements of type string
     tupleCols = tupleCols.findAll( function(e) { return e.colType != "varchar" } );
     
     var noRows = Math.floor(tupleCols.length / noCols);
     if ( (tupleCols.length % noCols) > 0) noRows++;
     for(var i = 0; i < noRows; i++) {
        var rowEl = utils.newDomNode("tr");
        tblEl.appendChild(rowEl);
        for(var j = 0; j < noCols; j++) {
           var idx = i * noCols + j;
           var colEl = utils.newDomNode("td");
           if ( idx < tupleCols.length) {
               var id = etc.etID + "__" + tupleCols[idx].colName;
               var content = "<input type='checkbox' name='" + id + "' id='" + id + "'>" +  tupleCols[idx].colName;
               colEl.update(content);
           } 
           rowEl.appendChild(colEl);
        }        
     }
     return tblEl;
  }
  
  function buildMGroupNameTable(mgnObj) {
      var tblEl = utils.newDomNode("table");
      tblEl.setStyle({ "border-width" : "0px", padding: "3px" });
      var noCols = 3;
      mgnList =  mgnObj.measGroupNames;
      var noRows = Math.floor(mgnList.length / noCols);
      if ( (mgnList.length % noCols) > 0) noRows++;
      for(var i = 0; i < noRows; i++) {
        var rowEl = utils.newDomNode("tr");
        tblEl.appendChild(rowEl);
        for(var j = 0; j < noCols; j++) {
           var idx = i * noCols + j;
           var colEl = utils.newDomNode("td");
           if ( idx < mgnList.length) {
              var id = mgnObj.etID + "__"  + idx;
              var content = "<input type='checkbox' name='" + id + "' id='" + id + "'>" +  mgnList[idx];
              colEl.update(content);
           }             
           rowEl.appendChild(colEl);
        }
     }//i
     return tblEl;
  }
  
 
  function addQueryPart(container, idPrefix, colName, colType, unit, useConnector) {
     var divId = idPrefix + "__qp";
     if ( $(divId) ) {
       return;
     }
     var div = utils.newDomNode('div', divId);
     container.appendChild(div);
     if ( useConnector) {
        var rbDivId = idPrefix + "__connector";
        var rbDiv = utils.newDomNode('div',rbDivId);
        div.appendChild(rbDiv);
        var andButton = utils.newRadioBut(idPrefix + "__and",rbDivId, "AND","AND",true);
        var orButton = utils.newRadioBut(idPrefix + "__or",rbDivId, "OR","OR",false);
        rbDiv.appendChild(andButton);
        new Insertion.After(andButton,"&nbsp;");
        rbDiv.appendChild(orButton);        
     }
     new Insertion.Bottom(div,colName + " &nbsp;");
     if (colType != 'varchar') {
        var opts = [ {value:1, label:'='}, {value:2, label:'>'} ,
          {value:3, label:'<'}, {value:4, label:'<>'},
          {value:5, label:'>='}, {value:6, label:'<='}];
        var sel = utils.createSelect(idPrefix + "__operator", opts);          
		  div.appendChild( sel );
     
        new Insertion.Bottom(div, "&nbsp; <input type='text' id='" 
        	    + idPrefix + "__rhs' size='8' value='*'></input>");
        var html = "<br> <span style='margin-left:50px; line-height:1.5em;' >" 
          + "Between <input type='text' id='" + idPrefix + "__lb' size='8' value=''>"
          + " and "	 
          +  "<input type='text' id='" + idPrefix + "__ub' size='8' value=''>&nbsp;"
          +  "<input type='button' name='Remove' value='Remove' onclick=\"return qb.removeQueryPart('"
			 + divId + "');\"></input>";
        new Insertion.Bottom(div,html);
     } else {
        var opts = [ {value:1, label:'='}, {value:100, label:'starts with'} ,
          {value:101, label:'ends with'}, {value:102, label:'any of'}];
        var sel = utils.createSelect(idPrefix + "__operator", opts);          
		  div.appendChild( sel );
     
        new Insertion.Bottom(div, "&nbsp; <input type='text' id='" 
        	    + idPrefix + "__rhs' size='12' value='*'></input>");
        
     }
  }
  
  function query(elem) {
     var json = buildMGQueryParts();
	  if(!json) return false;
     elem.form.actionParam.value='query';
     elem.form.queryString.value=json;
     elem.form.submit();
     return false;
  }
  
  function msQuery(elem) {
     var json = buildMGQueryParts();
     if (!json) return false;
     elem.form.actionParam.value='msQuery';
     elem.form.queryString.value=json;
     elem.form.submit();
     return false;   
  }
  
  function changeTab(elem) {
	  var div = $('qbp');
     var els = $A(div.getElementsByTagName('div'));
	  var form = $('qtf');
     if (els && els.length > 0) {
		  var json = buildMGQueryParts();
		  if (json) {
			  form.ddQueryString.value = json;
		  }
	  }
	  form.submit();		
	  return false;	   
  }
</script>

<html:form action="/caquery" styleId="qtf">
<input type="hidden" name="actionParam" value="Show"/>
<input type="hidden" name="ddQueryString" value=""/>  
<div id="tabpanel">
   <ul id="tabs">  
        <c:if test="${asSelectForm.supportAssessmentQuery}">
          <li><a href='javascript:{}' onclick='changeTab(this)'>Assessment</a></li>
        </c:if>
        <li class="activelink"><a href='#' >Analysis</a></li>      
   </ul>
</div>
</html:form>
<html:form action="/analysisresultquery" onsubmit="return false">
<input type="hidden" name="actionParam" value="query"/>
<input type="hidden" name="queryString" value=""/>
<div id="qb_wizard" >
   <div style="text-align:left; padding:0; margin:0; background-color:#ffcc33;  line-height:1.8em; ">
     <span class="mlarge" style="margin:5px;">Analysis Data Query Builder</span><br>
   </div>
   <div style="position:relative; padding-right:30em;">
      <div style="text-align:right; position:absolute; right:0; top:0; width:30em; "> 
         <c:if test="${stateCoordinator.hasMultipleDatabases}">
           <input type="button" class="submit-button" onclick="return msQuery(this);" value="Multi-site Query"></input>&nbsp;            
         </c:if>
         <input type="button" class="submit-button" onclick="return query(this);" value="Query"></input>         
      </div>      
   </div>
    
   <div style="padding:1em;">
    <select id="analysisSel" >          
     </select>
       &nbsp; 
     <select id="reportSel" onchange="handleReportChange()">
      </select>
      <bean:define id="expIDList" name="asSelectForm" property="expSelector.experimentInfos"
          type="java.util.Collection"/>
		<div style="padding-bottom:5px; padding-top:5px;">
        <span class="msmall" style="margin-left:5px;" >Experiment(s):</span>&nbsp;
        <html:select name="asSelectForm" property="expSelector.selectedExpID">
             <html:options collection="expIDList" property="value" labelProperty="label"/>
        </html:select>
      </div>
      <div id="mtp" style="border: solid #00659c 2px; padding: 5px; margin-top: 6px;"></div>
      <div id="mgnp" style="border: solid #00659c 2px; padding: 5px; margin-top: 6px;">
	  <a href="#" onclick="return showAllMGNames(event,this);">Show All Entities</a>
          <p>Start typing to see matching anatomical entities</p>
          <label>AnatomicalEntity:</label>
          <input type="text" id="mgnACField"></input>
          <div id="autoCompleteMenu"></div>
          &nbsp; <input type="button" name="Add to Query" value="Add to Query" 
	     onclick="return handleAddQueryPart();"></input>
	  
      </div>
      <div id="qbp" style="border: solid #00659c 2px; padding: 5px; margin-top: 6px;"></div>
   </div>
   
   <div style="text-align: right; ">
     <c:if test="${stateCoordinator.hasMultipleDatabases}">
       <input type="button" class="submit-button" onclick="return msQuery(this);" value="Multi-site Query"></input>&nbsp;            
     </c:if>
     <input type="button" class="submit-button" onclick="return query(this);" value="Query"></input>          
   </div>
</div>

</html:form>

<script>
     var divElem = $('qb_wizard');
     var options = {color: "#ffcc33", corners: 'top'};
     Rico.Corner.round( divElem, options );
     Rico.Corner.round( divElem,  {color: "#d3d3d3", corners: 'bottom'});
     var tabs = $$('#tabs li');
     tabs.each(
         function(el) { 
            Rico.Corner.round( el,  {color: "#00659c", corners: 'top'}); }
      );
     
</script>
