<%@ page contentType="text/html;charset=UTF-8" language="java"%>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean"%>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt"%>
<%@ page import="clinical.server.VisitInfo"%>

<style>
  #isv  {
      position : absolute;
      width: 300px;
      height: 370px;
      background: #fff;
      z-index: 110;
      border: 1px solid maroon;
      display: block;
   }

   #isv_title {
      position: absolute;
      left: 5px;
      bottom: 20px;
      width: 100%;
      font-size:11px;
      text-align:center;
   }

   #isv img {
      position: absolute;
      margin:0;
      top: 5px;
      left: 22px;
      width: 256px;
      height: 256px;
      border: 0px;
      z-index: 115;
   }

  #overlay {
     background : #000;
     opacity: 0.5;
     position: absolute;
     top: 0px;
     left: 0px;
     width: 100%;
     height: 100%;
     z-index: 100;
     cursor: pointer;
  }

  #slider_track {
     background-image: url(images/track.gif);
     background-repeat: no-repeat;
     background-position: 0px 4px;
     width:175px;
     height:10px;
     cursor:pointer;
     z-index: 120;
  }

  #slider_handle {
     cursor: pointer;
     width:4px;
     height:12px;
     background-color:green;
     z-index: 120;
  }

  #cc { 
     position: absolute;
     top: 270px;
     height:10px;
     padding:0px;
     z-index: 115;
  }
     
  #cc label, #cc #slider_track,
  #cc #slider_value {
     float: left;
     margin-left:18px;
  }

  #slider_value {
     border: 1px solid maroon;
     width:26px;
     font-size: 88%;
     padding: 3px 6px;
  }

</style>
<script type="text/javascript"  src="ImageSeriesViewer.js"></script>
<script type="text/javascript">
   function viewSeries(e) {
	   e = e || window.event;
	   var t = e.target || e.srcElement;
	   var toks = t.id.split('_');
	   var visitId = toks[toks.length -2];
	   var segmentId = toks[toks.length -1];
	   // alert('segmentId:' + segmentId + ' visitId:' + visitId); 
	   
	   var url = '<html:rewrite page="/isviewerdata.do"/>';
	   url += '?visitID=' + visitId + '&segID=' + segmentId;
	   // alert("url:" + url);
	   new ImageSeriesViewer(url,null);
	   return false;
   } 

   function registerViewers() {
	   var anchors = document.getElementsByTagName('a');
	   for(var i = 0; i < anchors.length; i++) {
		   // alert("a:" + anchors[i].id);
		   if (anchors[i].id.indexOf('view_') == 0) {
			   var el = $(anchors[i]);
			   // alert("registering viewer to:" + el.id);
			   el.onclick = viewSeries;
		   }
	   }
   }
   window.addOnLoadListener(registerViewers);
			   
</script>
<br>
<br>
<div class="error"><html:errors /></div>
<center>
<table id="svTable" border="0" cellspacing="0" cellpadding="2"
	bgcolor="#00659" width="80%">
	<tr>
		<td>
		<table border="0" cellspacing="0" width="100%" bgcolor="white">
			<html:form action="/subvisitdetail">
				<tr>
					<td align="left">
					<table border="0" cellspacing="0" width="100%" bgcolor="white">
						<tr>
							<td align="left"><b>Subject:</b>&nbsp;<c:out
								value="${subVisitForm.subjectID}" /></td>
							<td align="right"><c:if
								test="${subVisitForm.showDetail == false}">
								<html:submit property="action" styleClass="submit-button">
									<bean:message key="button.show_detail" />
								</html:submit>
							</c:if> <c:if test="${subVisitForm.showDetail == true}">
								<html:submit property="action" styleClass="submit-button">
									<bean:message key="button.hide_detail" />
								</html:submit>
							</c:if></td>
						</tr>
					</table>
					</td>
				</tr>
			</html:form>
			<%-- clinical visits --%>
			<tr bgcolor="#00659c">
				<td>
				<table border="0" cellspacing="0" width="100%" bgcolor="white">
					<tr bgcolor="#d3d3d3">
						<td colspan="3" class="bheader">Clinical Visits</td>
					</tr>


					<c:forEach var="visit" items="${subVisitForm.clinicalVisits}">
						<tr bgcolor="#00659c">
							<td width="15" class="wheader">&nbsp;</td>
							<td class="wheader">Visit ID</td>
							<td class="wheader">Visit Date</td>
						</tr>

						<tr>
							<td width="15">&nbsp;</td>
							<td><c:out value="${visit.componentID}" /></td>
							<td><c:out value="${visit.timeStamp}" /></td>
						</tr>
						<tr>
							<td width="15">&nbsp;</td>
							<td colspan="2">
							<table border="0" cellspacing="0" cellpadding="0" width="100%">
								<tr bgcolor="#d3d3d3">
									<td colspan="5" class="bheader">Segments</td>
								</tr>

								<c:forEach var="segment" items="${visit.visitSegments}">
									<tr bgcolor="#00659c">
										<td width="15">&nbsp;</td>
										<td class="wheader">Segment ID</td>
										<td class="wheader">Protocol</td>
										<td class="wheader">Protocol Version</td>
										<td class="wheader">Study</td>
									</tr>
									<tr>
										<td width="15">&nbsp;</td>
										<td><c:out value="${segment.segmentID}" /> ( <c:out value="${segment.name}" /> )
										<c:if test="${not empty segment.isdi}">
										   <a id='<c:out value="view_${visit.componentID}_${segment.segmentID}"/>' href="#">&laquo; View</a>
										</c:if>   
										</td>
										<td><c:out value="${segment.protocolID}" /></td>
										<td><c:out value="${segment.protocolVersion}" /></td>
										<c:if test="${not empty segment.studyName}">
											<td><c:out value="${segment.studyName}" /></td>
										</c:if>
										<c:if test="${empty segment.studyName}">
											<td>&nbsp;</td>
										</c:if>
									</tr>

									<%-- assessments section --%>
									<c:if test="${subVisitForm.showDetail == true}">
										<c:if test="${not empty segment.assessmentInfos}">
											<tr>
												<td colspan="5">
												<table border="0" cellspacing="0" width="100%"
													bgcolor="white">

													<tr bgcolor="#d3d3d3">
														<td class="header" colspan="10">Assessments</td>
													</tr>
													<c:forEach var="asi" items="${segment.assessmentInfos}">
														<tr>
															<td colspan="10"><b><c:out value="${asi.name}" /></b>
															</td>
														</tr>

														<bean:define id="svdl" name="segment"
															property="scoreValuesDisplayLayout"
															type="clinical.web.helpers.ScoreValuesDisplayLayout" />

														<c:forEach var="snri" items="${svdl.scoreNameRows}">
															<tr bgcolor="lightblue">
																<c:forEach var="scoreName" items="${snri.scoreNames}">
																	<td align="center"><b><font size="-2"><c:out
																		value="${scoreName}" /></font></b></td>
																</c:forEach>
																<c:if test="${snri.emptyCellCount > 0}">
																	<td colspan="<c:out value="${snri.emptyCellCount}"/>">&nbsp;</td>
																</c:if>
															</tr>

															<tr>
																<c:forEach var="scoreValue" items="${snri.scoreValues}">
																	<c:if test="${not empty scoreValue}">
																		<td align="center"><c:if
																			test="${empty scoreValue.reason}">
																			<c:out value="${scoreValue.displayValue}" />
																		</c:if> <c:if test="${not empty scoreValue.reason}">
																			<abbr title='<c:out value="${scoreValue.reason}"/>'>
																			<c:out value="${scoreValue.displayValue}" /></abbr>
																		</c:if></td>
																	</c:if>
																</c:forEach>
																<c:if test="${snri.emptyCellCount > 0}">
																	<td colspan="<c:out value="${snri.emptyCellCount}"/>">&nbsp;</td>
																</c:if>
															</tr>

															<%-- logic:iterate id="snri" --%>
														</c:forEach>

														<%-- display multi-valued scores --%>
														<c:if test="${not empty svdl.mvScoreGroupLayout}">
															<bean:define id="mvsglBean" name="svdl"
																property="mvScoreGroupLayout"
																type="clinical.web.helpers.MultiValuedScoreGroupLayout" />

															<tr>
																<td colspan="<c:out value="${svdl.columnCount}"/>"><b><u>Multiple
																Valued Scores</u></b></td>
															</tr>

															<tr>
																<td colspan="<c:out value="${svdl.columnCount}"/>">
																<table border="0" cellspacing="0" cellpadding="0"
																	width="100%">

																	<c:forEach var="mvsl"
																		items="${mvsglBean.multiValuedScoreLayouts}">
																		<bean:define id="mvslBean" name="mvsl"
																			type="clinical.web.helpers.MultiValuedScoreLayout" />
																		<tr>
																			<td width="15%">&nbsp; <c:out
																				value="${mvsl.scoreName}" /></td>
																			<c:forEach var="value" items="${mvsl.values}">
																			   <td><c:out value="${value}" />&nbsp;</td>
																			</c:forEach>
																			<%
																			   int remCols = mvsglBean.getColumnSize()
																			                              - mvslBean.getColumnSize();
																			                        for (int i = 0; i < remCols; i++) {
																			%>
																			<td>&nbsp;
																			</td>
																			<%
																			   }
																			%>
																			
																		</tr>
																	</c:forEach>
																</table>
																</td>
															</tr>
															<%-- end of display multi-valued scores --%>
														</c:if>

														<%-- end of logic:iterate id="asi" --%>
													</c:forEach>
												</table>
												<%-- outer table --%></td>
											</tr>
										</c:if>
										<%-- end of <logic:equal name="subVisitForm" property="showDetail" value="true" --%>
									</c:if>
								</c:forEach>

							</table>
							</td>
						</tr>
					</c:forEach>
					<%-- iterate clinicalVisits --%>
				</table>
				</td>
			</tr>
			<%-- end clinicalVisits --%>

			<%-- scan Visits --%>
			<tr bgcolor="#00659c">
				<td>
				<table border="0" cellspacing="0" width="100%" bgcolor="white">
					<tr bgcolor="#d3d3d3">
						<td colspan="3" class="bheader">MRI Scan Visits</td>
					</tr>


					<c:forEach var="visit" items="${subVisitForm.scanVisits}">
						<tr bgcolor="#00659c">
							<td width="15">&nbsp;</td>
							<td class="wheader">Visit ID</td>
							<td class="wheader">Visit Date</td>
						</tr>
						<tr>
							<td width="15">&nbsp;</td>
							<td><c:out value="${visit.componentID}" /></td>
							<td><c:out value="${visit.timeStamp}" /></td>
						</tr>
						<tr>
							<td width="15">&nbsp;</td>
							<td colspan="2">
							<table border="0" cellspacing="0" cellpadding="0" width="100%">
								<tr bgcolor="#d3d3d3">
									<td colspan="5" class="bheader">Segments</td>
								</tr>

								<c:forEach var="segment" items="${visit.visitSegments}">
									<tr bgcolor="#00659c">
										<td width="15">&nbsp;</td>
										<td class="wheader">Segment ID</b></font></td>
										<td class="wheader">Protocol</td>
										<td class="wheader">Protocol Version</td>
										<td class="wheader">Study</td>
									</tr>
									<tr>
										<td width="15">&nbsp;</td>
										<td><c:out value="${segment.segmentID}" />
										<c:if test="${not empty segment.isdi}">
										   <a id='<c:out value="view_${visit.componentID}_${segment.segmentID}"/>' href="#">&laquo; View</a>
										</c:if> 
										</td>
										<td><c:out value="${segment.protocolID}" /></td>
										<td><c:out value="${segment.protocolVersion}" /></td>
										<c:if test="${not empty segment.studyName}">
											<td><c:out value="${segment.studyName}" /></td>
										</c:if>
										<c:if test="${empty segment.studyName}">
											<td>&nbsp;</td>
										</c:if>
									</tr>
									<c:if test="${not empty segment.equipment}">
										<tr>
											<td colspan="5">
											<table border="0" width="100%">
												<bean:define id="equip" name="segment" property="equipment"
													type="clinical.web.vo.CollectionEquipment" />
												<tr bgcolor="#d3d3d3">
													<td><font color="#00659c"><b>Scanner Info</b></font></td>
												</tr>
												<tr>
													<td align="left"><b>Make:</b><c:out
														value="${equip.make}" /> &nbsp; <b>Model:</b><c:out
														value="${equip.model}" /></td>
												</tr>
											</table>
											</td>
										</tr>

									</c:if>

									<%-- assessments section --%>
									<c:if test="${subVisitForm.showDetail == true}">
										<c:if test="${not empty segment.assessmentInfos}">
											<tr>
												<td colspan="5">
												<table border="0" cellspacing="0" width="100%"
													bgcolor="white">

													<tr bgcolor="#d3d3d3">
														<td class="header" colspan="10">Assessments</td>
													</tr>
													<c:forEach var="asi" items="${segment.assessmentInfos}">
														<tr>
															<td colspan="10"><b><c:out value="${asi.name}" /></b>
															</td>
														</tr>

														<bean:define id="svdl" name="segment"
															property="scoreValuesDisplayLayout"
															type="clinical.web.helpers.ScoreValuesDisplayLayout" />

														<c:forEach var="snri" items="${svdl.scoreNameRows}">
															<tr bgcolor="lightblue">
																<c:forEach var="scoreName" items="${snri.scoreNames}">
																	<td align="center"><b><font size="-2"><c:out
																		value="${scoreName}" /></font></b></td>
																</c:forEach>
																<c:if test="${snri.emptyCellCount > 0}">
																	<td colspan="<c:out value="${snri.emptyCellCount}"/>">&nbsp;</td>
																</c:if>
															</tr>

															<tr>
																<c:forEach var="scoreValue" items="${snri.scoreValues}">
																	<c:if test="${not empty scoreValue}">
																		<td align="center"><c:out
																			value="${scoreValue.value}" /></td>
																	</c:if>
																</c:forEach>
																<c:if test="${snri.emptyCellCount > 0}">
																	<td colspan="<c:out value="${snri.emptyCellCount}"/>">&nbsp;</td>
																</c:if>
															</tr>

															<%-- display multi-valued scores --%>
															<c:if test="${not empty svdl.mvScoreGroupLayout}">
																<bean:define id="mvsglBean" name="svdl"
																	property="mvScoreGroupLayout"
																	type="clinical.web.helpers.MultiValuedScoreGroupLayout" />

																<tr>
																	<td colspan="<c:out value="${svdl.columnCount}"/>"><b><u>Multiple
																	Valued Scores</u></b></td>
																</tr>

																<tr>
																	<td colspan="<c:out value="${svdl.columnCount}"/>">
																	<table border="0" cellspacing="0" cellpadding="0"
																		width="100%">

																		<c:forEach var="mvsl"
																			items="${mvsglBean.multiValuedScoreLayouts}">
																			<bean:define id="mvslBean" name="mvsl"
																				type="clinical.web.helpers.MultiValuedScoreLayout" />
																			<tr>
																				<td width="15%">&nbsp; <c:out
																					value="${mvsl.scoreName}" /></td>
																				<c:forEach var="value" items="${mvsl.values}">
																					<td><c:out value="${value}" />&nbsp;
																					</td>
																				</c:forEach>
																				<%
																				   int remCols = mvsglBean.getColumnSize()
																				                                 - mvslBean.getColumnSize();
																				                           for (int i = 0; i < remCols; i++) {
																				%>
																				<td>&nbsp;</td>
																				<%
																				   }
																				%>
																				
																			</tr>
																		</c:forEach>
																	</table>
																	</td>
																</tr>
															</c:if>
															<%-- end of display multi-valued scores --%>

														</c:forEach>

													</c:forEach>
												</table>
												<%-- outer table --%></td>
											</tr>
										</c:if>
										<%-- end of logic:equal name="subVisitForm" property="showDetail" value="true" --%>
									</c:if>
									<c:if test="${subVisitForm.allowMRIDownload == true}">
										<tr>
											<td width="15">&nbsp;</td>
											<td colspan="2" align="left"><bean:define id="imgname"
												name="subVisitForm" property="imageName"
												type="java.lang.String" /> <html:img page="<%=imgname%>" />
											</td>
											<td colspan="2" valign="top">
											<table border="0" cellpadding="0" cellspacing="2"
												width="100%">
												<tr>
													<td width="10">&nbsp;</td>
													<td>
													<p>You can export the image series for this scan as an
													AFNI brik. The image series is retrieved from the SRB,
													converted to an AFNI brik from DICOM and tarred and gziped
													for transfer efficiency.</p>
													This operation may take upto a minute (usually around 30
													seconds or less),so please be patient. If you hit a cached
													result either requested earlier or by another user, this
													operation may take significantly less time.</td>
												</tr>
												<tr>
													<td colspan="2" align="center" height="50"><html:form
														action="/convertafni">
														<html:submit styleClass="submit-button">Download as AFNI BRIK</html:submit>
													</html:form> <html:form action="/browsesrb">
														<html:submit styleClass="submit-button">Browse Image Data</html:submit>
													</html:form></td>
												</tr>
											</table>
											</td>
										</tr>
									</c:if>
									<%-- allowMRIDownload --%>
								</c:forEach>

							</table>
							</td>
						</tr>

					</c:forEach>
					<%-- iterate scanVisits --%>
				</table>
				</td>
			</tr>
			<%-- end of scanVisits--%>
			<html:form action="/viewqueryres">
				<tr>
					<td align="right"><html:submit styleClass="submit-button">Back to Search Results</html:submit>
					</td>
				</tr>
			</html:form>
		</table>
		</td>
	</tr>
</table>
</center>
