 function validateBirnID(elem) {
    var str = elem.value;
    var reg = /^([A-Z]+|\d\d\d\d)\d\d\d\d\d\d\d\d$/;
    return reg.test(str);
 }

 function validateBIRNID(str) {
    var reg = /^([A-Z]+|\d\d\d\d)\d\d\d\d\d\d\d\d$/;
    return reg.test(str);
 }

 function validateTime(str) {
    var reg = /^[0-2]?[0-9]:[0-5][0-9]$/;
    if (reg.test(str) ) {
      var tokens = str.split(":");
      if (tokens[0] <= 23 && tokens[1] <= 59)
        return true;
    }
    return false;
 }

 // mm/dd/yyyy format
 function validateDate(str) {
   var daysOfMonths = new Array(31,28,31,30,31,30,31,31,30,31,30,31);
   var reg = /^[0-1]?[0-9]\/[0-3]?[0-9]\/[0-9][0-9][0-9][0-9]$/;
   if ( reg.test(str) ) {
     var tokens = str.split("/");
     var month = tokens[0];
     var day = tokens[1];
     var year = tokens[2];
     if (month > 12 || day > 31)
        return false;

     if ( month == "2") {
       if ( isLeapYear(year) ) {
         return day <= 29;
       } else {
         return day <= 28;
       }
     } else {
        return day <= daysOfMonths[ month - 1 ];
     }
   }
   return false;
 }

 function isLeapYear(year) {
    if ((year % 4) != 0)
      return false;
    if ( (year % 400) == 0)
	return true;
    if ( (year % 100) == 0)
       return false;
    return true;
 }


function validateFields(form, fieldNames, validations, errMsgs) {
  var fieldNameMap = new Array();
  var nameValidationMap = new Array();
  for(i=0; i < fieldNames.length; ++i) {
     fieldNameMap[ fieldNames[i] ] = errMsgs[i];
     nameValidationMap[ fieldNames[i] ] = validations[i];
  }
  var valMsg = "Please correct the following validation error(s):\n\n";
  var foundErrors = false;
  for(i=0; i < form.elements.length; ++i) {
     if (  fieldNameMap[ form.elements[i].name ] != null) {
         // alert(">> " + form.elements[i].name);
         var validationType = nameValidationMap[ form.elements[i].name ];
         var ok = false;
         if ( validationType == "date") {
            alert("validating date "+ form.elements[i].value);
            ok = validateDate( form.elements[i].value );
         } else if ( validationType == "time") {
            ok = validateTime( form.elements[i].value );
         }
         if (!ok) {
            foundErrors = true;
            valMsg += fieldNameMap[form.elements[i].name ] + "\n";
         }
     }
  }
  if (foundErrors ) {
     alert(valMsg);
     return false;
  }
  return true;
}


 function convertToElementMap(form) {
    var nameElemMap = new Array();
    for(var i=0; i < form.elements.length; ++i) {
      nameElemMap[ form.elements[i].name ] = form.elements[i];
    }
    return nameElemMap;
  }
