package clinical.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: DBChangeSupport.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class DBChangeSupport {
	protected static DBChangeSupport instance = null;
	protected List<DBChangeListener> listeners = Collections
			.synchronizedList(new ArrayList<DBChangeListener>());

	protected DBChangeSupport() {
	}

	public static synchronized DBChangeSupport getInstance() {
		if (instance == null) {
			instance = new DBChangeSupport();
		}
		return instance;
	}

	public void addDBChangeListener(DBChangeListener listener) {
		listeners.add(listener);
	}

	public void fireDBChangeEvent(String siteID, String tableName) {
		fireDBChangeEvent(siteID, new String[] { tableName });
	}

	public void fireDBChangeEvent(String siteID, String[] tableNames) {
		List<String> tbNames = new ArrayList<String>(tableNames.length);
		for (String tn : tableNames) {
			tn = tn.toLowerCase().replaceFirst("^nc_", "");
			tbNames.add(tn);
		}
		DBChange dbChange = new DBChange(siteID);
		for (String tn : tbNames) {
			TableChange tc = new TableChange(tn, TableChange.TABLE_CHANGED);
			dbChange.add(tc);
		}
		DBChangeEvent ev = new DBChangeEvent(dbChange);
		List<DBChangeListener> lsnrs = new ArrayList<DBChangeListener>(
				listeners);
		for (DBChangeListener lsnr : lsnrs) {
			lsnr.dbContentChanged(ev);
		}

	}

	public void fireDBChangeEvent(DBChangeEvent evt) {
		List<DBChangeListener> lsnrs = new ArrayList<DBChangeListener>(
				listeners);
		for (DBChangeListener lsnr : lsnrs) {
			lsnr.dbContentChanged(evt);
		}
	}
}
