package clinical.cache;

import java.io.Serializable;

import org.json.JSONException;
import org.json.JSONObject;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: TableChange.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class TableChange implements Serializable{
	private static final long serialVersionUID = 1L;
	protected String tableName;
	protected int action;
	public final static int ROWS_REMOVED = 1;
	public final static int ROWS_ADDED = 2;
	public final static int ROWS_UPDATED = 3;
	public final static int TABLE_CHANGED = 4;

	public TableChange(String tableName, int action) {
		super();
		this.tableName = tableName;
		this.action = action;
	}

	public String getTableName() {
		return tableName;
	}

	public int getAction() {
		return action;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		js.put("table", tableName);
		js.put("action", action);
		return js;
	}

	public static TableChange fromJSON(JSONObject js) throws JSONException {
		String tableName = js.getString("table");
		int action = js.getInt("action");
		TableChange dbc = new TableChange(tableName, action);
		return dbc;
	}
}
