package clinical.comm;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.jdom.Element;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: Struct.java 91 2009-08-17 23:38:26Z bozyurt $
 */

public class Struct implements IXMLSerializer {
	protected Map<String, IXMLSerializer> members = new LinkedHashMap<String, IXMLSerializer>(
			7);

	public Struct() {
	}

	public void addMember(String name, SimpleDataType sdt) {
		members.put(name, sdt);
	}

	public void addMember(String name, Struct struct) {
		members.put(name, struct);
	}

	public void addMember(String name, Collection col) {
		members.put(name, col);
	}

	public IXMLSerializer getMember(String name) {
		return members.get(name);
	}

	public Element toXML() {
		Element e = new Element("struct");
		for (Map.Entry<String, IXMLSerializer> entry : members.entrySet()) {
			IXMLSerializer ixs =  entry.getValue();
			Element ce = ixs.toXML();
			Element de = new Element("member");
			de.setAttribute("name",  entry.getKey());
			de.addContent(ce);
			e.addContent(de);
		}
		return e;
	}

	public void initializeFromXML(Element e) {
		List<?> children = e.getChildren("member");
		for (Iterator<?> iter = children.iterator(); iter.hasNext();) {
			Element ce = (Element) iter.next();
			String name = ce.getAttributeValue("name");
			Element sve = ce.getChild("simple-var");
			if (sve != null) {
				SimpleDataType sdt = new SimpleDataType();
				sdt.initializeFromXML(sve);
				members.put(name, sdt);
			} else {
				Element se = ce.getChild("struct");
				if (se != null) {
					Struct s = new Struct();
					s.initializeFromXML(se);
					members.put(name, s);
				} else {
					Element cle = ce.getChild("collection");
					if (cle != null) {
						Collection c = new Collection();
						c.initializeFromXML(cle);
						members.put(name, c);
					}

				}
			}
		}
	}

}
