package clinical.server.dao.postgres;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.utils.PostgresUtils;
import clinical.server.vo.Expcomponent;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class ExpcomponentDAO implements clinical.server.dao.ExpcomponentDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public ExpcomponentDAO() {
	}

	public void insert(Connection con, Expcomponent bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_expcomponent VALUES ");
			buf.append('(');
			for (int i = 0; i < 14; ++i) {
				buf.append('?');
				if (i < 13)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getComponentid(), Types.NUMERIC);

			ps.setObject(2, bean.getNcExperimentUniqueid(), Types.NUMERIC);

			ps.setObject(3, bean.getSubjectid(), Types.VARCHAR);

			ps.setObject(4, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(5, bean.getTableid(), Types.NUMERIC);

			ps.setObject(6, bean.getOwner(), Types.NUMERIC);

			ps.setObject(7,
					bean.getModtime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModtime()
									.getTime()));

			ps.setObject(8, bean.getModuser(), Types.NUMERIC);

			ps.setObject(9, bean.getTimeStamp(), Types.TIMESTAMP);

			ps.setObject(10, bean.getDescription(), Types.VARCHAR);

			ps.setObject(11, bean.getVisittype(), Types.VARCHAR);

			ps.setObject(12, bean.getName(), Types.VARCHAR);

			ps.setObject(13, PostgresUtils.toDouble(bean.getTimeinterval()),
					Types.DOUBLE);

			ps.setObject(14, bean.getIstimeinterval());

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(Expcomponent bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("componentid");
		buf.append(',');
		buf.append("nc_experiment_uniqueid");
		buf.append(',');
		buf.append("subjectid");
		buf.append(',');
		buf.append("uniqueid");
		buf.append(',');
		buf.append("tableid");
		buf.append(',');
		buf.append("owner");
		buf.append(',');
		buf.append("modtime");
		buf.append(',');
		buf.append("moduser");
		buf.append(',');
		buf.append("time_stamp");
		buf.append(',');
		buf.append("description");
		buf.append(',');
		buf.append("visittype");
		buf.append(',');
		buf.append("name");
		buf.append(',');
		buf.append("timeinterval");
		buf.append(',');
		buf.append("istimeinterval");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Expcomponent bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getComponentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("componentid=?");
			qi.values.add(bean.getComponentid());
			valueSet = true;
		}
		if (bean.getNcExperimentUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("nc_experiment_uniqueid=?");
			qi.values.add(bean.getNcExperimentUniqueid());
			valueSet = true;
		}
		if (bean.getSubjectid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("subjectid=?");
			qi.values.add(bean.getSubjectid());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("tableid=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("owner=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("modtime=?");
			qi.values.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("moduser=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getTimeStamp() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("time_stamp=?");
			qi.values.add(bean.getTimeStamp());
			valueSet = true;
		}
		if (bean.getDescription() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("description=?");
			qi.values.add(bean.getDescription());
			valueSet = true;
		}
		if (bean.getVisittype() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("visittype=?");
			qi.values.add(bean.getVisittype());
			valueSet = true;
		}
		if (bean.getName() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("name=?");
			qi.values.add(bean.getName());
			valueSet = true;
		}
		if (bean.getTimeinterval() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("timeinterval=?");
			qi.values.add(PostgresUtils.toDouble(bean.getTimeinterval()));
			valueSet = true;
		}
		if (bean.getIstimeinterval() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("istimeinterval=?");
			qi.values.add(bean.getIstimeinterval());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Expcomponent bean,
			Expcomponent criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_expcomponent SET ");
		if (bean.getComponentid() != null || bean.isNull("componentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("componentid=? ");
			uqi.setValues.add(bean.getComponentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("componentid"), uqi);
			valueSet = true;
		}
		if (bean.getNcExperimentUniqueid() != null
				|| bean.isNull("ncExperimentUniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("nc_experiment_uniqueid=? ");
			uqi.setValues.add(bean.getNcExperimentUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("ncExperimentUniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getSubjectid() != null || bean.isNull("subjectid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("subjectid=? ");
			uqi.setValues.add(bean.getSubjectid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("subjectid"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("tableid=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("owner=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("modtime=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("moduser=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getTimeStamp() != null || bean.isNull("timeStamp")) {
			if (valueSet)
				buf.append(", ");
			buf.append("time_stamp=? ");
			uqi.setValues.add(bean.getTimeStamp());
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("timeStamp"), uqi);
			valueSet = true;
		}
		if (bean.getDescription() != null || bean.isNull("description")) {
			if (valueSet)
				buf.append(", ");
			buf.append("description=? ");
			uqi.setValues.add(bean.getDescription());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("description"), uqi);
			valueSet = true;
		}
		if (bean.getVisittype() != null || bean.isNull("visittype")) {
			if (valueSet)
				buf.append(", ");
			buf.append("visittype=? ");
			uqi.setValues.add(bean.getVisittype());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("visittype"), uqi);
			valueSet = true;
		}
		if (bean.getName() != null || bean.isNull("name")) {
			if (valueSet)
				buf.append(", ");
			buf.append("name=? ");
			uqi.setValues.add(bean.getName());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("name"), uqi);
			valueSet = true;
		}
		if (bean.getTimeinterval() != null || bean.isNull("timeinterval")) {
			if (valueSet)
				buf.append(", ");
			buf.append("timeinterval=? ");
			uqi.setValues.add(PostgresUtils.toDouble(bean.getTimeinterval()));
			uqi.sqlTypes.add(new Integer(Types.DOUBLE));
			prepareNullSetListValue(bean.isNull("timeinterval"), uqi);
			valueSet = true;
		}
		if (bean.getIstimeinterval() != null || bean.isNull("istimeinterval")) {
			if (valueSet)
				buf.append(", ");
			buf.append("istimeinterval=? ");
			uqi.setValues.add(bean.getIstimeinterval());
			uqi.sqlTypes.add(new Integer(Types.BOOLEAN));
			prepareNullSetListValue(bean.isNull("istimeinterval"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true)
				: new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public Expcomponent createObject(ResultSet rs) throws SQLException {
		Expcomponent obj = new Expcomponent();
		obj
				.setComponentid((rs.getObject(1) != null) ? new java.math.BigDecimal(
						rs.getObject(1).toString())
						: null);
		obj
				.setNcExperimentUniqueid((rs.getObject(2) != null) ? new java.math.BigDecimal(
						rs.getObject(2).toString())
						: null);
		obj.setSubjectid((String) rs.getObject(3));
		obj.setUniqueid((rs.getObject(4) != null) ? new java.math.BigDecimal(rs
				.getObject(4).toString()) : null);
		obj.setTableid((rs.getObject(5) != null) ? new java.math.BigDecimal(rs
				.getObject(5).toString()) : null);
		obj.setOwner((rs.getObject(6) != null) ? new java.math.BigDecimal(rs
				.getObject(6).toString()) : null);
		obj.setModtime((rs.getObject(7) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(7)).getTime()) : null);
		obj.setModuser((rs.getObject(8) != null) ? new java.math.BigDecimal(rs
				.getObject(8).toString()) : null);
		obj.setTimeStamp((java.sql.Timestamp) rs.getObject(9));
		obj.setDescription((String) rs.getObject(10));
		obj.setVisittype((String) rs.getObject(11));
		obj.setName((String) rs.getObject(12));
		obj.setTimeinterval(PostgresUtils.toFloat(rs.getObject(13)));
		obj.setIstimeinterval((Boolean) rs.getObject(14));
		return obj;
	}

	public List<Expcomponent> find(Connection con, Expcomponent criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Expcomponent> results = new LinkedList<Expcomponent>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_expcomponent ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Expcomponent item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Expcomponent bean, Expcomponent criteria)
			throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Expcomponent criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_expcomponent ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
