package clinical.server.dao.postgres;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Tupleaccess;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class TupleaccessDAO implements clinical.server.dao.TupleaccessDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public TupleaccessDAO() {
	}

	public void insert(Connection con, Tupleaccess bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_tupleaccess VALUES ");
			buf.append('(');
			for (int i = 0; i < 11; ++i) {
				buf.append('?');
				if (i < 10)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getTableid(), Types.NUMERIC);

			ps.setObject(2, bean.getTupleid(), Types.NUMERIC);

			ps.setObject(3, bean.getGrantor(), Types.NUMERIC);

			ps.setObject(4, bean.getGrantee(), Types.NUMERIC);

			ps.setObject(5,
					bean.getModtime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModtime()
									.getTime()));

			ps.setObject(6, bean.getCanRead());

			ps.setObject(7, bean.getCanWrite());

			ps.setObject(8, bean.getCanDelete());

			ps.setObject(9, bean.getCanAdmin());

			ps.setObject(10, bean.getModuser(), Types.NUMERIC);

			ps.setObject(11, bean.getOwner(), Types.NUMERIC);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(Tupleaccess bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("tableid");
		buf.append(',');
		buf.append("tupleid");
		buf.append(',');
		buf.append("grantor");
		buf.append(',');
		buf.append("grantee");
		buf.append(',');
		buf.append("modtime");
		buf.append(',');
		buf.append("can_read");
		buf.append(',');
		buf.append("can_write");
		buf.append(',');
		buf.append("can_delete");
		buf.append(',');
		buf.append("can_admin");
		buf.append(',');
		buf.append("moduser");
		buf.append(',');
		buf.append("owner");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Tupleaccess bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("tableid=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getTupleid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("tupleid=?");
			qi.values.add(bean.getTupleid());
			valueSet = true;
		}
		if (bean.getGrantor() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("grantor=?");
			qi.values.add(bean.getGrantor());
			valueSet = true;
		}
		if (bean.getGrantee() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("grantee=?");
			qi.values.add(bean.getGrantee());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("modtime=?");
			qi.values.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getCanRead() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("can_read=?");
			qi.values.add(bean.getCanRead());
			valueSet = true;
		}
		if (bean.getCanWrite() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("can_write=?");
			qi.values.add(bean.getCanWrite());
			valueSet = true;
		}
		if (bean.getCanDelete() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("can_delete=?");
			qi.values.add(bean.getCanDelete());
			valueSet = true;
		}
		if (bean.getCanAdmin() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("can_admin=?");
			qi.values.add(bean.getCanAdmin());
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("moduser=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("owner=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Tupleaccess bean,
			Tupleaccess criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_tupleaccess SET ");
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("tableid=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getTupleid() != null || bean.isNull("tupleid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("tupleid=? ");
			uqi.setValues.add(bean.getTupleid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tupleid"), uqi);
			valueSet = true;
		}
		if (bean.getGrantor() != null || bean.isNull("grantor")) {
			if (valueSet)
				buf.append(", ");
			buf.append("grantor=? ");
			uqi.setValues.add(bean.getGrantor());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("grantor"), uqi);
			valueSet = true;
		}
		if (bean.getGrantee() != null || bean.isNull("grantee")) {
			if (valueSet)
				buf.append(", ");
			buf.append("grantee=? ");
			uqi.setValues.add(bean.getGrantee());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("grantee"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("modtime=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getCanRead() != null || bean.isNull("canRead")) {
			if (valueSet)
				buf.append(", ");
			buf.append("can_read=? ");
			uqi.setValues.add(bean.getCanRead());
			uqi.sqlTypes.add(new Integer(Types.BOOLEAN));
			prepareNullSetListValue(bean.isNull("canRead"), uqi);
			valueSet = true;
		}
		if (bean.getCanWrite() != null || bean.isNull("canWrite")) {
			if (valueSet)
				buf.append(", ");
			buf.append("can_write=? ");
			uqi.setValues.add(bean.getCanWrite());
			uqi.sqlTypes.add(new Integer(Types.BOOLEAN));
			prepareNullSetListValue(bean.isNull("canWrite"), uqi);
			valueSet = true;
		}
		if (bean.getCanDelete() != null || bean.isNull("canDelete")) {
			if (valueSet)
				buf.append(", ");
			buf.append("can_delete=? ");
			uqi.setValues.add(bean.getCanDelete());
			uqi.sqlTypes.add(new Integer(Types.BOOLEAN));
			prepareNullSetListValue(bean.isNull("canDelete"), uqi);
			valueSet = true;
		}
		if (bean.getCanAdmin() != null || bean.isNull("canAdmin")) {
			if (valueSet)
				buf.append(", ");
			buf.append("can_admin=? ");
			uqi.setValues.add(bean.getCanAdmin());
			uqi.sqlTypes.add(new Integer(Types.BOOLEAN));
			prepareNullSetListValue(bean.isNull("canAdmin"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("moduser=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("owner=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true)
				: new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public Tupleaccess createObject(ResultSet rs) throws SQLException {
		Tupleaccess obj = new Tupleaccess();
		obj.setTableid((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj.setTupleid((rs.getObject(2) != null) ? new java.math.BigDecimal(rs
				.getObject(2).toString()) : null);
		obj.setGrantor((rs.getObject(3) != null) ? new java.math.BigDecimal(rs
				.getObject(3).toString()) : null);
		obj.setGrantee((rs.getObject(4) != null) ? new java.math.BigDecimal(rs
				.getObject(4).toString()) : null);
		obj.setModtime((rs.getObject(5) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(5)).getTime()) : null);
		obj.setCanRead((Boolean) rs.getObject(6));
		obj.setCanWrite((Boolean) rs.getObject(7));
		obj.setCanDelete((Boolean) rs.getObject(8));
		obj.setCanAdmin((Boolean) rs.getObject(9));
		obj.setModuser((rs.getObject(10) != null) ? new java.math.BigDecimal(rs
				.getObject(10).toString()) : null);
		obj.setOwner((rs.getObject(11) != null) ? new java.math.BigDecimal(rs
				.getObject(11).toString()) : null);
		return obj;
	}

	public List<Tupleaccess> find(Connection con, Tupleaccess criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Tupleaccess> results = new LinkedList<Tupleaccess>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_tupleaccess ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Tupleaccess item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Tupleaccess bean, Tupleaccess criteria)
			throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Tupleaccess criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_tupleaccess ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
