package clinical.storage.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.storage.IPlugin;
import clinical.storage.StorageUtils;
import clinical.utils.FileUtils;
import clinical.web.download.FileInfo;
import clinical.web.download.PathWrapper;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: LocalFSPlugin.java 785 2013-03-19 18:20:46Z jinranc $
 */
public class LocalFSPlugin implements IPlugin {

	private Log log = LogFactory.getLog(GridFTPPlugin.class);
	String cacheDir;	
	
	public LocalFSPlugin(Map<String, Object> paramMap) {
		//Jinran added
		cacheDir = (String) paramMap.get("cacheDir");
	}

	@Override
	public List<PathWrapper> load(FileInfo fi) throws Exception {
		String rootDir = "";
		List<PathWrapper> files = new ArrayList<PathWrapper>();
		if (fi.isDir()) {
//			File dir = FileInfo.getFullPathFile(fi, fi.getSourceRootDir());
//			List<File> fileList = FileUtils.getAllFilesUnderDir(dir
//					.getAbsolutePath());
//			for (File file : fileList) {
//				FileInfo nfi = new FileInfo(file.getAbsolutePath(), fi
//						.getFileType(), fi.getStorageType(), rootDir, false);
//
//				files.add(new PathWrapper(nfi.getRelativePath(), rootDir));
//			}
			
			//Jinran
			File dir = FileInfo.getFullPathFile(fi, fi.getSourceRootDir());
			String dirPath = dir.getAbsolutePath();

			FileInfo nfi = new FileInfo(dirPath, fi.getFileType(), fi
					.getStorageType(), fi.getSourceRootDir(), false);

			String relDirPath = nfi.getRelativePath();
			String localPath = FileUtils.createFullPath(cacheDir, relDirPath);
			new File(localPath).mkdirs();

			log.info("**** Copy from '" + fi.getPath() + "' \nto '" + localPath + "'");			
//			this.gfc.downloadFolder(fi.getGridFtpHost() + dir.getAbsolutePath(), new File(localPath),
//					true);			
			File localDir = new File(FileUtils
					.createFullPath(cacheDir, relDirPath));
			
			FileUtils.copyFolder(dir, localDir); //copy to destination
			
			File[] localFilePaths = localDir.listFiles();
			for (int i = 0; i < localFilePaths.length; i++) {
				if (localFilePaths[i].isFile()) {
					String filePath = localFilePaths[i].getAbsolutePath();
					if (filePath.startsWith(cacheDir)) {
						filePath = filePath.substring(cacheDir.length());
						filePath = filePath.replaceFirst("^\\/+", "");
					}
					files.add(new PathWrapper(filePath, nfi.getSourceRootDir()));
				} else {
					StorageUtils.recurseDir(files, localFilePaths[i], cacheDir,
							nfi.getSourceRootDir());
				}
			}
			//Jinran


		} else {
//			FileInfo nfi = new FileInfo(fi.getPath(), fi.getFileType(), fi
//					.getStorageType(), rootDir, false);
//			files.add(new PathWrapper(nfi.getRelativePath(), rootDir));
			
			//Jinran debug starts			
			String relPath = fi.getRelativePath();
			if (FileUtils.buildLocalPath(cacheDir, relPath)) {
				String localPath = FileUtils.createFullPath(cacheDir, relPath);
				log.info("**** Copy from  '" + fi.getPath() + "' \nto '"	+ localPath + "'");				
				FileUtils.copyFile(fi.getPath(), localPath);
				files.add(new PathWrapper(relPath, cacheDir));
			}
			//ends
		}
		return files;
	}

	@Override
	public void shutdown() {
	// no op
	}

	@Override
	public void startup() throws Exception {
	// no op
	}

	public static String getSupportedType() {
		return "local";
	}

	@Override
	public boolean isSupported(String storageType) {
		if (storageType == null)
			return false;
		return storageType.equalsIgnoreCase("local");
	}

	@Override
	public void put(FileInfo localFi, FileInfo remoteFi) throws Exception {
		if (!remoteFi.isDir()) {
			FileUtils.copyFile(localFi.getPath(), remoteFi.getPath());
		} else {
			throw new Exception("target is not a file!:" + remoteFi.getPath());
		}
	}

}
