package clinical.test;

import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;

import junit.framework.TestSuite;

import org.json.JSONObject;

import clinical.server.vo.Tuplecolumns;
import clinical.server.vo.Tuplevarchar;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.IAnalysisResultService;
import clinical.web.ServiceFactory;
import clinical.web.common.query.AnalysisDDQueryBuilder;
import clinical.web.common.query.Operator;
import clinical.web.common.vo.AnalysisResultSummary;
import clinical.web.services.AnalysisResultServiceImpl;
import clinical.web.vo.AnalysisResultQueryInfo;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: AnalysisResultServiceTests.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class AnalysisResultServiceTests extends MyTestCase {

	public AnalysisResultServiceTests(String testName, String propsFile)
			throws IOException {
		super(testName, propsFile, true);
	}

	public AnalysisResultServiceTests(String testName) throws IOException {
		super(testName, "test.properties", true);
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		// bypass database based configuration for tests
		ServiceFactory.setMimimalOpMode(true);
	}

	public void testGetTupleColumnsForET() throws Exception {
		Connection con = null;
		AnalysisResultServiceImpl arsi = null;
		try {
			arsi = new AnalysisResultServiceImpl(getDbID());
			con = getConnection();

			List<String> exTupleNames = new ArrayList<String>(1);
			exTupleNames.add("FreeSurfer volume aseg.stats");
			List<Tuplecolumns> tcList = arsi.getTupleColumnsForET(con,
					exTupleNames);
			assertFalse(tcList.isEmpty());
			for (Tuplecolumns tc : tcList) {
				System.out.println(tc);
			}
		} finally {
			releaseConnection(con);
		}
	}

	public void getMeasurementGroupNamesForET() throws Exception {
		Connection con = null;
		AnalysisResultServiceImpl arsi = null;
		try {
			arsi = new AnalysisResultServiceImpl(getDbID());
			con = getConnection();
			List<Integer> extTupleIDList = new ArrayList<Integer>(2);
			extTupleIDList.add(861);
			List<Tuplevarchar> tvList = arsi.getMeasurementGroupNamesForET(con,
					"anatomicalEntity", extTupleIDList);
			assertFalse(tvList.isEmpty());
			for (Tuplevarchar tv : tvList) {
				System.out.println(tv.getTextvalue());
			}
		} finally {
			releaseConnection(con);
		}
	}

	public void testJSON() throws Exception {
		String json = "{asQPIList: [{ asi: { name: 'Prior and Concomitant Medications', asId:290},"
				+ "score:{ name: 'nJIVMED_CHANGE', type: 'integer'}, connector: 'NONE',operator: 1, rhs : '*'}]}";
		new JSONObject(json);
	}

	public void testJSON2() throws Exception {
	 String json = "{\"asID\":\"11555\",\"hasEnums\":true,\"enums\":[{\"c\":\"1\",\"l\":\"professional or graduate training (received degree)  \"}," +
	 "{\"c\":\"2\",\"l\":\"college graduate \"},{\"c\":\"3\",\"l\":\"some college (at least one year) \"}," +
	 "{\"c\":\"4\",\"l\":\"high school graduate (including GED certificate)  \"}," +
	 "{\"c\":\"5\",\"l\":\"never completed high school \"},{\"c\":\"6\",\"l\":\"elementary school\"}," +
	 "{\"c\":\"7\",\"l\":\"less than 8 years of school\"}],\"scoreName\":\"ses education p_caretaker_prior18\"}";

	 new JSONObject(json);
	}

	public void testAnalysisDDQueryBuilder() throws Exception {
		String json = "{mgQPIList: [{\"tqi\":{mgName: 'anatomicalEntity', varName: 'Cerebral_Cortex',"
				+ "ctdi : {columnName: 'Volume_mm3', columnType:'float', extendedTupleID:613}},"
				+ "connector: 'NONE',operator: 1, rhs : '*'}\n"
				+ ",{\"tqi\":{mgName: 'anatomicalEntity', varName: 'Dura',"
				+ "ctdi : {columnName: 'Volume_mm3', columnType:'float', extendedTupleID:613}},"
				+ "connector: 'AND',operator: 1, rhs : '*'}\n" + "]}";
		JSONObject js = new JSONObject(json);
		AnalysisResultQueryInfo arqi = AnalysisResultQueryInfo
				.initializeFromJSON(js);
		Operator root = arqi.prepareOpTree();
		System.out.println(root.toString());
		AnalysisDDQueryBuilder builder = new AnalysisDDQueryBuilder(
				ServiceFactory.getSQLDialect(getDbID()), null);

		builder.visit(root);
		String query = builder.getQuery();
		System.out.println(GenUtils.applyWordWrapping(query));

		IAnalysisResultService asr = ServiceFactory
				.getAnalysisResultService(getDbID());

		List<AnalysisResultSummary> asrList = asr.queryForAnalysisResults(
				getUi(), root, null, Constants.SEGMENT_SCOPE, "0008");
		for (AnalysisResultSummary ars : asrList) {
			System.out.println(ars);
		}

	}

	public void testAnalysisDDQueryWithFilter() throws Exception {
		String json = "{mgQPIList: [{\"tqi\":{mgName: 'anatomicalEntity', varName: 'Right-Pallidum',"
				+ "ctdi : {columnName: 'Volume_mm3', columnType:'float', extendedTupleID:613}},"
				+ "connector: 'NONE',operator: 2, rhs : '2000.0'}\n" // <
				+ ",{\"tqi\":{mgName: 'anatomicalEntity', varName: 'Right-Amygdala',"
				+ "ctdi : {columnName: 'Volume_mm3', columnType:'float', extendedTupleID:613}},"
				+ "connector: 'AND',operator: 3, rhs : '2000.0'}\n" + "]}"; // >
		JSONObject js = new JSONObject(json);
		AnalysisResultQueryInfo arqi = AnalysisResultQueryInfo
				.initializeFromJSON(js);
		Operator root = arqi.prepareOpTree();
		System.out.println(root.toString());
		AnalysisDDQueryBuilder builder = new AnalysisDDQueryBuilder(
				ServiceFactory.getSQLDialect(getDbID()),null);

		builder.visit(root);
		String query = builder.getQuery();
		System.out.println(GenUtils.applyWordWrapping(query));

		IAnalysisResultService asr = ServiceFactory
				.getAnalysisResultService(getDbID());

		List<AnalysisResultSummary> asrList = asr.queryForAnalysisResults(
				getUi(), root, null, Constants.SEGMENT_SCOPE, "0008");
		for (AnalysisResultSummary ars : asrList) {
			System.out.println(ars);
		}

	}

	public static void dumpOpTree(Operator parent, int level) {
		parent.toString();
	}

	public static TestSuite suite() throws Exception {
		TestSuite suite = new TestSuite();
		// suite.addTest(new
		// AnalysisResultServiceTests("testGetTupleColumnsForET"));
		// suite.addTest(new AnalysisResultServiceTests(
		// "getMeasurementGroupNamesForET"));
		// suite.addTest(new AnalysisResultServiceTests(
		// "testAnalysisDDQueryBuilder"));
		//suite.addTest(new AnalysisResultServiceTests("testJSON"));
		//suite.addTest(new AnalysisResultServiceTests(
		//		"testAnalysisDDQueryWithFilter"));

		suite.addTest(new AnalysisResultServiceTests("testJSON2"));

		return suite;
	}

	public static void main(String[] args) throws Exception {
		junit.textui.TestRunner.run(suite());
	}

}
