package clinical.test;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestSuite;
import clinical.utils.GenUtils;

/**
 * @author I. Burak Ozyurt
 * @version $Id: GenUtilsTest.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class GenUtilsTest extends MyTestCase {
	public GenUtilsTest(String testName, String propsFile) throws IOException {
		super(testName, propsFile);
	}

	protected void setUp() {
	}

	protected void tearDown() throws Exception {
		String filename = getProperty("genutilstest.filename");
		List<File> files = getSerFiles(filename);
		for (Iterator<File> iter = files.iterator(); iter.hasNext();) {
			File file = iter.next();
			file.delete();
		}
	}

	public static List<File> getSerFiles(String filename) {
		List<File> files = new LinkedList<File>();
		File f = new File(filename);
		int idx = 0;
		while (f.exists()) {
			files.add(f);
			++idx;
			f = new File(filename + "." + idx);
		}
		return files;
	}

	public void testSerializeUnique() {
		String filename = getProperty("genutilstest.filename");
		assertNotNull(filename);
		try {
			GenUtils.serialize(filename, filename);
			String resurrected = (String) GenUtils.deserialize(filename);
			assertEquals(filename, resurrected);
			GenUtils.serialize(filename, filename);
			List<File> files = getSerFiles(filename);
			// there must be two file (new serialized file and the backup of the
			// old ser file)
			assertEquals(files.size(), 2);
			String backupFile = null;
			for (Iterator<File> iter = files.iterator(); iter.hasNext();) {
				File file = iter.next();
				if (!file.getAbsolutePath().equals(filename)) {
					backupFile = file.getAbsolutePath();
				}
			}
			assertNotNull(backupFile);
		} catch (Exception x) {
			fail(x.getMessage());
		}
	}

	public static Test suite() throws IOException {
		TestSuite suite = new TestSuite();
		suite
				.addTest(new GenUtilsTest("testSerializeUnique",
						"test.properties"));
		return suite;
		// return new TestSuite( GenUtilsTest.class) ;
	}

	public static void main(String[] args) throws IOException {
		junit.textui.TestRunner.run(suite());
	}
}