package clinical.test;

import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.apache.oro.text.perl.Perl5Util;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.WebTable;

/**
 * @author I. Burak Ozyurt
 * @version $Id: SiteTest.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class SiteTest extends TestCase {
	WebConversation wc = new WebConversation();
	WebResponse firstPage;
	WebResponse initPage;
	TestCaseInfo tci;
	static Perl5Util perl = new Perl5Util();

	public SiteTest(String name) {
		super(name);
	}

	protected void setUp() throws Exception {
		wc = new WebConversation();
		WebRequest req = new GetMethodWebRequest(
				"http://localhost:8081/clinical/");
		firstPage = wc.getResponse(req);
		System.out.println("page title=" + firstPage.getTitle());
		WebLink[] links = firstPage.getLinks();
		for (int i = 0; i < links.length; i++) {
			System.out.println("" + links[i].asText());
		}

		WebLink link = firstPage.getLinkWith("Login");
		if (link != null) {
			link.click();
			WebResponse logPage = wc.getCurrentPage();
			System.out.println("log Page Title:" + logPage.getTitle());
			WebForm form = logPage.getForms()[0];
			String[] paramNames = form.getParameterNames();
			for (int i = 0; i < paramNames.length; i++) {
				System.out.println("param name=" + paramNames[i]);
			}

			form.setParameter("username", "bozyurt");
			form.setParameter("password", "pwd");

			form.submit();

			initPage = wc.getCurrentPage();
			System.out.println(initPage.getTitle());

			FunctionalTestInputLoader ftil = new FunctionalTestInputLoader(
					"/home/bozyurt/dev/java/clinical/conf/func_test.xml");
			ftil.load();
			tci = ftil.getTestCaseInfo("mytestcase1");

		} else {
			fail("Cannot get to the Login page");
		}
	}

	protected void tearDown() throws Exception {
		if (firstPage != null) {
			WebLink logoutLink = firstPage.getLinkWith("Logout");
			assertNotNull(logoutLink);
			logoutLink.click();
		}
	}

	public static String getFirstString(String s) {
		if (perl.match("m/(\\w+(\\s+\\w+)*)/", s)) {
			String p = perl.group(1);
			return p;
		}
		return null;
	}

	void dumpTable(String[][] content) {
		for (int i = 0; i < content.length; i++) {
			System.out.print("Row " + i);
			for (int j = 0; j < content[i].length; j++) {
				System.out.print(" Col " + j + "  " + content[i][j]);
			}
			System.out.println();
		}
	}

	void dumpFormParameters(WebForm form) {
		String[] paramNames = form.getParameterNames();
		for (int i = 0; i < paramNames.length; i++) {
			System.out.println("param name=" + paramNames[i]);
		}
	}

	QueryRequestInfo getAssessmentName(String cellText) {
		for (QueryRequestInfo qri : tci.queryRequestInfoMap.values()) {
			if (qri.getAssessmentName() != null
					&& qri.getAssessmentName().equalsIgnoreCase(cellText)) {
				return qri;
			}
		}
		return null;
	}

	QueryRequestInfo getScoreName(String cellText) {
		for (QueryRequestInfo qri : tci.queryRequestInfoMap.values()) {
			if (qri.getScoreName() != null
					&& qri.getScoreName().equalsIgnoreCase(cellText)) {
				return qri;
			}
		}
		return null;
	}

	public void testQueryForMMSE() throws Exception {
		// String assessmentName = "MMSE";
		// String scoreName = "MMSE Score";

		WebLink qaLink = initPage.getLinkWith("Query Assessments");
		assertNotNull(qaLink);
		qaLink.click();
		WebResponse asSelectPage = wc.getCurrentPage();
		WebForm form = asSelectPage.getForms()[0];
		assertNotNull(form);
		String[] paramNames = form.getParameterNames();
		for (int i = 0; i < paramNames.length; i++) {
			System.out.println("param name=" + paramNames[i]);
		}

		WebTable table = asSelectPage.getTables()[0];
		assertNotNull(table);

		TableCell cell = table.getTableCell(1, 1);
		WebTable asTable = cell.getTables()[0];
		assertNotNull(asTable);
		// dumpTable( asTable.asText());

		int rows = asTable.getRowCount();
		for (int i = 0; i < rows; i++) {
			TableCell anCell = asTable.getTableCell(i, 0);
			QueryRequestInfo qri = null;
			if ((qri = getAssessmentName(anCell.asText().trim())) != null) {
				System.out.println("found " + qri.getAssessmentName());
				form.setCheckbox("asi[" + (i - 1) + "].selected", true);
			}
		}

		form.submit();

		WebResponse scoreSelPage = wc.getCurrentPage();
		System.out.println(scoreSelPage.getTitle());
		table = scoreSelPage.getTables()[0];
		assertNotNull(table);

		cell = table.getTableCell(1, 1);
		cell = cell.getTables()[0].getTableCell(1, 0);

		WebTable scoreTable = cell.getTables()[0];
		assertNotNull(scoreTable);
		// dumpTable( scoreTable.asText() );
		// dumpFormParameters( scoreSelPage.getForms()[0] );
		form = scoreSelPage.getForms()[0];
		rows = scoreTable.getRowCount();
		int asIdx = -1;
		int i = 0;
		QueryRequestInfo qri = null;
		do {
			TableCell tc = scoreTable.getTableCell(i, 0);
			if (scoreTable.getTableCell(i, 0).asText().trim().length() > 0) {
				asIdx++;
			}
			if ((qri = getAssessmentName(tc.asText().trim())) != null) {
				++i;
				TableCell stc = scoreTable.getTableCell(i, 1);
				int sIdx = 0;
				while (i < rows && stc.asText().trim().length() > 0) {
					System.out.println(">> " + stc.asText());
					if ((qri = getScoreName(stc.asText().trim())) != null) {
						String checkBoxName = "score_" + asIdx + "_" + sIdx;
						System.out.println("setting " + checkBoxName);
						form.setCheckbox(checkBoxName, true);
					}
					++sIdx;
					++i;
					if (i < rows) {
						stc = scoreTable.getTableCell(i, 1);
					}
				}
			} else {
				++i;
			}
		} while (i < rows);

		form.submit();
		WebResponse derivedDataPage = wc.getCurrentPage();
		System.out.println(">> " + derivedDataPage.getTitle());
		form = derivedDataPage.getForms()[0];
		assertNotNull("Derived Data Variable selection form does not exists!",
				form);
		form.submit();

		WebResponse colQueryPage = wc.getCurrentPage();
		System.out.println(">> " + colQueryPage.getTitle());

		table = colQueryPage.getTables()[0];

		cell = table.getTableCell(1, 1);
		WebTable queryTable = cell.getTables()[0];
		dumpTable(queryTable.asText());

		form = colQueryPage.getForms()[0];
		dumpFormParameters(form);
		rows = queryTable.getRowCount();
		i = 1;
		int itemCount = 0;
		do {
			TableCell stc = queryTable.getTableCell(i, 1);

			qri = null;
			System.out.println("++>> " + stc.asText().trim());
			boolean inLoop = false;
			while (i < rows && stc.getColSpan() == 1
					&& stc.asText().trim().length() > 0) {
				inLoop = true;
				System.out.println(">> " + stc.asText().trim());
				if ((qri = getScoreName(getFirstString(stc.asText().trim()))) != null) {
					String paramBase = "qp[" + itemCount + "]";
					System.out.println("setting " + paramBase);
					if (qri.getRelQueryRequest() != null) {
						form.setParameter(paramBase + ".operator", String
								.valueOf(qri.getRelQueryRequest().getRelOp())); // "2");
						// // >
						form.setParameter(paramBase + ".rhs", qri
								.getRelQueryRequest().getRhs());
					} else if (qri.getBetweenQueryRequest() != null) {
						form.setParameter(paramBase + ".lowBound", qri
								.getBetweenQueryRequest().getLowBound());
						form.setParameter(paramBase + ".uppBound", qri
								.getBetweenQueryRequest().getUppBound());
					}
					++itemCount;
				}
				++i;
				if (i < rows) {
					stc = queryTable.getTableCell(i, 1);
				}
			}
			if (!inLoop) {
				++i;
			}

		} while (i < rows);

		form.submit();
		WebResponse resultPage = wc.getCurrentPage();
		assertNotNull(resultPage);
		System.out.println(">> " + resultPage.getTitle());

		table = resultPage.getTables()[0];
		cell = table.getTableCell(1, 1);
		WebTable resultTable = cell.getTables()[0];
		// dumpTable( resultTable.asText() );

		int resultTableRowCount = resultTable.getRowCount();
		ResponseInfo resInfo = tci
				.getResponseInfo(resultPage.getTitle().trim());

		if (resInfo != null) {
			String[] expectedTokens = resInfo.getExpectedTokens();
			boolean first = true;
			for (i = 0; i < resultTableRowCount; i++) {
				TableCell tc = resultTable.getTableCell(i, 0);
				if (tc.asText().trim().startsWith("UCSD")) {
					if (first) {
						for (int j = 0; j < expectedTokens.length; ++j) {
							TableCell atc = resultTable.getTableCell(i, j);
							assertEquals(expectedTokens[j], atc.asText().trim());
						}
					}
					first = false;
				}
			}
		} else {
			fail("No Response object found for page with title "
					+ resultPage.getTitle().trim());
		}
	}

	public static TestSuite suite() {
		TestSuite suite = new TestSuite();
		suite.addTest(new SiteTest("testQueryForMMSE"));
		return suite;

	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(suite());
		// String s = SiteTest.getFirstString("MMSE Score ++ >");
		// System.out.println(s);
	}
}
