package clinical.tools.dbadmin;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.FileInfo;
import org.globus.ftp.FileRandomIO;
import org.globus.ftp.GridFTPClient;
import org.globus.ftp.GridFTPSession;
import org.globus.ftp.RetrieveOptions;
import org.globus.ftp.Session;
import org.globus.ftp.exception.ClientException;
import org.globus.ftp.exception.ServerException;
import org.globus.myproxy.MyProxy;
import org.globus.myproxy.MyProxyException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class GridFtpClient {
	protected String gridFTPHost;
	protected String myproxyHost;
	protected int myproxyPort = 7512;
	protected int gridFtpPort = 2811;
	GSSCredential credential = null;
	GridFTPClient client = null;
	boolean verbose = false;

	public GridFtpClient(String gridFTPHost, String myproxyHost,
			int myproxyPort, int gridFtpPort) {
		super();
		this.gridFTPHost = gridFTPHost;
		this.myproxyHost = myproxyHost;
		this.myproxyPort = myproxyPort;
		this.gridFtpPort = gridFtpPort;
		// System.setProperty("GLOBUS_TCP_PORT_RANGE", "50000,51000");
	}

	public GridFtpClient(String gridFTPHost, String myproxyHost) {
		this(gridFTPHost, myproxyHost, 7512, 2811);
	}

	public GridFtpClient(String gridFTPHost) {
		this(gridFTPHost, null, 7512, 2811);
	}

	public void connect(GSSCredential credential) throws ServerException,
			IOException {
		client = new GridFTPClient(gridFTPHost, gridFtpPort);
		client.authenticate(credential);
	}

	public void connect(String username, String pwd) throws MyProxyException,
			GSSException, ServerException, IOException {
		MyProxy proxy = new MyProxy(myproxyHost, 7512);
		credential = proxy.get(username, pwd, 0);
		if (verbose) {
			System.out.println(credential.getName());
		}
		client = new GridFTPClient(gridFTPHost, gridFtpPort);
		client.authenticate(credential);
	}

	public void shutdown() {
		if (client != null) {
			try {
				client.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public List<FileInfoWrapper> getFiles(String remoteDir) throws Exception {
		if (client == null)
			throw new RuntimeException(
					"Not properly initialized! Call connect() first!");
		List<FileInfoWrapper> fiList = new ArrayList<FileInfoWrapper>();
		client.setType(Session.TYPE_IMAGE);
		getFiles(remoteDir, fiList);
		return fiList;
	}

	public static class FileInfoWrapper {
		FileInfo fi;
		String fullPath;

		public FileInfoWrapper(FileInfo fi, String fullPath) {
			this.fi = fi;
			this.fullPath = fullPath;
		}

		public FileInfo getFi() {
			return fi;
		}

		public String getFullPath() {
			return fullPath;
		}

	}// ;

	protected void getFiles(String remoteDir, List<FileInfoWrapper> fiList)
			throws Exception {
		client.setPassive();
		client.setLocalActive();
		int idx = remoteDir.lastIndexOf(".");
		if (idx != -1) {
			// assume file
			File f = new File(remoteDir);
			client.changeDir(f.getParent());
			Vector<?> list = client.list();
			for (Object o : list) {
				FileInfo fi = (FileInfo) o;
				if (fi.getName().equals(f.getName())) {
					FileInfoWrapper fiw = new FileInfoWrapper(fi, remoteDir);
					fiList.add(fiw);
				}
			}
			return;
		}
		try {
			client.changeDir(remoteDir);
			Vector<?> list = client.list();
			for (Object o : list) {
				FileInfo fi = (FileInfo) o;

				if (fi.getName().equals("..") || fi.getName().equals(".")) {
					continue;
				}
				// System.out.println("remoteDir:" + remoteDir);
				FileInfoWrapper fiw = new FileInfoWrapper(fi, new File(remoteDir,
						fi.getName()).getAbsolutePath());
				if (fi.isDirectory()) {
					fiList.add(fiw);
					String rd = new File(remoteDir, fi.getName()).getAbsolutePath();
					getFiles(rd, fiList);
				} else if (fi.isFile()) {
					fiList.add(fiw);
				}
			}
		} catch (Throwable t) {
			System.err.println("Error while getting files from gridftp for dir:"
					+ remoteDir + "\n" + t.getMessage());
		}
	}

	public void putFile(File localFile, String remoteDir)
			throws ServerException, IOException, ClientException {
		if (client == null)
			throw new RuntimeException(
					"Not properly initialized! Call connect() first!");
		client.setType(Session.TYPE_IMAGE);
		client.setMode(GridFTPSession.MODE_EBLOCK);
		long size = localFile.length();
		// 0.5M to 50M
		if (size > 500000L && size <= 50000000L) {
			client.setOptions(new RetrieveOptions(2));
		} else if (size > 50000000L) {
			client.setOptions(new RetrieveOptions(8));
		}

		client.setPassive();
		client.setLocalActive();
		String remoteFile = new File(remoteDir, localFile.getName())
				.getAbsolutePath();
		DataSource source = null;

		try {
			source = new FileRandomIO(new RandomAccessFile(localFile, "r"));
			if (!client.exists(remoteDir)) {
				client.makeDir(remoteDir);
			}
			client.put(remoteFile, source, null);
		} finally {
			if (source != null) {
				source.close();
			}
		}

	}

	@SuppressWarnings("unchecked")
	public void downloadFolder(String destFolder, File localFolder,
			boolean useParallelism) throws ClientException, IOException,
			ServerException {
		client.setType(Session.TYPE_IMAGE);
		if (useParallelism) {
			client.setMode(GridFTPSession.MODE_EBLOCK);
			client.setOptions(new RetrieveOptions(4));
			client.setLocalPassive();
			client.setActive();
		} else {
			client.setPassive();
			client.setLocalActive();
		}

		client.changeDir(destFolder);
		Vector<FileInfo> remDirList = client.list();
		File dest = null;
		File localFile;
		for (FileInfo fi : remDirList) {
			if (fi.getName().equals(".") || fi.getName().equals("..")) {
				continue;
			}
			localFile = new File(localFolder, fi.getName());
			dest = new File(destFolder, fi.getName());
			if (fi.isDirectory()) {
				localFile.mkdirs();
				downloadFolder(dest.getAbsolutePath(), localFile, useParallelism);
			} else {
				downloadFile(dest.getAbsolutePath(), localFile, useParallelism);
			}
		}
	}

	public void downloadFile(String destFile, File localFile,
			boolean useParallelism) throws ClientException, IOException,
			ServerException {
		client.setType(Session.TYPE_IMAGE);
		if (!useParallelism) {
			client.setPassive();
			client.setLocalActive();
			client.get(destFile, localFile);
		} else {
			client.setMode(GridFTPSession.MODE_EBLOCK);
			client.setOptions(new RetrieveOptions(4));
			client.setLocalPassive();
			client.setActive();
			DataSink sink = null;
			try {
				sink = new FileRandomIO(new RandomAccessFile(localFile, "rw"));
				client.get(destFile, sink, null);
			} finally {
				if (sink != null)
					sink.close();
			}
		}
	}

}
