package clinical.upload;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentInfo.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class AssessmentInfo {
  protected String name;
  protected String description;
  protected List<AssessmentScoreInfo> scores = new LinkedList<AssessmentScoreInfo>();
  protected Map<String, AssessmentScoreInfo> scoreMap = new HashMap<String, AssessmentScoreInfo>();

  public AssessmentInfo() {}

  //---------------------- setters --------------
  public void setName(String newName) { this.name = newName; }
  public void setDescription(String newDescription) { this.description = newDescription; }
  //---------------------- getters --------------
  public String getName() { return this.name; }
  public String getDescription() { return this.description; }

  public void addScore(AssessmentScoreInfo asi) {
      scores.add(asi);
      scoreMap.put(asi.getName(), asi);
  }

  public List<AssessmentScoreInfo> getScores() { return scores; }
  public AssessmentScoreInfo getScore(String scoreName) {
    return scoreMap.get(scoreName);
  }

  public String toString() {
    String eol = System.getProperty("line.separator");
    StringBuffer buf = new StringBuffer(128);
    buf.append("AssessmentInfo::[").append("name=").append(name);
    buf.append(",description=").append(description);
    for (Iterator<AssessmentScoreInfo> it = scores.iterator(); it.hasNext(); ) {
      AssessmentScoreInfo ascore = it.next();
      buf.append(eol).append('\t');
      buf.append(ascore.toString());
    }
    buf.append(']');
    return buf.toString();
  }
}
