package clinical.upload;

import guilib.AppFrame;
import guilib.common.BaseDialog;
import guilib.common.FileNameValueField;
import guilib.common.NameComboField;
import guilib.common.NameValueField;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Properties;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

import clinical.utils.GenUtils;
import clinical.utils.NamedUserPool;

public class AssessmentLoaderGUI extends AppFrame implements ActionListener,
      PropertyChangeListener {

   private static final long serialVersionUID = 1L;
   JCheckBox testBox;
   JTextArea logArea = new JTextArea(15, 40);
   DBParamsDialog paramsDlg;
   JButton goButton = new JButton("Go");
   NameValueField birnIDColField;
   FileNameValueField propsFileField;
   NameComboField actionField;
   ConfigurationInfo ci = new ConfigurationInfo();
   NamedUserPool dbPool = null;
   Properties props;
   AssessmentLoader al;

   public AssessmentLoaderGUI(int width, int height) throws Exception {
      super(width, height);
      setTitle("AssessmentLoader");
      init();
      pack();
   }

   protected void init() throws Exception {
      JPanel labelPanel = new JPanel(new GridLayout(4, 1, 3, 3));
      labelPanel.add(new JLabel("BIRN ID Column:", JLabel.RIGHT));
      labelPanel.add(new JLabel("Assessment properties file:", JLabel.RIGHT));
      labelPanel.add(new JLabel("Action:", JLabel.RIGHT));
      testBox = new JCheckBox("Test Run", true);
      labelPanel.add(testBox);

      JPanel fieldPanel = new JPanel(new GridLayout(4, 1, 3, 3));
      fieldPanel.add(birnIDColField = new NameValueField(null, 20));
      fieldPanel.add(propsFileField = new FileNameValueField(null, 20));
      fieldPanel.add(actionField = new NameComboField(null, new String[] {
            "Upload Assessments", "Upload Visits", "Upload Score Values" }));
      goButton.addActionListener(this);
      JPanel p1 = new JPanel(new FlowLayout());
      p1.add(goButton);
      goButton.setEnabled(false);
      fieldPanel.add(p1);

      JPanel panel = new JPanel(new GridLayout(1, 2, 3, 3));
      panel.setBorder(BorderFactory
            .createTitledBorder("Assessment Maintenance"));
      panel.add(labelPanel);
      panel.add(fieldPanel);

      JPanel mainPanel = new JPanel(new BorderLayout(3, 3));
      mainPanel.add(panel, BorderLayout.NORTH);

      logArea.setEditable(false);
      JPanel logPanel = new JPanel(new BorderLayout(3, 3));
      logPanel.setBorder(new TitledBorder("Log"));
      logPanel.add(new JScrollPane(logArea));
      mainPanel.add(logPanel, BorderLayout.SOUTH);

      getContentPane().add(mainPanel);

      String stateFile = System.getProperty("user.home") + File.separator
            + ".assesment_loader_state.ser";
      if (new File(stateFile).exists()) {
         ci = (ConfigurationInfo) GenUtils.deserialize(stateFile);
         if (ci == null)
            ci = new ConfigurationInfo();
      }

      if (ci != null) {
         if (ci.getPropsFile() != null) {
            propsFileField.setValue(ci.getPropsFile());
         }
         if (ci.getBirnIDColumn() != null && ci.getBirnIDColumn().length() > 0) {
            birnIDColField.setValue(ci.getBirnIDColumn());
         }
      }

   }

   public void onOpen() {
      if (paramsDlg == null)
         paramsDlg = new DBParamsDialog(this,
               "Database Connection Information", ci);

      int rc = paramsDlg.showDialog();
      if (rc == BaseDialog.OK_PRESSED) {
         ci = paramsDlg.getConfInfo();

         if (ci.getPwd() == null || ci.getPwd().length() == 0) {

         }
         try {
            if (dbPool != null)
               dbPool.shutdown();

            dbPool = NamedUserPool.getInstance(
                  "oracle.jdbc.driver.OracleDriver", ci.getDbURL());

            goButton.setEnabled(true);
            getStatusBar().setText("database pool is ready.");
         } catch (Exception x) {
            x.printStackTrace();
         }
      }
   }

   public void onClose() {
      if (ci != null) {
         String stateFile = System.getProperty("user.home") + File.separator
               + ".assesment_loader_state.ser";
         try {
            GenUtils.serialize(ci, stateFile);
         } catch (Exception x) {
            x.printStackTrace();
         }
      }

      if (dbPool != null)
         dbPool.shutdown();

      super.onClose();
   }

   protected Properties loadProperties(String filename) throws IOException {
      BufferedInputStream in = null;
      try {
         in = new BufferedInputStream(new FileInputStream(filename));
         Properties p = new Properties();
         p.load(in);
         return p;
      } finally {
         if (in != null)
            try {
               in.close();
            } catch (Exception x) {}
      }

   }

   protected static int mapToAssessmentLoaderCodes(String action) {
      if (action.equals("Upload Assessments")) {
         return AssessmentLoader.UPLOAD_ASSESSMENTS;
      } else if (action.equals("Upload Visits")) {
         return AssessmentLoader.UPLOAD_VISITS;
      } else if (action.equals("Upload Score Values")) {
         return AssessmentLoader.UPLOAD_AS_SCORE_VALUES;
      }
      return -1;
   }

   public void actionPerformed(ActionEvent e) {
      if (e.getSource() == goButton) {
         Connection con = null;
         try {

            ci.setPropsFile(propsFileField.getValue());
            ci.setBirnIDColumn(birnIDColField.getValue());

            props = loadProperties(ci.getPropsFile());

            al = new AssessmentLoader(props);
            al.addPropertyChangeListener(this);

            al.setBirnIDColName(ci.getBirnIDColumn());

            con = dbPool.getConnection(ci.getUser(), ci.getPwd());

            // just test upload
            al.setTestMode(testBox.isSelected());
            // using oracle label security label tag for public:loc,brn

            al.execute(con, mapToAssessmentLoaderCodes(actionField.getValue()),
                  new BigDecimal("11000"));

         } catch (Exception x) {
            x.printStackTrace();
         } finally {
            if (dbPool != null && con != null)
               try {
                  dbPool.releaseConnection(ci.getUser(), con);
               } catch (Exception x) {
                  x.printStackTrace();
               }
         }
      }
   }

   public void propertyChange(PropertyChangeEvent e) {
      if (e.getPropertyName().equals("message")) {
         String val = (String) e.getNewValue();

         if (val != null) {
            String eol = System.getProperty("line.separator");
            logArea.append(val + eol);
         }
      }
   }

   public static void main(String[] args) {
      AssessmentLoaderGUI alg = null;
      try {
         alg = new AssessmentLoaderGUI(500, 400);

         alg.startup();
      } catch (Exception x) {
         x.printStackTrace();
      }
   }

}