package clinical.web;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.List;
import java.util.Collection;

import javax.servlet.http.HttpServletResponse;

import org.apache.struts.util.LabelValueBean;

import clinical.web.helpers.BatchQueryHelper.ClsFileDataRow;

public interface IGeneticService {
	
	public List<SnpList> getAllSnpList() throws Exception;
	
	public void deleteSnpList(String snpName) throws Exception;
	 
	public void addSnpList(BigDecimal sessionId, String snpName, String snpValue) throws Exception;
	
	public void updateSnpList(String oldSnpName, BigDecimal sessionId, String snpName, String snpValue) throws Exception;
	
	
	public List<GeneList> getAllGeneList() throws Exception;
	
	public void deleteGeneList(String geneName) throws Exception;
	 
	public void addGeneList(BigDecimal sessionId, String geneName, String geneValue) throws Exception;
	
	public void updateGeneList(String oldGeneName, BigDecimal sessionId, String geneName, String geneValue) throws Exception;
	
	
	public Collection<GeneticSession> getAllSession() throws Exception;	
	public Collection<GeneticSession> getSessionOnExp(String expName) throws Exception;
	
	
	public Collection<GeneticChip> getAllChips() throws Exception;
	public Collection<GeneticChip> getChipsOnSession(String sessionName) throws Exception;
	
	
	public Collection<LabelValueBean> getUniqueGenomeRelease() throws Exception;
	public Collection<LabelValueBean> getUniqueGenomeReleaseOnSession(String sessionName) throws Exception;

	public void addGeneSession(String sessionName, String sessionDesc, BigDecimal chipId) throws Exception;
	
	public void deleteSession(String sessionName) throws Exception;
	
	//public ResultSet getDataFromGeneTables(String sql) throws Exception;
	public ResultSet getDataFromGeneTables(String sql) throws Exception;
	public void exportFileDataFromGeneTables(String sql, HttpServletResponse response) throws Exception;
	
	public ResultSet getAllSubjectIds(String expName) throws Exception;
	
	//public List<ClsFileDataRow> createDataRowListForPEDFile(String sql, long recordCount) throws Exception;
	public ResultSet createRSForMAPPEDFile(String sql, long recordCount) throws Exception;
	
	public List<ClsFileDataRow> createDataRowListForMAPFile(String sql, long recordCount) throws Exception;
}
