package clinical.web.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.cache.CacheUtils;
import clinical.server.vo.Experiment;
import clinical.server.vo.Storedquery;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
import clinical.web.IAssessmentService;
import clinical.web.IDerivedDataService;
import clinical.web.ServiceFactory;
import clinical.web.SessionStateCoordinator;
import clinical.web.common.AssessmentMapping;
import clinical.web.common.IDBCache;
import clinical.web.common.MediatedQueryHelper;
import clinical.web.common.UserInfo;
import clinical.web.common.query.Operator;
import clinical.web.common.query.ParallelQueryResult;
import clinical.web.common.query.QueryPartInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.exception.BaseException;
import clinical.web.forms.AsQueryBuilderForm;
import clinical.web.forms.SaveQueryForm;
import clinical.web.helpers.ExperimentSelector;
import clinical.web.helpers.QueryWizardHelper;
import clinical.web.helpers.ScoreValueSummary;
import clinical.web.helpers.ScoreValueSummaryHeader;
import clinical.web.helpers.SubCorticalVarInfo;
import clinical.web.services.SecurityService;
import clinical.web.vo.SubjectAsScoreValueSummary;
import clinical.web.vo.SubjectDerivedDataValueSummary;

/**
 * to be deprecated
 * 
 * @author I. Burak Ozyurt
 * @version $Id: AsQueryAction.java 389 2011-07-15 19:27:14Z dbkeator $
 */

public class AsQueryAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(5);
	private Log log = LogFactory.getLog(AsQueryAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("button.query", "doQuery");
		map.put("button.mediated_query", "doQuasiMediatedQuery");
		// map.put("button.mediated_query", "doMediatedQuery");
		map.put("button.previous", "prevPage");
		map.put("button.save_query", "saveQuery");
		return map;
	}

	public AsQueryAction() {
	}

	@SuppressWarnings("unchecked")
	public ActionForward doQuery(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		// MessageResources resources = this.getResources(request);

		IAssessmentService asService = null;
		IDBCache dbCache = null;
		log.debug("**** AsQueryAction");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			asService = ServiceFactory.getAssessmentService(dbID);
			dbCache = ServiceFactory.getDBCache(dbID);

			List<Experiment> experiments = dbCache.getExperiments(ui, false);
			Map<String, Experiment> expMap = toMap(experiments);

			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) session
					.getAttribute(Constants.ASQUERYFORM_KEY);
			String state = queryForm.getState();

			log.info("*** ASQUERYACTION state=" + state);

			if (!queryForm.getState().equals(Constants.COLLECT_QUERY)) {
				throw new BaseException("", "wizard.out_of_order");
			}

			QueryWizardHelper qwHelper = new QueryWizardHelper();
			qwHelper.validateCollectQuery(queryForm, request);
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);

			Operator root = AsQueryHelper.prepareOpTree(queryForm, false);
			ExperimentSelector expSelector = queryForm.getExpSelector();
			List<SubjectAsScoreValueSummary> summaryList = null;
			String queryScope = queryForm.getQueryScopeSelector()
					.getQueryScope();

			if (expSelector != null) {
				int seid = expSelector.getSelectedExpID();
				if (seid == ExperimentSelector.ALL_EXPERIMENTS) {

					summaryList = asService.queryForScores(ui, root, queryForm
							.getAssessments(), queryScope, primarySiteID);
				} else if (seid == ExperimentSelector.ALL_EXPERIMENTS_MINUS_REGRESSION) {
					/** @todo IMPLEMENT REGRESSION finding logic */
					summaryList = asService.queryForScores(ui, root, queryForm
							.getAssessments(), queryScope, primarySiteID);
				} else {
					List<Integer> experimentIDs = new ArrayList<Integer>(1);
					experimentIDs.add(new Integer(seid));
					summaryList = asService.queryForScores(ui, root, queryForm
							.getAssessments(), experimentIDs, queryScope,
							primarySiteID);
				}
			} else {
				summaryList = asService.queryForScores(ui, root, queryForm
						.getAssessments(), queryScope, primarySiteID);
			}
			List<String> uniqueSubjectIds = getUniqueSubjectIds(summaryList);

			// get the derived data also
			IDerivedDataService dService = ServiceFactory
					.getDerivedDataService(dbID);
			List<SubCorticalVarInfo> derivedDataInfos = prepareDerivedDataInfos(queryForm);

			Operator derivedDataQueryOpRoot = AsQueryHelper.prepareOpTree(
					queryForm, true);
			List<SubjectDerivedDataValueSummary> derivedDataSummaryList = null;
			if (derivedDataQueryOpRoot != null
					&& !derivedDataQueryOpRoot.isEmpty()) {
				derivedDataSummaryList = dService
						.getSubCorticalValuesForSubjects(ui, uniqueSubjectIds,
								derivedDataInfos, derivedDataQueryOpRoot);
			}

			ScoreValueSummaryHeader svHeader = new ScoreValueSummaryHeader();
			Map<Integer, List<AssessmentMapping>> siteAsMap = (Map<Integer, List<AssessmentMapping>>) session
					.getServletContext().getAttribute(
							Constants.SITE_ASSESSMENT_MAP_KEY);

			// set site ID to the primary database ID, since only primary
			// database is queried
			SecurityService ss = (SecurityService) ServiceFactory
					.getSecurityService();
			String siteID = ss.getSiteID(dbID);


			for (Iterator<SubjectAsScoreValueSummary> iter = summaryList
					.iterator(); iter.hasNext();) {
				SubjectAsScoreValueSummary sasv = iter.next();
				sasv.setSiteID(siteID);
			}

			IAppConfigService configService = ServiceFactory
					.getAppConfigService();
			boolean allowImageDownload = GenUtils
					.toBoolean(
							configService
									.getParamValue(Constants.ALLOW_FBIRN_IMAGE_DOWNLOAD_PROPERTY),
							false);

			Map<String, AssessmentSelectionInfo> asiMap = AsQueryHelper
					.toAssessmentMap(queryForm.getAssessments(), primarySiteID);

			List<ScoreValueSummary> results = AsQueryHelper
					.processQueryResults(summaryList, asiMap, svHeader,
							derivedDataSummaryList, siteAsMap, dbID, ui,
							allowImageDownload, dbID2SiteIDMap, expMap);

			queryForm.setSasvsList(summaryList);
			summaryList = null;

			// set results to queryForm for display
			queryForm.setSvHeader(svHeader);
			queryForm.setSummaryList(results);

			// FIXME
			// queryForm.getSearchResultsIterator(true);
			
			// for the next step
			// after this point we can start over again
			queryForm.setState(Constants.NONE);
			// reset all user selections so far for queryForm reuse
			queryForm.resetUserSelections();
			// reset the savedQueryLoaded flag
			queryForm.setSavedQueryLoaded(false);

			SessionStateCoordinator ssc = (SessionStateCoordinator) session
					.getAttribute(Constants.SESSION_STATE_COORDINATOR_KEY);
			ssc.setMenuItemState(SessionStateCoordinator.AS_QUERY, true);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public static Map<String, Experiment> toMap(List<Experiment> experiments) {
		Map<String, Experiment> map = new HashMap<String, Experiment>();
		for (Iterator<Experiment> iter = experiments.iterator(); iter.hasNext();) {
			Experiment exp = iter.next();
			map.put(exp.getUniqueid().toString(), exp);
		}
		return map;
	}

	protected void dumpSummaryList(List<SubjectAsScoreValueSummary> summaryList) {
		log.info("**** summary list **** ");
		for (SubjectAsScoreValueSummary sasv : summaryList) {
			log.info(sasv.toString());
		}
		log.info("**** end of summary list **** ");
	}

	public ActionForward prevPage(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			QueryWizardHelper qwHelper = new QueryWizardHelper();

			getUserInfo(request);
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;
			String state = queryForm.getState();

			String prevState = qwHelper.previousPage(queryForm, state);
			log.info("prevState=" + prevState + " state=" + state);

			queryForm.setState(prevState);

			return mapping.findForward(prevState);
		} catch (Exception x) {
			log.error(x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	@SuppressWarnings("unchecked")
	public ActionForward doQuasiMediatedQuery(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.debug("**** AsQueryAction");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) session
					.getAttribute(Constants.ASQUERYFORM_KEY);
			String state = queryForm.getState();

			IDBCache dbCache = ServiceFactory.getDBCache(dbID);
			List<Experiment> experiments = dbCache.getExperiments(ui, false);
			Map<String, Experiment> expMap = toMap(experiments);

			log.debug("*** ASQUERYACTION state=" + state);

			if (queryForm.getState().equals(Constants.NONE)) {
				return mapping.findForward(Constants.SUCCESS);
			} else if (!queryForm.getState().equals(Constants.COLLECT_QUERY)) {
				throw new BaseException("", "wizard.out_of_order");
			}

			QueryWizardHelper qwHelper = new QueryWizardHelper();
			qwHelper.validateCollectQuery(queryForm, request);

			Operator root = AsQueryHelper.prepareOpTree(queryForm, false);
			Map<Integer, List<AssessmentMapping>> siteAsMap = (Map<Integer, List<AssessmentMapping>>) session
					.getServletContext().getAttribute(
							Constants.SITE_ASSESSMENT_MAP_KEY);

			// get the derived data also
			List<SubCorticalVarInfo> derivedDataInfos = prepareDerivedDataInfos(queryForm);

			List<SubjectAsScoreValueSummary> summaryList = null;
			Operator derivedDataQueryOpRoot = AsQueryHelper.prepareOpTree(
					queryForm, true);

			ExperimentSelector expSelector = queryForm.getExpSelector();
			List<Integer> experimentIDs = null;
			if (expSelector != null) {
				int seid = expSelector.getSelectedExpID();
				if (seid == ExperimentSelector.ALL_EXPERIMENTS) {
					// do nothing
				} else if (seid == ExperimentSelector.ALL_EXPERIMENTS_MINUS_REGRESSION) {
					/** @todo IMPLEMENT REGRESSION finding logic */
				} else {
					experimentIDs = new ArrayList<Integer>(1);
					experimentIDs.add(new Integer(seid));
				}
			}
			log.info("doQuasiMediatedQuery: experimentIDs:" + experimentIDs);

			List<SubjectDerivedDataValueSummary> derivedDataSummaryList = null;
			if (derivedDataQueryOpRoot != null
					&& !derivedDataQueryOpRoot.isEmpty()) {

				// do the queries in paralell and join the results
				ParallelQueryResult queryResult = MultiSiteQueryHelper
						.doForkAndJoin(ui, dbID, root, queryForm
								.getAssessments(), siteAsMap, derivedDataInfos,
								derivedDataQueryOpRoot, experimentIDs);

				summaryList = queryResult.getSummaryList();
				derivedDataSummaryList = queryResult
						.getDerivedDataSummaryList();
			} else {

				ParallelQueryResult queryResult = MultiSiteQueryHelper
						.doForkAndJoin(ui, dbID, root, queryForm
								.getAssessments(), siteAsMap, experimentIDs);
				summaryList = queryResult.getSummaryList();
			}

			ScoreValueSummaryHeader svHeader = new ScoreValueSummaryHeader();

			IAppConfigService configService = ServiceFactory
					.getAppConfigService();

			boolean allowImageDownload = GenUtils
					.toBoolean(
							configService
									.getParamValue(Constants.ALLOW_FBIRN_IMAGE_DOWNLOAD_PROPERTY),
							false);

			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();

			String primarySiteID = dbID2SiteIDMap.get(dbID);
			Map<String, AssessmentSelectionInfo> asiMap = AsQueryHelper
					.toAssessmentMap(queryForm.getAssessments(), primarySiteID);

			List<ScoreValueSummary> results = AsQueryHelper
					.processQueryResults(summaryList, asiMap, svHeader,
							derivedDataSummaryList, siteAsMap, dbID, ui,
							allowImageDownload, dbID2SiteIDMap, expMap);

			queryForm.setSasvsList(summaryList);
			// no longer needed let it garbage collected
			summaryList = null;

			// set results to queryForm for display
			queryForm.setSvHeader(svHeader);
			queryForm.setSummaryList(results);
			// FIXME
			// queryForm.getSearchResultsIterator(true);

			// for the next step
			// after this point we can start over again
			queryForm.setState(Constants.NONE);
			// reset all user selections so far for queryForm reuse
			queryForm.resetUserSelections();
			queryForm.setSavedQueryLoaded(false);

			SessionStateCoordinator ssc = (SessionStateCoordinator) session
					.getAttribute(Constants.SESSION_STATE_COORDINATOR_KEY);
			ssc.setMenuItemState(SessionStateCoordinator.AS_QUERY, true);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}

	}

	private List<SubCorticalVarInfo> prepareDerivedDataInfos(
			AsQueryBuilderForm queryForm) {
		List<SubCorticalVarInfo> derivedDataInfos = new LinkedList<SubCorticalVarInfo>();
		for (QueryPartInfo qp : queryForm.getQueryParts()) {
			if (qp.getSubCorticalVarInfo() != null) {
				String laterality = qp.getSubCorticalVarInfo().getLaterality();
				boolean hasLaterality = true;
				if (laterality == null || laterality.trim().length() == 0) {
					laterality = "n/a";
					hasLaterality = false;
				}
				String brname = qp.getSubCorticalVarInfo().getBrainRegionName();
				if (hasLaterality && brname.indexOf(' ') != -1) {
					brname = brname.substring(brname.lastIndexOf(' ') + 1);
				}
				SubCorticalVarInfo sv = new SubCorticalVarInfo(brname,
						laterality, qp.getSubCorticalVarInfo()
								.getMeasurementType(), qp
								.getSubCorticalVarInfo().getUnit());

				derivedDataInfos.add(sv);
			}
		}
		return derivedDataInfos;
	}

	@SuppressWarnings("unchecked")
	public ActionForward doMediatedQuery(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		IAssessmentService asService = null;
		log.debug("**** doMediatesQuery");
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			asService = ServiceFactory.getAssessmentService(dbID);

			IDBCache dbCache = ServiceFactory.getDBCache(dbID);
			List<Experiment> experiments = dbCache.getExperiments(ui, false);
			Map<String, Experiment> expMap = toMap(experiments);

			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) session
					.getAttribute(Constants.ASQUERYFORM_KEY);
			String state = queryForm.getState();

			log.debug("*** ASQUERYACTION state=" + state);

			if (!queryForm.getState().equals(Constants.COLLECT_QUERY)) {
				throw new BaseException("", "wizard.out_of_order");
			}

			QueryWizardHelper qwHelper = new QueryWizardHelper();
			qwHelper.validateCollectQuery(queryForm, request);

			Operator root = AsQueryHelper.prepareOpTree(queryForm, false);

			Map<Integer, List<AssessmentMapping>> siteAsMap = (Map<Integer, List<AssessmentMapping>>) session
					.getServletContext().getAttribute(
							Constants.SITE_ASSESSMENT_MAP_KEY);

			// get the derived data also
			// IDerivedDataService dService =
			// ServiceFactory.getDerivedDataService(dbID);
			List<SubCorticalVarInfo> derivedDataInfos = prepareDerivedDataInfos(queryForm);

			List<SubjectAsScoreValueSummary> summaryList = null;
			List<SubjectDerivedDataValueSummary> derivedDataSummaryList = null;

			Operator derivedDataQueryOpRoot = AsQueryHelper.prepareOpTree(
					queryForm, true);

			if (derivedDataQueryOpRoot != null
					&& !derivedDataQueryOpRoot.isEmpty()) {
				// do the queries in parallel and join the results
				ParallelQueryResult queryResult = MediatedQueryHelper
						.doForkAndJoin(root, queryForm.getAssessments(),
								siteAsMap, derivedDataInfos,
								derivedDataQueryOpRoot, dbID);

				summaryList = queryResult.getSummaryList();
				derivedDataSummaryList = queryResult
						.getDerivedDataSummaryList();
				/*
				 * summaryList = asService.queryMediatorForScores(root,
				 * queryForm.getAssessments(), siteAsMap); List uniqueSubjectIds =
				 * getUniqueSubjectIds( summaryList );
				 *
				 * derivedDataSummaryList =
				 * dService.getMediatedSubCorticalValuesForSubjects(uniqueSubjectIds,
				 * derivedDataInfos, derivedDataQueryOpRoot);
				 */
			} else {
				summaryList = asService.queryMediatorForScores(root, queryForm
						.getAssessments(), siteAsMap);
			}

			ScoreValueSummaryHeader svHeader = new ScoreValueSummaryHeader();

			IAppConfigService configService = ServiceFactory
					.getAppConfigService();

			boolean allowImageDownload = GenUtils
					.toBoolean(
							configService
									.getParamValue(Constants.ALLOW_FBIRN_IMAGE_DOWNLOAD_PROPERTY),
							false);

			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);
			Map<String, AssessmentSelectionInfo> asiMap = AsQueryHelper
					.toAssessmentMap(queryForm.getAssessments(), primarySiteID);

			List<ScoreValueSummary> results = AsQueryHelper
					.processQueryResults(summaryList, asiMap, svHeader,
							derivedDataSummaryList, siteAsMap, dbID, ui,
							allowImageDownload, dbID2SiteIDMap, expMap);

			summaryList = null;

			// set results to queryForm for display
			queryForm.setSvHeader(svHeader);
			queryForm.setSummaryList(results);
			// FIXME
			// queryForm.getSearchResultsIterator(true);
			// for the next step
			// after this point we can start over again
			queryForm.setState(Constants.NONE);
			// reset all user selections so far for queryForm reuse
			queryForm.resetUserSelections();
			queryForm.setSavedQueryLoaded(false);

			SessionStateCoordinator ssc = (SessionStateCoordinator) session
					.getAttribute(Constants.SESSION_STATE_COORDINATOR_KEY);
			ssc.setMenuItemState(SessionStateCoordinator.AS_QUERY, true);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public void cleanupAfterException(HttpServletRequest request,
			HttpServletResponse response, ActionMapping mapping,
			ActionForm form, BaseException be) {
		((AsQueryBuilderForm) form).clean();
	}

	public ActionForward saveQuery(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		IAssessmentService asService;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;

			asService = ServiceFactory.getAssessmentService(dbID);

			SaveQueryForm sqForm = (SaveQueryForm) session
					.getAttribute(Constants.STORED_QUERY_FORM_KEY);
			if (sqForm != null) {
				sqForm.setDescription("");
				sqForm.getStoredQueryDescriptions().clear();
				sqForm.getStoredQueryIdDesc().clear(); //Jinran added
			} else {
				sqForm = new SaveQueryForm();
				session.setAttribute(Constants.STORED_QUERY_FORM_KEY, sqForm);
			}
			List<Storedquery> storedQueries = asService
					.getAvailableStoredQueries(ui, ui.getPerceivedName());
			for (Storedquery sq : storedQueries) {
				sqForm.addStoredQueryDescription(sq.getDescription());				
				sqForm.addStoredQueryIdDesc(sq.getDescription(), sq.getUniqueid()); //Jinran added
			}

			// validate the user query before attempting to persist it.
			QueryWizardHelper qwHelper = new QueryWizardHelper();
			qwHelper.validateCollectQuery(queryForm, request);

			return mapping.findForward(Constants.SAVE_QUERY);

		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	private List<String> getUniqueSubjectIds(
			List<SubjectAsScoreValueSummary> summaryList) {
		List<String> sids = null;
		Map<String, String> sidMap = new TreeMap<String, String>();
		for (Iterator<SubjectAsScoreValueSummary> iter = summaryList.iterator(); iter
				.hasNext();) {
			SubjectAsScoreValueSummary sasv = iter.next();
			if (sidMap.get(sasv.getSubjectID()) == null) {
				sidMap.put(sasv.getSubjectID(), sasv.getSubjectID());
			}
		}
		sids = new ArrayList<String>(sidMap.size());
		for (Iterator<String> iter = sidMap.values().iterator(); iter.hasNext();) {
			String sid = iter.next();
			sids.add(sid);
		}
		return sids;
	}

} // ;
