package clinical.web.actions;

import java.util.Iterator;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.actions.LookupDispatchAction;

import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.web.exception.ExpiredSessionException;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: BaseLookupDispatchAction.java,v 1.8 2005/11/01 18:19:23 bozyurt
 *          Exp $
 */

public class BaseLookupDispatchAction extends LookupDispatchAction {
	protected BaseActionHelper helper = new BaseActionHelper();
	protected Log logger;

	public BaseLookupDispatchAction() {
		super();
		logger = LogFactory.getLog(BaseLookupDispatchAction.class);
	}

	public ActionForward processExceptions(HttpServletRequest request,
			HttpServletResponse response, ActionMapping mapping,
			ActionForm form, Exception x, String forwardName)
			throws ServletException {
		BaseException be = null;
		if (x instanceof BaseException) {
			be = (BaseException) x;
		} else
			be = new BaseException(x);
		return processExceptions(request, response, mapping, form, be,
				forwardName);
	}

	public ActionForward processExceptions(HttpServletRequest request,
			HttpServletResponse response, ActionMapping mapping,
			ActionForm form, Exception x) throws ServletException {
		return processExceptions(request, response, mapping, form, x, null);
	}

	public ActionForward processExceptions(HttpServletRequest request,
			HttpServletResponse response, ActionMapping mapping,
			ActionForm form, BaseException be, String forwardName)
			throws ServletException {
		ActionMessages errors = new ActionMessages();
		ActionForward af = helper.processExceptions(request, response, mapping,
				form, be, errors, forwardName);
		logger.info("saving errors");
		dumpActionErrors(errors);
		super.saveErrors(request, errors);
		return af;
	}

	protected void dumpActionErrors(ActionMessages errors) {
		Iterator<?> it = errors.get();
		while (it.hasNext()) {
			ActionMessage ae = (ActionMessage) it.next();
			logger.info("\t" + ae.getKey());
		}
	}

	public ActionForward processExceptions(HttpServletRequest request,
			HttpServletResponse response, ActionMapping mapping,
			ActionForm form, BaseException be) throws ServletException {
		return processExceptions(request, response, mapping, form, be, null);
	}

	public void checkSessionAndUser(HttpServletRequest request)
			throws ExpiredSessionException {
		helper.checkUser(request);
	}

	public UserInfo getUserInfo(HttpServletRequest request)
			throws ExpiredSessionException {
		return helper.getUserInfo(request);
	}

	protected Map<String, String> getKeyMethodMap() {
		throw new java.lang.UnsupportedOperationException(
				"Method getKeyMethodMap() not yet implemented.");
	}

}
