package clinical.web.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.server.vo.Experiment;
import clinical.server.vo.Humansubject;
import clinical.server.vo.Person;
import clinical.server.vo.Researchgroup;
import clinical.server.vo.Researchgrouptype;
import clinical.server.vo.Subjexperiment;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.IExperimentManagement;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.web.forms.ExperimentManagementForm;
import clinical.web.forms.SubjectVisitManagementForm;
import clinical.web.helpers.StorageTypeSelector;
import clinical.web.helpers.SubjectExperimentsSelector;
import clinical.web.helpers.SubjectManagementHelper;
import clinical.web.vo.ContactPerson;
import clinical.web.vo.ExperimentInfo;
import clinical.web.vo.StudyGroupInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ExperimentManagementAction.java,v 1.11 2006/02/27 22:55:56
 *          bozyurt Exp $
 */
public class ExperimentManagementAction extends BaseLookupDispatchAction {
	protected Map<String, String> map = new HashMap<String, String>(13);

	protected Map<String, String> getKeyMethodMap() {
		map.put("button.exp_update", "updateExperiment");
		map.put("button.show_exp_for_add", "showExperimentForAdd");
		map.put("button.exp_add", "addExperiment");

		map.put("button.subject_show_enroll", "showEnrollSubject");
		map.put("button.subject_unenroll", "unEnrollSubject");
		map.put("button.change_group", "changeSubjectStudyGroup");
		map.put("button.exp_show_update", "showExperimentForUpdate");
		map.put("button.exp_show_find", "showExperimentFind");
		map.put("action.jump_to_subject", "jumpToSelectedSubjectDetail");
		map.put("button.show_add_studygroup", "showAddStudyGroup");
		map.put("button.back2_expman", "backToExpMan");
		return map;
	}

	public ExperimentManagementAction() {}

	public ActionForward updateExperiment(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> updateExperiment");
		IExperimentManagement iem = null;
		ExperimentManagementForm emForm = (ExperimentManagementForm) form;

		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			iem = ServiceFactory.getExperimentManagement(dbID);
			emForm.getExperimentInfo().setStorageType(
					emForm.getStorageTypeSelector().getSelectedStorageType());

			iem.updateExperiment(ui, emForm.getExperimentInfo());

		} catch (Exception x) {
			log.error("updateExperiment", x);
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward(Constants.SUCCESS);
	}

	public ActionForward backToExpMan(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> backToExpMan");
		try {
			// just verify user and forward to Constants.SUCCESS page
			getUserInfo(request);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("backToExpMan", x);
			return processExceptions(request, response, mapping, form, x);
		}

	}

	public ActionForward showAddStudyGroup(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> showAddStudyGroup");
		ExperimentManagementForm emForm = (ExperimentManagementForm) form;

		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			IDBCache dbCache = ServiceFactory.getDBCache(dbID);
			List<Researchgrouptype> rgTypes = dbCache.getResearchGroupTypes(ui,
					true);
			// create an unpopulated StudyGroupInfo object and forward to the
			// add page
			StudyGroupInfo sgi = new StudyGroupInfo();
			sgi.setResearchGroupTypeLVBeans(rgTypes);
			ExperimentInfo ei = emForm.getExperimentInfo();
			sgi.setExperimentID(ei.getId());
			sgi.setExperimentName(ei.getName());

			emForm.setStudyGroupInfo(sgi);
			return mapping.findForward(Constants.SHOW_ADD_STUDYGROUP);
		} catch (Exception x) {
			log.error("showAddStudyGroup", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward showEnrollSubject(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> showEnrollSubject");

		IExperimentManagement iem = null;
		ExperimentManagementForm emForm = (ExperimentManagementForm) form;

		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			iem = ServiceFactory.getExperimentManagement(dbID);
			String selExperimentValue = emForm.getSelectedExperimentValue();
			if (selExperimentValue == null) {
				log.error("selected experimentInfo was null!");
			}

			List<Humansubject> subjects = iem.getRemainingSubjects(ui, Integer
					.parseInt(emForm.getSelectedExperimentValue()));
			//sort subjects by their subjectid 
			Collections.sort(subjects, new Comparator<Object>() {
				public int compare(Object o1, Object o2) {
					Humansubject hs1 = (Humansubject) o1;
					Humansubject hs2 = (Humansubject) o2;
					return hs1.getSubjectid().compareTo(hs2.getSubjectid());
				}
			});
			
			emForm.setAvailableSubjectLVBeans(subjects);

			List<Researchgroup> rgList = ServiceFactory.getDBCache(dbID)
					.getResearchGroups(ui, false);
			ExperimentInfo ei = emForm.getExperimentInfo();
			List<Researchgroup> ergList = new LinkedList<Researchgroup>();
			for (Researchgroup rg : rgList) {
				if (rg.getNcExperimentUniqueid().intValue() == ei.getId()) {
					ergList.add(rg);
				}
			}
			emForm.setAvailableStudyGroupLVBeans(ergList);

			return mapping.findForward(Constants.SHOW_ENROLL_SUBJECT);
		} catch (Exception x) {
			log.error("showEnrollSubject", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward unEnrollSubject(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> unEnrollSubject");

		IExperimentManagement iem = null;
		ExperimentManagementForm emForm = (ExperimentManagementForm) form;

		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			iem = ServiceFactory.getExperimentManagement(dbID);

			int selExpID = emForm.getExperimentInfo().getId();

			int rc = iem.unenrollSubject(ui, selExpID, emForm
					.getEnrolledSubjectValue());
			if (rc == IExperimentManagement.SUCCESS) {

				// to reflect the change in the UI
				ExperimentManagementHelper.prepareEnrolledSubjectStudyGroups(dbID,
						ui, selExpID, emForm);

				return mapping.findForward(Constants.SUCCESS);
			} else if (rc == IExperimentManagement.HAS_VISITS) {
				return mapping.findForward(Constants.CANNOT_UNENROLL);
			} else {
				return mapping.findForward(Constants.FAILURE);
			}
		} catch (Exception x) {
			log.error("unEnrollSubject", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward changeSubjectStudyGroup(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> changeSubjectStudyGroup");

		IExperimentManagement iem = null;
		ExperimentManagementForm emForm = (ExperimentManagementForm) form;

		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			iem = ServiceFactory.getExperimentManagement(dbID);
			String subjectID = emForm.getEnrolledSubjectValue();
			int experimentID = emForm.getExperimentInfo().getId();
			int newStudyID = Integer.parseInt(emForm.getStudyGroupValue());
			// get the old study group id
			Subjexperiment se = ExperimentManagementHelper
					.findSubjectExperimentInfo(subjectID, emForm);

			iem.changeSubjectStudyGroup(ui, experimentID, se
					.getNcResearchgroupUniqueid().intValue(), newStudyID, subjectID);

			// to reflect the change in the UI
			ExperimentManagementHelper.prepareEnrolledSubjectStudyGroups(dbID, ui,
					experimentID, emForm);
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("changeSubjectStudyGroup", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	/**
	 * Triggered when a double click on an enrolled subject in the experiment
	 * detail screen, prepares the selected subject for detail view and forwards
	 * to subject detail page.
	 * 
	 * @param mapping
	 *           Struts ActionMapping
	 * @param form
	 *           the screen's form bean
	 * @param request
	 *           a <code>HttpServletRequest</code> value
	 * @param response
	 *           a <code>HttpServletResponse</code> value
	 * @return an <code>ActionForward</code> holding info about the page to be
	 *         forwarded next
	 * @exception Exception
	 *               if an error occurs
	 */
	public ActionForward jumpToSelectedSubjectDetail(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> jumpToSelectedSubjectDetail");
		ExperimentManagementForm emForm = (ExperimentManagementForm) form;

		try {
			UserInfo ui = getUserInfo(request);
			String subjectID = emForm.getEnrolledSubjectValue();
			log.info("***** subject to jump =" + subjectID);

			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) session
					.getAttribute(Constants.SUBVISITMANAGEMENT_FORM_KEY);

			if (svmForm == null) {
				svmForm = new SubjectVisitManagementForm();
				session
						.setAttribute(Constants.SUBVISITMANAGEMENT_FORM_KEY, svmForm);
			} else {
				// clean the previous state
				svmForm.cleanState();
			}

			String selExpValue = emForm.getSelectedExperimentValue();
			int selExpID = Integer.parseInt(selExpValue);

			SubjectManagementHelper.getExperimentNames(dbID, ui, svmForm,
					subjectID);
			SubjectManagementHelper.prepareCurrentSubject(dbID, ui, subjectID,
					svmForm, selExpID);

			SubjectExperimentsSelector expSelector = new SubjectExperimentsSelector(
					svmForm.getExperiments());
			expSelector.setSelectedExpID(selExpID);
			svmForm.setExpSelector(expSelector);

			/** @todo */

			session.setAttribute(Constants.CURRENT_SUBJECTID_KEY, subjectID);
			return mapping.findForward(Constants.JUMP_TO_SUBJECT);
		} catch (Exception x) {
			log.error("jumpToSelectedSubjectDetail", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	/**
	 * prepares the experiment management screen for update
	 * 
	 * @param mapping
	 *           Struts ActionMapping
	 * @param form
	 *           the screen's form bean
	 * @param request
	 * @param response
	 * @return an <code>ActionForward</code> holding info about the page to be
	 *         forwarded next
	 * @throws java.lang.Exception
	 */
	public ActionForward showExperimentForUpdate(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> showExperimentForUpdate");

		IExperimentManagement iem = null;
		ExperimentManagementForm emForm = (ExperimentManagementForm) form;

		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			iem = ServiceFactory.getExperimentManagement(dbID);
			// first get the experiment id and retrieve the corresponding
			// experiment data from the db
			String expIDStr = emForm.getSelectedExperimentValue();
			boolean needsToSetSessionAttributes = false;
			if (expIDStr == null || expIDStr.length() == 0) {
				// check the session to get the current experiment
				expIDStr = (String) session
						.getAttribute(Constants.CURRENT_EXPERIMENTID_KEY);
			} else {
				needsToSetSessionAttributes = true;
			}
			log.info("*** expIDStr=" + expIDStr);

			int experimentID = Integer.parseInt(expIDStr);
			Experiment experiment = iem.getExperiment(ui, experimentID);
			Person person = iem.getContactPerson(ui, experiment.getContactperson()
					.intValue());
			ExperimentInfo expInfo = new ExperimentInfo(experiment);
			expInfo.setContactPerson(new ContactPerson(person));

			emForm.setExperimentInfo(expInfo);

			if (needsToSetSessionAttributes) {
				session.setAttribute(Constants.CURRENT_EXPERIMENTID_KEY, emForm
						.getSelectedExperimentValue());
				session.setAttribute(Constants.CURRENT_EXPERIMENTNAME_KEY,
						GenUtils.clipString(experiment.getName(), 18));				
				
			}

			// get the enrolled subjects and the study groups also
			ExperimentManagementHelper.prepareEnrolledSubjectStudyGroups(dbID, ui,
					experimentID, emForm);

			prepareContactPersons(dbID, ui, emForm);
			emForm.getExperimentInfo().setContactPersonValue(
					String.valueOf(expInfo.getContactPerson().getUniqueID()));
			// make sure to set current experiment id as the selected experiment
			emForm.setSelectedExperimentValue(expIDStr);

			// cleanup svmForm state if necessary
			SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) session
					.getAttribute(Constants.SUBVISITMANAGEMENT_FORM_KEY);

			if (svmForm != null) {
				svmForm.cleanState();
			}
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("showExperimentForUpdate", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward showExperimentForAdd(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		log.info(">> showExperimentForAdd");

		ExperimentManagementForm emForm = (ExperimentManagementForm) form;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			ExperimentInfo expInfo = new ExperimentInfo();
			emForm.setExperimentInfo(expInfo);
			prepareContactPersons(dbID, ui, emForm);
			prepareStudyGroups(dbID, ui, emForm);
			StorageTypeSelector sts = new StorageTypeSelector();
			if (expInfo.getStorageType() != null) {
				sts.setSelectedStorageType(expInfo.getStorageType());
			}
			emForm.setStorageTypeSelector(sts);

			return mapping.findForward(Constants.SHOW_ADD_EXP);
		} catch (Exception x) {
			log.error("showExperimentForAdd", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward addExperiment(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info(">> addExperiment");
		IExperimentManagement iem = null;
		ExperimentManagementForm emForm = (ExperimentManagementForm) form;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			ExperimentInfo expInfo = emForm.getExperimentInfo();
			
			expInfo.setStorageType(
					emForm.getStorageTypeSelector().getSelectedStorageType());

			
			iem = ServiceFactory.getExperimentManagement(dbID);
			// add the experiment
			int expID = iem.addExperiment(ui, expInfo);
			// update the experiments cache
			List<Experiment> experiments = ServiceFactory.getDBCache(dbID)
					.getExperiments(ui, true);
			for (Experiment exp : experiments) {
				if (exp.getUniqueid().intValue() == expID) {
					// update the ExperimentInfo object from the experiment that
					// is just inserted to the db
					ExperimentInfo ei = new ExperimentInfo(exp);
					emForm.setExperimentInfo(ei);
					ei.setContactPersonValue(expInfo.getContactPersonValue());
					expInfo = ei;
					break;
				}
			}

			expInfo.setId(expID);

			Person person = iem.getContactPerson(ui, Integer.parseInt(expInfo
					.getContactPersonValue()));
			ContactPerson cp = new ContactPerson(person);
			expInfo.setContactPerson(cp);
			ExperimentManagementHelper.prepareEnrolledSubjectStudyGroups(dbID, ui,
					expID, emForm);
			prepareContactPersons(dbID, ui, emForm);
			emForm.getExperimentInfo().setContactPersonValue(
					String.valueOf(expInfo.getContactPerson().getUniqueID()));
			emForm.setSelectedExperimentValue(String.valueOf(expInfo.getId()));

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("addExperiment", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward showExperimentFind(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		IExperimentManagement iem = null;
		ExperimentManagementForm emForm = (ExperimentManagementForm) form;

		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			iem = ServiceFactory.getExperimentManagement(dbID);
			List<Experiment> exps = iem.getAllExperiments(ui);

			emForm.setExperimentLVBeans(exps);

			return mapping.findForward(Constants.SHOW_FIND_EXP);
		} catch (Exception x) {
			log.error("showExperimentFind", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	protected static void prepareContactPersons(String dbID, UserInfo ui,
			ExperimentManagementForm emForm) throws BaseException {
		IExperimentManagement iem = ServiceFactory.getExperimentManagement(dbID);
		List<?> personList = iem.getAllContactPersons(ui);
		List<ContactPerson> cpList = new ArrayList<ContactPerson>(personList
				.size());
		for (Object element : personList) {
			Person person = (Person) element;
			ContactPerson cp = new ContactPerson(person);
			cpList.add(cp);
		}
		emForm.getExperimentInfo().setContactPersonsLVBeans(cpList);
	}

	protected static void prepareStudyGroups(String dbID, UserInfo ui,
			ExperimentManagementForm emForm) throws BaseException {
		IDBCache dbCache = ServiceFactory.getDBCache(dbID);
		List<Researchgroup> studyGroups = dbCache.getResearchGroups(ui, false);
		emForm.setStudyGroupsToSelect(studyGroups);
	}
}
