package clinical.web.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.io.*;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.*;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.json.JSONArray;
import org.json.JSONObject;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.TagFromName;

import clinical.server.SelectedFileInfo;
import clinical.server.dao.ExperimentDAO;
import clinical.server.dao.ReceivedfilesDAO;
import clinical.server.dao.ReceivedfilesdcmtagDAO;
import clinical.server.vo.Experiment;
import clinical.server.vo.Receivedfiles;
import clinical.server.vo.Receivedfilesdcmtag;
import clinical.web.Constants;
import clinical.web.DAOFactory;
import clinical.web.MinimalServiceFactory;
import clinical.web.common.IDBPoolService;
import clinical.web.common.UserInfo;
import clinical.web.download.Packager;
import clinical.web.download.PathWrapper;
import clinical.web.forms.ProcessExtraFile;
import clinical.web.services.ImagingFileService;

public class ProcessExtraFileAction extends BaseLookupDispatchAction {
	protected Map<String, String> map = new HashMap<String, String>(7);
	private Log log = LogFactory.getLog(ProcessFileAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.pef.processing", "processing");
		return map;
	}

	public ActionForward processing(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		try {
			String extraFileInfos = request.getParameter("completeRows");
			JSONObject json = new JSONObject(extraFileInfos);
			JSONArray extraJsArr = json.getJSONArray("fileValues");
			
			/******************************************************************************/
			/***********************  Additional File Upload ******************************/
			/******************************************************************************/
			ProcessExtraFile peForm = (ProcessExtraFile) form;						 
		    List<FormFile> fileList = peForm.getUploadFiles();
		    String filePath = "/data/upload";
		    //FormFile formFile = processExtraFileForm.getFile();
		    String tempFilePath = 
		               getServlet().getServletContext().getRealPath("/") +"upload";
		    
		    //create the upload folder if not exists
		    File extraFolder = new File(tempFilePath);
		    if(!extraFolder.exists()){
		    	if(!extraFolder.mkdir()){
		    		log.error("Temporary Upload File Directory '" + tempFilePath + "' cannot be created!");
					return processExceptions(request, response, mapping, form,
							new Exception("Directory " + tempFilePath + " cannot be created!"));
		    	}
		    }
	 
		    for(FormFile file : fileList){
		    	String fileName = file.getFileName();
		    	 
			    if(!fileName.equals("")){
			        log.info("Temp File Path: " +tempFilePath);
			        //replace space in file name with "_"
			        fileName = fileName.replaceAll(" ", "_");
			        File newFile = new File(tempFilePath, fileName);
		 
			        if(!newFile.exists()){
			          FileOutputStream fos = new FileOutputStream(newFile);
			          fos.write(file.getFileData());
			          fos.flush();
			          fos.close();
			        }
			        
			        request.setAttribute("uploadedFilePath",newFile.getAbsoluteFile());
			        request.setAttribute("uploadedFileName",newFile.getName());
			    }		    	
		    }
		    /******************************************************************************/
		    
		    /******************************************************************************/
		    /***************     Start to Upload Files          ***************************/
		    /******************************************************************************/
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			ImagingFileService ifs = new ImagingFileService(dbID);

			// 1st, Create target directory where data files will be copied to
			// 2nd, Tar up Dicom files to the target directory
			// 3rd, Insert file info to nc_rawdata table
			List<Receivedfiles> selFiles = new LinkedList<Receivedfiles>();
			String dicomFileDir = peForm.getDicomFileDir();
			JSONArray jsArr = peForm.getJsaSelectedFiles();

			for (int i = 0; i < jsArr.length(); i++) {
				JSONObject jsObj = jsArr.getJSONObject(i);

				SelectedFileInfo selRow = new SelectedFileInfo();
				selRow.setPatientid(jsObj.getString("patientid"));
				selRow.setSubjectId(jsObj.getString("subjectId"));
				selRow.setExpId(jsObj.getString("expId"));
				selRow.setExpName(getExpNameById(dbID, selRow, ui));
				selRow.setVisit(jsObj.getString("visit"));
				selRow.setProtocol(jsObj.getString("protocol"));
				selRow.setStudy(jsObj.getString("study"));
				selRow.setSeriesdate(jsObj.getString("seriesdate"));
				selRow.setSeriesdescription(jsObj
						.getString("seriesdescription"));
				selRow.setSeriestime(jsObj.getString("seriestime"));				
				selRow.setSeriesnumber(jsObj.getString("seriesnumber"));

				/********************************************************************************/
				// create directory
				/********************************************************************************/
				// get root dir from experiment table
				String rootTargetDir = null;
				String siteId = null;
				siteId = peForm.getSiteId();				

				rootTargetDir = getRootTargetDir(dbID, rootTargetDir, selRow,
						ui);
				if (rootTargetDir == null) {
					String expName = getExpNameById(dbID, selRow, ui);
					log.error("BaseURI for Experiment " + expName
							+ " cannot be found!");
					return processExceptions(request, response, mapping, form,
							new Exception(
									"BaseURI for the selected experiment '"
											+ expName + "' cannot be found!"));
				}

				File rootTarDir = new File(rootTargetDir);
				if (!rootTarDir.exists()) {
					log.error("Root direcotry of " + rootTargetDir
							+ "does not exist!");
					return processExceptions(request, response, mapping, form,
							new Exception("Root direcotry of '" + rootTargetDir
									+ "' does not exist!"));
				}
				String sVisit[] = selRow.getVisit().split(";;;");
				String sVisitId = sVisit[0];
				String sVisitName = sVisit[1].split(",")[0].trim().replace(" ", "_");
				String sStudy[] = selRow.getStudy().split(";;;");
				String studyId = sStudy[0];
				String studyName = sStudy[1].trim();
				StringBuilder sb = new StringBuilder();
				sb.append(selRow.getSubjectId());
				sb.append("/");
				sb.append(sVisitName);
				sb.append("__");
				sb.append(siteId);
				sb.append("__");
				sb.append(String.format("%04d", Integer.valueOf(sVisitId)));
				sb.append("/");
				sb.append(studyName);
				sb.append("__");
				sb.append(String.format("%04d", Integer.valueOf(studyId)));

				File studyDir = new File(rootTarDir, sb.toString());
				if (!studyDir.exists()) {
					boolean success = studyDir.mkdirs();
					if (!success) {
						log.error("Fail to create directory " + rootTarDir
								+ " " + sb.toString());
						return processExceptions(request, response, mapping,
								form,
								new Exception("Fail to create directory '"
										+ rootTarDir + "/" + sb.toString()
										+ "'"));
					}
				}

				String sProtocol[] = selRow.getProtocol().split(";;;");
				sb = new StringBuilder();
				sb.append(sProtocol[1].replace(" ", "_"));
				sb.append("/Native/Original__0001/"); // from Upload.py line 2789
				File originalDir = new File(studyDir, sb.toString());
				if (!originalDir.exists()) {
					boolean success = originalDir.mkdirs();
					if (!success) {
						log.error("Fail to create original directory "
								+ studyDir + " " + sb.toString());
						return processExceptions(
								request,
								response,
								mapping,
								form,
								new Exception(
										"Fail to create original directory '"
												+ studyDir + "/"
												+ sb.toString() + "'"));
					}
				}

				/********************************************************************************/
				// tar up dicom files (DICOM tar file) @target directory
				/********************************************************************************/
				// get fileid and save file into selFiles list
				getFiles(dbID, selFiles, selRow, ui);
				if (selFiles.size() <= 0) {
					return processExceptions(
							request,
							response,
							mapping,
							form,
							new Exception(
									"Failed to find DICOM files in database table or the DICOM files have been uploaded already!"));
				}

				// check if dicom file has only header information,if so,
				// discard the file from the selFiles list
				List<Receivedfiles> newRcvFiles = new LinkedList<Receivedfiles>();
				for (int idx = 0; idx < selFiles.size(); idx++) {
					File dFile = new File(dicomFileDir, selFiles.get(idx)
							.getFilename());
					com.pixelmed.dicom.DicomInputStream dis = new com.pixelmed.dicom.DicomInputStream(
							dFile);
					AttributeList list = new AttributeList();
					list.read(dis);
					dis.close();
					Attribute pixelData = list.get(TagFromName.PixelData);
					if (pixelData != null) {
						newRcvFiles.add(selFiles.get(idx));
						log.info("pixelData: " + pixelData.getShortValues()[0]);
					}
				}

				// copy selFiles to a temp location
				File tempFiles = new File(dicomFileDir, "temp");
				for (Receivedfiles rf : newRcvFiles) {
					FileUtils
							.copyFileToDirectory(
									new File(dicomFileDir, rf.getFilename()),
									tempFiles);
				}

				// Rename all the dicom files in "temp" directory to final dicom
				// names based on their instance number from the dicom tag
				File[] allDicomFiles = tempFiles.listFiles();
				if (allDicomFiles == null) {
					return processExceptions(request, response, mapping, form,
							new Exception(
									"Could not find dicom files from the temp directory "
											+ tempFiles.getAbsolutePath()));
				}

				for (int idx = 0; idx < allDicomFiles.length; idx++) {
					if (allDicomFiles[idx].isFile()) {
						com.pixelmed.dicom.DicomInputStream dis = new com.pixelmed.dicom.DicomInputStream(
								allDicomFiles[idx]);
						AttributeList list = new AttributeList();
						list.read(dis);
						dis.close();
						Attribute instanceNumber = list
								.get(TagFromName.InstanceNumber);
						File newFile;
						if (instanceNumber == null) {
							newFile = new File(allDicomFiles[idx].getParent(),
									String.format("%04d", 1) + ".dcm");
						} else {
							String iNumber = instanceNumber
									.getOriginalStringValues()[0].trim();
							newFile = new File(allDicomFiles[idx].getParent(),
									String.format("%04d",
											Integer.valueOf(iNumber))
											+ ".dcm");
						}
						if (newFile.exists()) {
							newFile.delete();
						}
						boolean success = allDicomFiles[idx].renameTo(newFile);
						if (!success) {
							log.error("Failed to rename the DICOM file "
									+ allDicomFiles[idx].getName() + "!");
							return processExceptions(
									request,
									response,
									mapping,
									form,
									new Exception(
											"Failed to rename the DICOM file "
													+ allDicomFiles[idx]
															.getName() + "!"));
						}
					}
				}

				//copy additional files to temp location
				File[] additionalFiles = extraFolder.listFiles();
				if(additionalFiles.length>0){
					for(File f : additionalFiles){	
						JSONObject extraFileJs = extraJsArr.getJSONObject(i);
						JSONArray extraFileNames = extraFileJs.getJSONArray("extraFiles");
						for(int idx=0; idx<extraFileNames.length(); idx++){
							String exName = extraFileNames.getJSONObject(idx).getString("fileName").replaceAll(" ",	"_");
							if(f.getName().equals(exName)){
								FileUtils.copyFileToDirectory(f, tempFiles);																
							}
						}
					}
				}				
				
				// put all temp dicom and additional files into an object
				List<PathWrapper> allFiles = new ArrayList<PathWrapper>();
				allDicomFiles = tempFiles.listFiles();
				if (allDicomFiles.length > 0) {
					for (File f : allDicomFiles) {
						PathWrapper pw = new PathWrapper(f.getName(), null); // relpath is only file name
						allFiles.add(pw);
					}
				} else {
					log.error("Failed to find the DICOM file!");
					return processExceptions(request, response, mapping, form,
							new Exception("Failed to find the DICOM file!"));
				}		

				// Tar dicom files
				Packager p = new Packager(tempFiles.getPath(), "DICOM", 2); // dicomFileDir is the absolute path
				p.includeFiles(tempFiles.getPath(), allFiles);
				p.pack();

				// copy tarred file to target directory, delete tar and dicom
				// files at source
				File tarFile = new File(tempFiles.getPath(), "DICOM.tar.gz");
				FileUtils.copyFileToDirectory(tarFile, originalDir);
				tarFile.delete();
				deleteDirectory(tempFiles);				

				selRow.setTemplocation(originalDir.getAbsolutePath()
						+ "/DICOM.tar.gz");

				/***************************************************************************************/
				// add entry to nc_expsegment, nc_rawdata and nc_dataobject
				// tables in database
				/***************************************************************************************/
				if (!ifs.insertExpSegment(ui, selRow)) {
					return processExceptions(request, response, mapping, form,
							new Exception(
									"Error in inserting expsegment table!"));
				}

				List<BigDecimal> rawdataUniqueId = new ArrayList<BigDecimal>();
				if (!ifs.insertRawData(ui, selRow, peForm.getEquipment(),
						rawdataUniqueId)) {
					return processExceptions(request, response, mapping, form,
							new Exception("Error in inserting rawdata table!"));
				}

				long dicomFileSize = new File(originalDir.getAbsolutePath(),
						"DICOM.tar.gz").length();

				if (!ifs.insertDataObject(ui, selRow, rawdataUniqueId.get(0),
						dicomFileSize)) {
					return processExceptions(request, response, mapping, form,
							new Exception(
									"Error in inserting dataobject table!"));
				}
				
				
				///********** update processed files to be "processed" in nc_receivedfiles table ******************/
				setFilesProcessed(dbID, selRow, ui);
				
				//set attribute of forceCache to be true
				session.setAttribute("pfForceCache", true);
				
				//copy additional files to target directory
//				File[] additionalFiles = extraFolder.listFiles();
//				if(additionalFiles.length>0){
//					for(File f : additionalFiles){	
//						JSONObject extraFileJs = extraJsArr.getJSONObject(i);
//						JSONArray extraFileNames = extraFileJs.getJSONArray("extraFiles");
//						for(int idx=0; idx<extraFileNames.length(); idx++){
//							if(f.getName().equals(extraFileNames.getJSONObject(idx).getString("fileName"))){
//								FileUtils.copyFileToDirectory(f, originalDir);
//								
//								//add entry to nc_rawdata
//								selRow.setTemplocation(originalDir.getAbsolutePath() + f.getName());
//								List<BigDecimal> rawdataUId = new ArrayList<BigDecimal>();
//								if (!ifs.insertRawData(ui, selRow, peForm.getEquipment(),rawdataUId)) {
//									return processExceptions(request, response, mapping, form,
//											new Exception("Error in inserting rawdata table!"));
//								}								
//							}
//						}
//					}
//				}

			} //end of JsArr loop
			
			deleteDirectory(extraFolder);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception ex) {
			return processExceptions(request, response, mapping, form, ex);
		}

	}

	private void setFilesProcessed(String dbID, SelectedFileInfo selRow, 
			UserInfo ui) throws Exception{
		IDBPoolService dbPoolService = MinimalServiceFactory.getPoolService(dbID);
		Connection con = dbPoolService.getConnection(ui.getName());
		try {
			BigDecimal fileId = null;
			ReceivedfilesdcmtagDAO dao = DAOFactory
					.createReceivedfilesdcmtagDAO(dbID);
			Receivedfilesdcmtag bean = new Receivedfilesdcmtag();
			bean.setPatientid(selRow.getPatientid());
			bean.setSeriesdate(selRow.getSeriesdate());
			bean.setSeriesdescription(selRow.getSeriesdescription());
			bean.setSeriestime(selRow.getSeriestime());
			List<Receivedfilesdcmtag> lstFilesDcmTags = dao.find(con, bean);
			if (lstFilesDcmTags.size() > 0) {
				for (Receivedfilesdcmtag rf : lstFilesDcmTags) {
					fileId = BigDecimal.valueOf(rf.getFileid());					
					ReceivedfilesDAO rfDao = DAOFactory
							.createReceivedfilesDAO(dbID);
					Receivedfiles rfBean = new Receivedfiles();
					rfBean.setProcessed(true);
					Receivedfiles rfCriteria = new Receivedfiles();
					rfCriteria.setFileid(fileId);
					rfDao.update(con, rfBean, rfCriteria);					
				}
			}
		} catch (Exception ex) {
			log.error("Cannot update received files to be 'processed'", ex);
		} finally {
			dbPoolService.releaseConnection(ui.getName(), con);
		}
		
	}

	public String getRootTargetDir(String dbID, String rootTargetDir,
			SelectedFileInfo selRow, UserInfo ui) throws Exception {
		IDBPoolService dbPoolService = MinimalServiceFactory
				.getPoolService(dbID);
		Connection con = dbPoolService.getConnection(ui.getName());
		try {
			ExperimentDAO expDao = DAOFactory.createExperimentDAO(dbID);
			Experiment expBean = new Experiment();
			expBean.setUniqueid(BigDecimal.valueOf(Double.valueOf(selRow.getExpId())));
			List<Experiment> listExp = expDao.find(con, expBean);
			if (listExp.size() > 0) {
				rootTargetDir = listExp.get(0).getBaseuri();
			} else {
				log.error("Can't find base URI for experiment!");
			}

		} catch (Exception ex) {
			log.error("Cannot get target root directory ", ex);
		} finally {
			dbPoolService.releaseConnection(ui.getName(), con);
		}
		return rootTargetDir;
	}

	public String getExpNameById(String dbID, SelectedFileInfo selRow,
			UserInfo ui) throws Exception {

		IDBPoolService dbPoolService = MinimalServiceFactory
				.getPoolService(dbID);
		Connection con = dbPoolService.getConnection(ui.getName());
		String expName = null;

		try {
			ExperimentDAO expDao = DAOFactory.createExperimentDAO(dbID);
			Experiment expBean = new Experiment();
			expBean.setUniqueid(BigDecimal.valueOf(Double.valueOf(selRow
					.getExpId())));
			List<Experiment> listExp = expDao.find(con, expBean);
			if (listExp.size() > 0) {
				expName = listExp.get(0).getName();
			} else {
				log.error("Can't find name for experiment!");
			}

		} catch (Exception ex) {
			log.error("Erro occured during getting experiment name.", ex);
		} finally {
			dbPoolService.releaseConnection(ui.getName(), con);
		}
		return expName;
	}

	public void getFiles(String dbID, List<Receivedfiles> selFiles,
			SelectedFileInfo selRow, UserInfo ui) throws Exception {
		IDBPoolService dbPoolService = MinimalServiceFactory
				.getPoolService(dbID);
		Connection con = dbPoolService.getConnection(ui.getName());
		try {
			BigDecimal fileId = null;
			ReceivedfilesdcmtagDAO dao = DAOFactory
					.createReceivedfilesdcmtagDAO(dbID);
			Receivedfilesdcmtag bean = new Receivedfilesdcmtag();
			bean.setPatientid(selRow.getPatientid());
			bean.setSeriesdate(selRow.getSeriesdate());
			bean.setSeriesdescription(selRow.getSeriesdescription());
			bean.setSeriestime(selRow.getSeriestime());
			List<Receivedfilesdcmtag> lstFilesDcmTags = dao.find(con, bean);
			if (lstFilesDcmTags.size() > 0) {
				for (Receivedfilesdcmtag rf : lstFilesDcmTags) {
					fileId = BigDecimal.valueOf(rf.getFileid());
					selRow.setFileid(fileId);
					ReceivedfilesDAO rfDao = DAOFactory
							.createReceivedfilesDAO(dbID);
					Receivedfiles rfBean = new Receivedfiles();
					rfBean.setFileid(fileId);
					rfBean.setProcessed(false);								//only find un-processed file 
					List<Receivedfiles> listRFs = rfDao.find(con, rfBean);
					if(!listRFs.isEmpty()){
						selFiles.add(listRFs.get(0));
					}
				}
			}
		}
		catch(Exception ex){
			log.error("Cannot get received files by using dicom tag infos", ex);
		}
		finally {
			dbPoolService.releaseConnection(ui.getName(), con);
		}

	}

	public void deleteDirectory(File file) throws IOException {

		if (file.isDirectory()) {

			// directory is empty, then delete it
			if (file.list().length == 0) {

				file.delete();
				System.out.println("Directory is deleted : "
						+ file.getAbsolutePath());

			} else {

				// list all the directory contents
				String files[] = file.list();

				for (String temp : files) {
					// construct the file structure
					File fileDelete = new File(file, temp);

					// recursive delete
					deleteDirectory(fileDelete);
				}

				// check the directory again, if empty then delete it
				if (file.list().length == 0) {
					file.delete();
					System.out.println("Directory is deleted : "
							+ file.getAbsolutePath());
				}
			}

		} else {
			// if file, then delete it
			file.delete();
			System.out.println("File is deleted : " + file.getAbsolutePath());
		}
	}
}
