package clinical.web.actions;

//import java.util.ArrayList;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONArray;
import org.json.JSONObject;

import com.pixelmed.dicom.*;
import com.sun.jmx.snmp.Timestamp;

import clinical.server.SelectedFileInfo;
import clinical.server.ReceivedfilesInfo;
import clinical.server.dao.ExperimentDAO;
import clinical.server.dao.ReceivedfilesDAO;
import clinical.server.dao.ReceivedfilesdcmtagDAO;
import clinical.server.vo.Collectionequipment;
import clinical.server.vo.Experiment;
import clinical.server.vo.Humansubject;
import clinical.server.vo.Person;
import clinical.server.vo.Protocol;
import clinical.server.vo.Receivedfiles;
import clinical.server.vo.Receivedfilesdcmtag;
import clinical.server.vo.Researchgroup;
import clinical.server.vo.Site;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.DAOFactory;
import clinical.web.IExperimentManagement;
import clinical.web.MinimalServiceFactory;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBPoolService;
import clinical.web.common.UserInfo;
import clinical.web.download.Packager;
import clinical.web.download.PathWrapper;
import clinical.web.exception.BaseException;
import clinical.web.forms.ExperimentManagementForm;
import clinical.web.forms.ProcessExtraFile;
import clinical.web.forms.ProcessFile;
import clinical.web.forms.SubjectVisitManagementForm;
import clinical.web.helpers.ExpSubjInfo;
import clinical.web.helpers.SegmentFormInfo;
import clinical.web.helpers.StudyFormInfo;
import clinical.web.helpers.SubjectExperimentsSelector;
import clinical.web.helpers.SubjectManagementHelper;
import clinical.web.helpers.VisitFormInfo;
import clinical.web.services.ImagingFileService;
import clinical.web.test.DataTablesParamUtility;
import clinical.web.test.JQueryDataTableParamModel;
import clinical.web.vo.ContactPerson;
import clinical.web.vo.ExperimentInfo;
import clinical.web.vo.Study;
import clinical.web.vo.StudySegment;
import clinical.web.vo.Subject;
import clinical.web.vo.Visit;
import clinical.web.vo.VisitSegment;


public class ProcessFileAction extends BaseLookupDispatchAction{	
	
	protected Map<String, String> map = new HashMap<String, String>(7);
	private Log log = LogFactory.getLog(ProcessFileAction.class);
	
	protected String siteIds[] = {"0003", "0005","0006","0007",	"0008",	"0010",	"0011",	"0012",	"0013",	"0018",	"0009"};

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.pf.show", "show");
		map.put("action.pf.getData", "getImagingFileData");
		map.put("action.pf.placing", "placing");
		map.put("action.pf.createSubject", "createSubject");
		map.put("action.pf.enrollSubject", "enrollSubject");
		map.put("action.pf.createVisit", "createVisit");
		map.put("action.pf.createStudy", "createStudy");
		return map;
	}
	
	public ActionForward show(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		
		try{
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
			
			ProcessFile pf = (ProcessFile)form;			
			ImagingFileService ifs = new ImagingFileService(dbID);
			
			String dicomDir = ifs.getDicomDir(ui);
			pf.setDicomDir(dicomDir);
			
			List<ReceivedfilesInfo> rcvdFiles = ifs.getDistinctReceivedFilesInfo(ui);			
			pf.setAllRcvdFiles(rcvdFiles);
	
			List<Experiment> exps = ifs.getAllExperiments(ui);
			pf.setAllExperiments(exps);
			
			List<Experiment> localStoredExps = ifs.getLocalStoredExperiments(ui);
			pf.setLocalStoredExps(localStoredExps);
			
			List<Site> allSites = ifs.getAllSites(ui);			
			pf.setSites(allSites);
			
			List<Collectionequipment> allEquips = ifs.getAllEquips(ui);
			pf.setEquips(allEquips);
			
			//get attribute of forceCache
			boolean pfCache = false;
			if(session.getAttribute("pfForceCache")!=null) pfCache=(Boolean)session.getAttribute("pfForceCache");
			
			List<ExpSubjInfo> expSubjInfo = ifs.getAllExpSubjInfo(ui, pfCache);
			pf.setAllExpSubjInfo(expSubjInfo);
			
			List<Protocol> imageProtocols = ifs.getAllImageProtocols(ui);
			pf.setAllImageProtocols(imageProtocols);
			
			//set attribute of forceCache to be true
			session.setAttribute("pfForceCache", false);
			
			return mapping.findForward(Constants.NEW);
		}
		catch(Exception ex){
			return processExceptions(request, response, mapping, form, ex);
		}
	}

	public ActionForward getImagingFileData(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {	
		
		try{
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);

			JQueryDataTableParamModel param = DataTablesParamUtility.getParam(request);		
			String sEcho = param.sEcho;
			int iTotalRecords; // total number of records (unfiltered)
			int iTotalDisplayRecords;//value will be set when code filters companies by keyword
			
			ImagingFileService ifs = new ImagingFileService(dbID);
			//List<Receivedfiles> allRcvdFiles = ifs.getAllReceivedFiles(ui);
			List<ReceivedfilesInfo> allRcvdFiles = ifs.getAllReceivedFilesInfo(ui);		
			iTotalRecords = allRcvdFiles.size();
			
			List<ReceivedfilesInfo> newRcvdFilesInfo = new LinkedList<ReceivedfilesInfo>();
			for(ReceivedfilesInfo rf : allRcvdFiles)
			{
				if(rf.getFileid().toString().contains(param.sSearch.toLowerCase())
				||
				rf.getFilename().contains(param.sSearch.toLowerCase())
				||
				rf.getTemplocation().contains(param.sSearch.toLowerCase())
				||
				rf.getPermlocation().contains(param.sSearch.toLowerCase())
				||
				rf.getProcessed().toString().contains(param.sSearch.toLowerCase())
				||
				rf.getSeriesdate().contains(param.sSearch.toLowerCase())
				||
				rf.getSeriesdescription().contains(param.sSearch.toLowerCase())
				||
				rf.getSeriesnumber().contains(param.sSearch.toLowerCase())
				||
				rf.getPermlocation().contains(param.sSearch.toLowerCase())
				||
				rf.getPatientid().contains(param.sSearch.toLowerCase())
				)
				{
					newRcvdFilesInfo.add(rf);
				}			
			}
			iTotalDisplayRecords = newRcvdFilesInfo.size();
			final int sortColumnIndex = param.iSortColumnIndex;
			final int sortDirection = param.sSortDirection.equals("asc") ? 1 : -1;
			Collections.sort(newRcvdFilesInfo, new Comparator<ReceivedfilesInfo>(){
				public int compare(ReceivedfilesInfo r1, ReceivedfilesInfo r2) {
					switch(sortColumnIndex){
					case 0:
						return r1.getFileid().toString().compareTo(r2.getFileid().toString())*sortDirection;
					case 1:
						return r1.getFilename().compareTo(r2.getFilename())*sortDirection;
					case 2:
						return r1.getTemplocation().compareTo(r2.getTemplocation())*sortDirection;
					case 3:
						return r1.getPermlocation().compareTo(r2.getPermlocation())*sortDirection;
					case 4:
						return r1.getProcessed().compareTo(r2.getProcessed())*sortDirection;
					case 5:
						return r1.getPatientid().compareTo(r2.getPatientid())*sortDirection;
					case 6:
						return r1.getSeriesnumber().compareTo(r2.getSeriesnumber())*sortDirection;
					case 7:
						return r1.getSeriesdescription().compareTo(r2.getSeriesdescription())*sortDirection;
					case 8:
						return r1.getSeriesdate().compareTo(r2.getSeriesdate())*sortDirection;
					}
					return 0;
				}			
			});
			
			if(newRcvdFilesInfo.size()< param.iDisplayStart + param.iDisplayLength)
				newRcvdFilesInfo = newRcvdFilesInfo.subList(param.iDisplayStart, newRcvdFilesInfo.size());
			else
				newRcvdFilesInfo = newRcvdFilesInfo.subList(param.iDisplayStart, param.iDisplayStart + param.iDisplayLength);
			

			//return mapping.findForward(Constants.NEW);
			JSONArray data = new JSONArray(); //data that will be shown in the table		
			try {
				JSONObject jsonResponse = new JSONObject();			
				jsonResponse.put("sEcho", sEcho);
				jsonResponse.put("iTotalRecords", iTotalRecords);
				jsonResponse.put("iTotalDisplayRecords", iTotalDisplayRecords);
				
				for(ReceivedfilesInfo c : newRcvdFilesInfo){
					JSONArray row = new JSONArray();				
					row.put(c.getFileid());			
					row.put(c.getFilename());
					row.put(c.getTemplocation());
					row.put(c.getPermlocation());
					row.put(c.getProcessed());
					row.put(c.getPatientid());
					row.put(c.getSeriesnumber());
					row.put(c.getSeriesdescription());
					row.put(c.getSeriesdate());
					data.put(row);
				}
				jsonResponse.put("aaData", data);

				response.setContentType("application/Json");
				response.getWriter().print(jsonResponse.toString());
				
			} catch (Exception e) {
				e.printStackTrace();
				response.setContentType("text/html");
				response.getWriter().print(e.getMessage());
				log.error(e.getMessage());
			}
			
		}catch(Exception ex){
			return processExceptions(request, response, mapping, form, ex);	
		}

		return null;
	}

	public ActionForward placing(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		
		try{			
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
			ImagingFileService ifs = new ImagingFileService(dbID);
			
			//get dicomRcvr forwarded dicom file location
			String dicomFileDir = request.getParameter("dicomdir");
			ifs.saveDicomDir(ui, dicomFileDir);			
			
			//1st, Create target directory where data files will be copied to
			//2nd, Tar up Dicom files to the target directory
			//3rd, Insert file info to nc_rawdata table			
			String siteId = request.getParameter("siteId");
			String rootTargetDir = null; 
			String fileInfos = request.getParameter("selectedRows");
			String equipment = request.getParameter("equipment");
			
			JSONObject json = new JSONObject(fileInfos);
			JSONArray jsArr = json.getJSONArray("fileValues");
			
			//save info to ProcessExtraFile form
			ProcessExtraFile peForm = new ProcessExtraFile();
			session.setAttribute(Constants.ProcessExtra_FORM_KEY, peForm);
			
			peForm.setSiteId(siteId);
			peForm.setRootTargetDirectory(rootTargetDir);
			peForm.setEquipment(equipment);
			peForm.setJsaSelectedFiles(jsArr);
			peForm.setDicomFileDir(dicomFileDir);
						
			List<SelectedFileInfo> selectedRows = new LinkedList<SelectedFileInfo>();
			for(int i=0; i<jsArr.length(); i++){
				JSONObject jsObj = jsArr.getJSONObject(i);				
				SelectedFileInfo selRow = new SelectedFileInfo();
				selRow.setPatientid(jsObj.getString("patientid"));
				selRow.setSubjectId(jsObj.getString("subjectId"));
				selRow.setExpId(jsObj.getString("expId"));	
				selRow.setExpName(getExpNameById(dbID, selRow, ui));
				selRow.setVisit(jsObj.getString("visit"));
				selRow.setProtocol(jsObj.getString("protocol"));
				selRow.setStudy(jsObj.getString("study"));
				
				String sVisit[] = selRow.getVisit().split(";;;");
				String sVisitId = sVisit[0];
				String sVisitName = sVisit[1].split(" ")[0];
				String sStudy[] = selRow.getStudy().split(";;;");
				String studyId = sStudy[0];
				String studyName = sStudy[1];
				String sProtocol[] = selRow.getProtocol().split(";;;");
				
				selRow.setVisitName(sVisitName);
				selRow.setStudyName(studyName);
				selRow.setProtocolName(sProtocol[1]);
				
				selRow.setSeriesdate(jsObj.getString("seriesdate"));
				selRow.setSeriesdescription(jsObj.getString("seriesdescription"));
				selRow.setSeriestime(jsObj.getString("seriestime"));
				selectedRows.add(selRow);
			}
			peForm.setSelectedRows(selectedRows);

			return mapping.findForward(Constants.NEXT);
			
		}
		catch(Exception ex){
			return processExceptions(request, response, mapping, form, ex);
		}
		
	}
	

	public ActionForward createSubject(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		
		try{	
			HttpSession session = request.getSession(false);
			
			String fileInfos = request.getParameter("selectedRows");
			JSONObject json = new JSONObject(fileInfos);
			JSONArray jsArr = json.getJSONArray("fileValues");
			String sPatientId = "";
			if(jsArr.length()>0){
				JSONObject jsObj = jsArr.getJSONObject(0);
				sPatientId = jsObj.getString("patientid");				
			}
			
			//check if sPatientId is BIRN ID
			boolean isBirnId = false;
			if(sPatientId.length()==12){
				for(int i=0; i<siteIds.length; i++){
					if(sPatientId.substring(0, 4).equals(siteIds[i])){
						isBirnId = true;
						break;
					}
				}
			}
			
			//save info to SubjectVisitManagementForm, use patientId as BIRN ID
			SubjectVisitManagementForm svmForm = new SubjectVisitManagementForm();
			session.setAttribute(Constants.SUBVISITMANAGEMENT_FORM_KEY, svmForm);
			Subject subj = svmForm.getSubject();
			if(isBirnId==true){					
				subj.setSubjectID(sPatientId);				
			}else{
				subj.setLocalID(sPatientId);
			}
				
			//set attribute of forceCache to be true
			session.setAttribute("pfForceCache", true);
			
			return mapping.findForward(Constants.ADD_SUBJECT);

		}
		catch(Exception ex){
			return processExceptions(request, response, mapping, form, ex);
		}
		
	}

	
	public ActionForward enrollSubject(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {		
		IExperimentManagement iem = null;		
		
		try{
/*			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			iem = ServiceFactory.getExperimentManagement(dbID);
			List<Experiment> exps = iem.getAllExperiments(ui);

			ExperimentManagementForm expForm = new ExperimentManagementForm();
			session.setAttribute(Constants.EXPERIMENTMANAGEMENT_FORM_KEY, expForm);
			expForm.setExperimentLVBeans(exps);

			return mapping.findForward(Constants.SHOW_FIND_EXP);
*/		
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			iem = ServiceFactory.getExperimentManagement(dbID);
			String selExperimentValue = request.getParameter("expName");
			if (selExperimentValue == null) {
				log.error("selected experimentInfo was null!");
			}

			List<Humansubject> subjects = iem.getRemainingSubjects(ui, Integer
					.parseInt(selExperimentValue));
			//sort subjects by their subjectid 
			Collections.sort(subjects, new Comparator<Object>() {
				public int compare(Object o1, Object o2) {
					Humansubject hs1 = (Humansubject) o1;
					Humansubject hs2 = (Humansubject) o2;
					return hs1.getSubjectid().compareTo(hs2.getSubjectid());
				}
			});
			
			ExperimentManagementForm expForm = new ExperimentManagementForm();		
			session.setAttribute(Constants.EXPERIMENTMANAGEMENT_FORM_KEY, expForm);
			
			expForm.setAvailableSubjectLVBeans(subjects);

			List<Researchgroup> rgList = ServiceFactory.getDBCache(dbID)
					.getResearchGroups(ui, false);
			//ExperimentInfo ei = expForm.getExperimentInfo();
			List<Researchgroup> ergList = new LinkedList<Researchgroup>();
			for (Researchgroup rg : rgList) {
				if (rg.getNcExperimentUniqueid().intValue() == Integer.parseInt(selExperimentValue)) {
					ergList.add(rg);
				}
			}
			expForm.setAvailableStudyGroupLVBeans(ergList);

			Experiment experiment = iem.getExperiment(ui, Integer.parseInt(selExperimentValue));
			Person person = iem.getContactPerson(ui, experiment.getContactperson()
					.intValue());
			ExperimentInfo expInfo = new ExperimentInfo(experiment);
			expInfo.setContactPerson(new ContactPerson(person));
			expForm.setExperimentInfo(expInfo);
			
			
			session.setAttribute(Constants.CURRENT_EXPERIMENTID_KEY,
					expForm.getSelectedExperimentValue());
			session.setAttribute(Constants.CURRENT_EXPERIMENTNAME_KEY,
					GenUtils.clipString(experiment.getName(), 18));
			// get the enrolled subjects and the study groups also
			ExperimentManagementHelper.prepareEnrolledSubjectStudyGroups(dbID,
					ui, Integer.parseInt(selExperimentValue), expForm);

			prepareContactPersons(dbID, ui, expForm);
			expForm.getExperimentInfo().setContactPersonValue(
					String.valueOf(expInfo.getContactPerson().getUniqueID()));
			// make sure to set current experiment id as the selected experiment
			expForm.setSelectedExperimentValue(selExperimentValue);
			
			String selSubjId = request.getParameter("patientId");
			expForm.setAvailableSubjectValue(selSubjId);
			
			//set attribute of forceCache to be true
			session.setAttribute("pfForceCache", true);
			
			return mapping.findForward(Constants.SHOW_ENROLL_SUBJECT);
		}
		catch(Exception ex){
			return processExceptions(request, response, mapping, form, ex);
		}
		
	}

	
	public ActionForward createVisit(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {		
		try{
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
			
			String expName = ""; 
			String expId = "";
			String subjId = "";
			String fileInfos = request.getParameter("selectedRows");
			JSONObject json = new JSONObject(fileInfos);
			JSONArray jsArr = json.getJSONArray("fileValues");
			
			if(jsArr.length()>0){
				JSONObject jsObj = jsArr.getJSONObject(0);
				expName = jsObj.getString("expName");
				expId = jsObj.getString("expId");
				subjId = jsObj.getString("subjectId");
			}
			
			SubjectVisitManagementForm svmForm = new SubjectVisitManagementForm();
			session.setAttribute(Constants.SUBVISITMANAGEMENT_FORM_KEY, svmForm);
			
			Subject subj = new Subject();
			subj.setSubjectID(subjId);
			svmForm.setSubject(subj);
			svmForm.setSelectedSubjectID(subjId);
			
			String[] expNames = SubjectManagementHelper.getExperimentNames(dbID, ui, svmForm);
			String[] visitTypes = SubjectManagementHelper.getVisitTypes(dbID, ui);			
			java.util.Arrays.sort(visitTypes);
			List<Protocol> protocols = svmForm.getProtocols();
			if (protocols == null || protocols.isEmpty()) {
				protocols = SubjectManagementHelper.getProtocols(dbID, ui);
				svmForm.setProtocols(protocols);
			}
			Object[] protocolNameVersions = SubjectManagementHelper.getProtocolNameVersions(protocols);

			Visit newVisit = new Visit();
			VisitFormInfo vfi = new VisitFormInfo(newVisit, expNames, visitTypes, svmForm);
			newVisit.setSubjectID(subjId);
			vfi.setExperiment(expName);

			VisitSegment vs = new VisitSegment();
			// also set the experiment id on visitSegment
			vs.setExperimentID(Integer.valueOf(expId));
			vs.setSubjectID(svmForm.getSubject().getSubjectID());

			SegmentFormInfo sfi = new SegmentFormInfo(vs,
					(String[]) protocolNameVersions[0],
					(int[]) protocolNameVersions[1], svmForm);

			newVisit.addVisitSegment(vs);
			vfi.addSegmentFormInfo(sfi);

			svmForm.setCurrentVisit(vfi);
			svmForm.setCurrentAction(Constants.ADD_VISIT);

			//set attribute of forceCache to be true
			session.setAttribute("pfForceCache", true);
			
			return mapping.findForward(Constants.ADD_VISIT);
		
		}
		catch(Exception ex){
			return processExceptions(request, response, mapping, form, ex);
		}
	}
			
	public ActionForward createStudy(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {		
		IExperimentManagement iem = null;		
		
		try{
/*			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			iem = ServiceFactory.getExperimentManagement(dbID);
			List<Experiment> exps = iem.getAllExperiments(ui);

			ExperimentManagementForm expForm = new ExperimentManagementForm();
			session.setAttribute(Constants.EXPERIMENTMANAGEMENT_FORM_KEY, expForm);
			expForm.setExperimentLVBeans(exps);			

			return mapping.findForward(Constants.SHOW_FIND_EXP);
			*/
			
			//SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) form;
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
			
			String expName = ""; 
			String expId = "";
			String subjId = "";
			String visitStr = "";
			String fileInfos = request.getParameter("selectedRows");
			JSONObject json = new JSONObject(fileInfos);
			JSONArray jsArr = json.getJSONArray("fileValues");
			
			if(jsArr.length()>0){
				JSONObject jsObj = jsArr.getJSONObject(0);
				expName = jsObj.getString("expName");
				expId = jsObj.getString("expId");
				subjId = jsObj.getString("subjectId");
				visitStr = jsObj.getString("visitStr");
			}
			
			SubjectVisitManagementForm svmForm = new SubjectVisitManagementForm();
			session.setAttribute(Constants.SUBVISITMANAGEMENT_FORM_KEY, svmForm);

			Subject subj = new Subject();
			subj.setSubjectID(subjId);
			svmForm.setSubject(subj);
			svmForm.setSelectedSubjectID(subjId);

			int componentId = Integer.valueOf(visitStr.split(";;;")[0]);
			String visitName = visitStr.split(";;;")[1].split(",")[0].trim();
			SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
			java.util.Date date = sdf.parse(visitStr.split(";;;")[1].split(",")[1].trim());
			java.sql.Timestamp ts = new java.sql.Timestamp(date.getTime());
			
			getUserInfo(request);

//			currentVfi.setTimeStamp(visitStr.split(";;;")[1].split(",")[1].trim());
//			currentVfi.setVisit(newVisit);
//			svmForm.setCurrentVisit(currentVfi);

			Visit newVisit = new Visit();
			newVisit.setComponentID(componentId);
			newVisit.setExperimentID(Integer.valueOf(expId));
			newVisit.setName(visitName);
			newVisit.setSubjectID(subjId);
			newVisit.setTimeStamp(ts);			
			String[] expNames = SubjectManagementHelper.getExperimentNames(dbID, ui, svmForm);
			String[] visitTypes = SubjectManagementHelper.getVisitTypes(dbID, ui);			
			java.util.Arrays.sort(visitTypes);
			VisitFormInfo vfi = new VisitFormInfo(newVisit, expNames, visitTypes, svmForm);
			vfi.setExperiment(expName);
			vfi.setVisit(newVisit);
			//VisitFormInfo vfi = svmForm.getCurrentVisit();
			Study study = new Study();
			// also set the experiment id on study
//			int theExpID = -1;
//			for (Experiment exp : svmForm.getExperiments()) {
//				if (exp.getName().equals(
//						svmForm.getCurrentVisit().getExperiment())) {
//					theExpID = exp.getUniqueid().intValue();
//					study.setExperimentID(theExpID);
//					break;
//				}
//			}
			study.setExperimentID(Integer.valueOf(expId));
			study.setSubjectID(svmForm.getSubject().getSubjectID());
			//study.setComponentID(vfi.getVisit().getComponentID());
			//study.setTimeStamp(vfi.getVisit().getTs());
			study.setComponentID(componentId);
			study.setTimeStamp(ts);

			StudyFormInfo sfi = new StudyFormInfo(study);
			vfi.getVisit().addStudy(study);
			vfi.addStudyFormInfo(sfi);

			// add the mandatory segment (each study has a mandatory segment
			StudySegment ss = new StudySegment();
			//ss.setExperimentID(theExpID);
			ss.setExperimentID(Integer.valueOf(expId));
			ss.setSubjectID(svmForm.getSubject().getSubjectID());
			//ss.setVisitID(vfi.getVisit().getComponentID());
			ss.setVisitID(componentId);
			// segment numbers start from 1
			ss.setSegmentID(1);
			//ss.setTimeStamp(vfi.getVisit().getTs());
			ss.setTimeStamp(ts);

			List<Protocol> protocols = svmForm.getProtocols();
			if (protocols == null || protocols.isEmpty()) {
				protocols = SubjectManagementHelper.getProtocols(dbID, ui);
				svmForm.setProtocols(protocols);
			}
			Object[] protocolNameVersions = SubjectManagementHelper.getProtocolNameVersions(protocols);
			SegmentFormInfo sgi = new SegmentFormInfo(ss,
					(String[]) protocolNameVersions[0],
					(int[]) protocolNameVersions[1], svmForm);

			sfi.addSegmentFormInfo(sgi);
			study.addStudySegment(ss);

			// cleanup selection state
			// if (svmForm.getSelectedStudyID() != null) {
			svmForm.setSelectedSegmentID(null);
			// }
			// indicate that the user is adding a new study
			svmForm.setSelectedStudyID("-1000");
			
			SubjectExperimentsSelector newExpSelector = new SubjectExperimentsSelector(svmForm.getExperiments());
			newExpSelector.setSelectedExpID(Integer.valueOf(expId));
			svmForm.setExpSelector(newExpSelector);
			
			svmForm.setVisitDateValue(visitStr.split(";;;")[1].split(",")[1].trim());
			svmForm.setCurrentVisit(vfi);
			svmForm.setCurrentAction(Constants.ADD_STUDY);
			
			//set attribute of forceCache to be true
			session.setAttribute("pfForceCache", true);

			return mapping.findForward(Constants.ADD_STUDY);

		}
		catch(Exception ex){
			return processExceptions(request, response, mapping, form, ex);
		}

	}
	
	protected static void prepareContactPersons(String dbID, UserInfo ui,
			ExperimentManagementForm emForm) throws BaseException {
		IExperimentManagement iem = ServiceFactory.getExperimentManagement(dbID);
		List<?> personList = iem.getAllContactPersons(ui);
		List<ContactPerson> cpList = new ArrayList<ContactPerson>(personList
				.size());
		for (Object element : personList) {
			Person person = (Person) element;
			ContactPerson cp = new ContactPerson(person);
			cpList.add(cp);
		}
		emForm.getExperimentInfo().setContactPersonsLVBeans(cpList);
	}
	
	public void getFiles(String dbID, List<Receivedfiles> selFiles, 
			SelectedFileInfo selRow, UserInfo ui)
			throws Exception {
		IDBPoolService dbPoolService = MinimalServiceFactory.getPoolService(dbID);
		Connection con = dbPoolService.getConnection(ui.getName());
		try{
			BigDecimal fileId = null;
			ReceivedfilesdcmtagDAO dao = DAOFactory.createReceivedfilesdcmtagDAO(dbID);
			Receivedfilesdcmtag bean = new Receivedfilesdcmtag();
			bean.setPatientid(selRow.getPatientid());				
			bean.setSeriesdate(selRow.getSeriesdate());				
			bean.setSeriesdescription(selRow.getSeriesdescription());				
			bean.setSeriestime(selRow.getSeriestime());
			List<Receivedfilesdcmtag> lstFilesDcmTags = dao.find(con, bean);
			if(lstFilesDcmTags.size()>0){
				for(Receivedfilesdcmtag rf : lstFilesDcmTags){
					fileId = BigDecimal.valueOf(rf.getFileid());
					selRow.setFileid(fileId);						
					ReceivedfilesDAO rfDao = DAOFactory.createReceivedfilesDAO(dbID);
					Receivedfiles rfBean = new Receivedfiles();
					rfBean.setFileid(fileId);
					List<Receivedfiles> listRFs = rfDao.find(con, rfBean);
					selFiles.add(listRFs.get(0));						
				}
			}	
		}
//		catch(Exception ex){
//			log.error("Cannot get files ", ex);
//		}
		finally{
			dbPoolService.releaseConnection(ui.getName(), con);
		}
		
	}

	public String getRootTargetDir(String dbID, String rootTargetDir, 
			SelectedFileInfo selRow, UserInfo ui) throws Exception {
		IDBPoolService dbPoolService = MinimalServiceFactory.getPoolService(dbID);
		Connection con = dbPoolService.getConnection(ui.getName());
		try{
			ExperimentDAO expDao = DAOFactory.createExperimentDAO(dbID);
			Experiment expBean = new Experiment();
			expBean.setUniqueid(BigDecimal.valueOf(Double.valueOf(selRow.getExpId())));
			List<Experiment> listExp = expDao.find(con, expBean);
			if(listExp.size()>0){
				rootTargetDir = listExp.get(0).getBaseuri();	
			}else{
				log.error("Can't find base URI for experiment!");
			}
				
		}catch(Exception ex){
			log.error("Cannot get target root directory ", ex);
		}finally{
			dbPoolService.releaseConnection(ui.getName(), con);
		}
		return rootTargetDir;
	}
	
	public void deleteDirectory(File file)
	    	throws IOException{
	 
	    	if(file.isDirectory()){
	 
	    		//directory is empty, then delete it
	    		if(file.list().length==0){
	 
	    		   file.delete();
	    		   System.out.println("Directory is deleted : " 
	                                                 + file.getAbsolutePath());
	 
	    		}else{
	 
	    		   //list all the directory contents
	        	   String files[] = file.list();
	 
	        	   for (String temp : files) {
	        	      //construct the file structure
	        	      File fileDelete = new File(file, temp);
	 
	        	      //recursive delete
	        	     deleteDirectory(fileDelete);
	        	   }
	 
	        	   //check the directory again, if empty then delete it
	        	   if(file.list().length==0){
	           	     file.delete();
	        	     System.out.println("Directory is deleted : " 
	                                                  + file.getAbsolutePath());
	        	   }
	    		}
	 
	    	}else{
	    		//if file, then delete it
	    		file.delete();
	    		System.out.println("File is deleted : " + file.getAbsolutePath());
	    	}
	    }

	public String getExpNameById(String dbID, SelectedFileInfo selRow, UserInfo ui) 
			throws Exception {
		
		IDBPoolService dbPoolService = MinimalServiceFactory.getPoolService(dbID);
		Connection con = dbPoolService.getConnection(ui.getName());
		String expName = null;
		
		try{
			ExperimentDAO expDao = DAOFactory.createExperimentDAO(dbID);
			Experiment expBean = new Experiment();
			expBean.setUniqueid(BigDecimal.valueOf(Double.valueOf(selRow.getExpId())));
			List<Experiment> listExp = expDao.find(con, expBean);
			if(listExp.size()>0){
				expName = listExp.get(0).getName();	
			}else{
				log.error("Can't find name for experiment!");
			}
				
		}catch(Exception ex){
			log.error("Erro occured during getting experiment name.", ex);
		}finally{
			dbPoolService.releaseConnection(ui.getName(), con);
		}
		return expName;
	}


}
