package clinical.web.common.query;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.sql.Types;

import clinical.server.utils.OracleUtils;
import clinical.utils.Assertion;
import clinical.web.ISQLDialect;

public class OracleSQLDialect implements ISQLDialect {
	public OracleSQLDialect() {
	}

	/**
	 * prepareBooleanPredicate
	 *
	 * @param prefix
	 *            String
	 * @param value
	 *            boolean
	 * @return String
	 */
	public String prepareBooleanPredicate(String prefix, boolean value) {
		StringBuffer buf = new StringBuffer();
		buf.append(prefix);
		buf.append(' ').append(value ? "1" : "0");
		return buf.toString();
	}

	public String prepareBooleanValue(Boolean value) {
		return (value.booleanValue()) ? "1" : "0";
	}

	/**
	 * prepareSchemaObjectName
	 *
	 * @param schemaObjName
	 *            String
	 * @return String
	 */
	public String prepareSchemaObjectName(String schemaObjName) {
		return schemaObjName;
	}

	/**
	 * prepareString
	 *
	 * @param value
	 *            String
	 * @return String
	 */
	public String prepareString(String value) {
		StringBuffer buf = new StringBuffer();
		value = OracleUtils.escapeQuotes(value);
		buf.append('\'').append(value).append('\'');
		return buf.toString();
	}

	public String getDialectName() {
		return "OracleDialect";
	}

	@SuppressWarnings("unchecked")
	public void invokeSetter(Method m, Object vo, Object value, int colType)
			throws SQLException, InvocationTargetException,
			IllegalArgumentException, IllegalAccessException {
		if (value != null && value instanceof oracle.sql.TIMESTAMP) {
			m.invoke(vo, new Object[] { ((oracle.sql.TIMESTAMP) value)
					.timestampValue() });

		} else if (value != null && colType == Types.CLOB) {
			String s = OracleUtils.readCLOB((oracle.sql.CLOB) value);
			m.invoke(vo, new Object[] { s });
		} else {
			Class paramClazz = m.getParameterTypes()[0];
			if (paramClazz == Boolean.class) {
				Boolean boolValue = null;
				if (value != null) {
					boolValue = new Boolean(
							((BigDecimal) value).intValue() >= 1);
				}
				m.invoke(vo, new Object[] { boolValue });
			} else {

			//	System.out.println("vo:" + vo + "\nvalue:" + value
			//			+ "\ncolType=" + colType + "\nmethod=" + m.getName());
				if (value != null && value instanceof oracle.sql.DATE) {
					if (m.getParameterTypes()[0] == Timestamp.class) {
						Timestamp ts = ((oracle.sql.DATE) value)
								.timestampValue();
						m.invoke(vo, new Object[] { ts });
					} else {
						m.invoke(vo, new Object[] { new java.util.Date(
								((oracle.sql.DATE) value).longValue()) });
					}
				} else {
					m.invoke(vo, new Object[] { value });
				}
			}
		}
	}

	public String endsWithFunction(String schemaColName, String suffix) {
		Assertion.assertNotNull(suffix);
		String colName = prepareSchemaObjectName(schemaColName);

		StringBuilder sb = new StringBuilder(50);
		sb.append("substr(").append(colName).append(",length(");
		sb.append(colName).append(") - ").append(suffix.length() - 1);
		sb.append(",").append(suffix.length()).append(") = ");
		sb.append(prepareString(suffix));
		return sb.toString();
	}
}
