package clinical.web.forms;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.LabelValueBean;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.server.vo.Expsegment;
import clinical.server.vo.Protocol;
import clinical.web.Constants;
import clinical.web.common.IDBCache;
import clinical.web.common.UserInfo;
import clinical.web.common.query.QueryPartInfo;
import clinical.web.common.query.SearchPredicate;
import clinical.web.common.vo.AsScoreInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.exception.BaseException;
import clinical.web.helpers.ExperimentSelector;
import clinical.web.helpers.ExperimentSessionSelector;
import clinical.web.helpers.HeaderInfo;
import clinical.web.helpers.ProtocolSelector;
import clinical.web.helpers.ScoreValueSummary;
import clinical.web.helpers.ScoreValueSummaryHeader;
import clinical.web.helpers.SearchResultsIterator;
import clinical.web.helpers.SubCorticalVarInfo;
import clinical.web.vo.QueryInfo;
import clinical.web.vo.QuerySummary;
import clinical.web.vo.SubjectAsScoreValueSummary;

import clinical.web.GeneList;
import clinical.web.GeneQueryResults;
import clinical.web.GeneticObjs;
import clinical.web.GeneticSession;
import clinical.web.ServiceFactory;
import clinical.web.SnpList;
import clinical.xml.xcede.Label;

/**
 * 
 * @version $Id: AsQueryBuilderForm.java,v 1.19.2.1 2008/06/18 00:45:12 bozyurt
 *          Exp $
 * @author I. Burak Ozyurt
 */

public class AsQueryBuilderForm extends ActionForm {
	private static final long serialVersionUID = -6722513074008349889L;
	private List<AssessmentSelectionInfo> assessments = new LinkedList<AssessmentSelectionInfo>();
	private List<QueryPartInfo> queryParts = new ArrayList<QueryPartInfo>();
	private List<ScoreValueSummary> summaryList = new LinkedList<ScoreValueSummary>();
	private List<SubCorticalVarInfo> subcorticalVars = new LinkedList<SubCorticalVarInfo>();
	/** */
	private List<LabelValueBean> statNamePageList;
	private String selectedStatPage;
	private String statPageURL;
	private ScoreValueSummaryHeader svHeader;
	private SearchResultsIterator searchResultsIter;
	private SearchResultsIterator qsResultsIter;
	private String[] combinators;

	private StoredQuerySelector savedQuerySelector;

	private boolean savedQueryLoaded;
	private boolean allowMediatedQuery;

	private String expandCollapseKey;
	/* used for experiment selection for the assessment query */
	private ExperimentSelector expSelector;

	private QueryScopeSelector queryScopeSelector;

	/** a list of SubjectAsScoreValueSummary objects */
	private List<SubjectAsScoreValueSummary> sasvsList;
	private Log log = LogFactory.getLog("clinical");

	/** query building action performed currently */
	private String state = Constants.SEL_ASSESSMENT;

	private QueryInfo queryInfo;
	private List<QuerySummary> qsList;
	private String caQueryString;
	private String ddQueryString;
	private boolean supportAnalysisQuery;
	private boolean supportAssessmentQuery;
	
	/********* Jinran added for Imaging query ******************/
	private ProtocolSelector proSelector; 
	private String[] selectedProtocols;	
	private String[] allProtocols;
	private String[] selectedSegments;
	private String[] allSegments;	
	private List<Expsegment> listExpSegments;
	private String[] selectedDataTypes;
	private String[] selectedProVers;
	/***********************************************************/

	 /***************************************
     * Jinran added for genetics query
     ***************************************/
    private String chipIdAND = "and";      //AND OR operator
    private String genomeAND = "and";
    private String snpAND = "and";
    private String geneAND = "and";
    private String chromAND = "and";
    private String refseqAND = "and";
    private String gcScoreAND = "and";
    private String positionAND = "and";
    
    //0: Retrieve chipId info.	1: genomeRelease	2: snp	3: gene	4: chromo	5: ref sequence		6: gcscore	7: position
    private boolean results[] = new boolean[]{false, false, false, false, false, false, false, false};
    private boolean chromAll = false;
    private boolean chromArr[] = new boolean[26]; 	//0-21: chrom1-22 //22: chromM;	//23: chromX;//24: chromXY;//25: chromY
    private Collection<LabelValueBean> refSeqOpList = new ArrayList<LabelValueBean>();
    private String selectedRefSeqOp;
	private String selectedRefSeqOpLabel;
	private Collection<LabelValueBean> gcscoreOpList = new ArrayList<LabelValueBean>();
    private String selectedGcscoreOp;
	private String selectedGcscoreOpLabel;
	private Collection<LabelValueBean> posOpList = new ArrayList<LabelValueBean>();
    private String selectedPosOp;
	private String selectedPosOpLabel;
	
    private String refSeq;
    private double gcScore;
    private double gcScoreLB;
    private double gcScoreUB;
    private String position;
    private String positionLB;
    private String positionUB;
    private String snpName;
    private String snpValue;
    private String geneName;
    private String geneValue;
    
    private GeneticObjs geneticObj;
    
    private GeneQueryResults geneQResults;
    
    private ExperimentSessionSelector expSessionSel;
    /***************************************/
    
    private String strValidated;

	
	public AsQueryBuilderForm() {
		if (log.isDebugEnabled()) {
			log.debug("*** new AsQueryBuilderForm created");
		}

		queryScopeSelector = new QueryScopeSelector();
		setGeneQResults(new GeneQueryResults());		
		
		refSeqOpList.add(new LabelValueBean("=","equal"));
		refSeqOpList.add(new LabelValueBean("starts with","starts"));
		refSeqOpList.add(new LabelValueBean("ends with","ends"));
		refSeqOpList.add(new LabelValueBean("any of","any"));
		
		gcscoreOpList.add(new LabelValueBean("=", "equals"));
		gcscoreOpList.add(new LabelValueBean(">", "greater"));
		gcscoreOpList.add(new LabelValueBean("<", "less"));
		gcscoreOpList.add(new LabelValueBean("!=", "greaterless"));
		gcscoreOpList.add(new LabelValueBean(">=", "greaterequal"));
		gcscoreOpList.add(new LabelValueBean("<=", "lessequal"));

		posOpList.add(new LabelValueBean("=", "equals"));
		posOpList.add(new LabelValueBean(">", "greater"));
		posOpList.add(new LabelValueBean("<", "less"));
		posOpList.add(new LabelValueBean("!=", "greaterless"));
		posOpList.add(new LabelValueBean(">=", "greaterequal"));
		posOpList.add(new LabelValueBean("<=", "lessequal"));
		
	}

	public void initializeQueryForm(){
	    //set initial genetics part
		boolean results[] = new boolean[]{false, false, false, false, false, false, false, false};
		this.setResults(results);
		this.setChipIdAND("and");
		this.setGenomeAND("and");
		this.setSnpAND("and");
	    this.setGeneAND("and");
	    this.setChromAND("and");
	    this.setRefseqAND("and");
	    this.setGcScoreAND("and");
	    this.setPositionAND("and");
	    this.setSelectedRefSeqOp("=");
	    this.setRefSeq("");
	    this.setSelectedGcscoreOp("=");
	    this.setGcScore(0.0);
	    this.setGcScoreLB(0.0);
	    this.setGcScoreUB(0.0);
	    this.setSelectedPosOp("=");
	    this.setPosition("");
	    this.setPositionLB("");
	    this.setPositionUB("");	    
	    
	    //set initial imaging part	    	    	    
		BigDecimal[] ids = new BigDecimal[1];
		ids[0] = BigDecimal.valueOf(-1);
		if(this.proSelector.getProtocolCols().size()>0){
			proSelector.setSelProtocolIds(ids);
		}
		if(proSelector.getProtocolVers().size()>0){
			proSelector.setSelProtocolVers(ids);
		}
		if(proSelector.getDataTypes().size()>0){
			proSelector.setSelDataTypes(ids);
		}
	}
	
	public void setStatPageURL(String newStatPageURL) {
		this.statPageURL = newStatPageURL;
	}

	public String getStatPageURL() {
		return this.statPageURL;
	}

	public void populateStatNamePageList(
			LinkedHashMap<String, String> namePageMap) {
		statNamePageList = new ArrayList<LabelValueBean>(namePageMap.size());
		for (Map.Entry<String, String> entry : namePageMap.entrySet()) {
			LabelValueBean lvb = new LabelValueBean(entry.getKey(), entry
					.getValue());
			statNamePageList.add(lvb);
		}
	}

	public Collection<LabelValueBean> getStatNamePageList() {
		return statNamePageList;
	}

	public void setSelectedStatPage(String newSelectedStatPage) {
		this.selectedStatPage = newSelectedStatPage;
	}

	public String getSelectedStatPage() {
		return this.selectedStatPage;
	}

	public void addAssessment(AssessmentSelectionInfo asi) {
		assessments.add(asi);
	}

	public void addQueryPart(QueryPartInfo queryPart) {
		queryParts.add(queryPart);
	}

	public void addSubcorticalVar(SubCorticalVarInfo scvi) {
		subcorticalVars.add(scvi);
	}

	public void clearSubcorticalVars() {
		subcorticalVars.clear();
	}

	public void clearQueryParts() {
		queryParts.clear();
		combinators = null;
	}

	// to select stored queries
	public void setSavedQuerySelector(StoredQuerySelector newSavedQuerySelector) {
		this.savedQuerySelector = newSavedQuerySelector;
	}

	public StoredQuerySelector getSavedQuerySelector() {
		return this.savedQuerySelector;
	}

	public void setSavedQueryLoaded(boolean newSavedQueryLoaded) {
		this.savedQueryLoaded = newSavedQueryLoaded;
	}

	public boolean getSavedQueryLoaded() {
		return this.savedQueryLoaded;
	}

	public void setAllowMediatedQuery(boolean newAllowMediatedQuery) {
		this.allowMediatedQuery = newAllowMediatedQuery;
	}

	public boolean getAllowMediatedQuery() {
		return this.allowMediatedQuery;
	}

	/**
	 * Returns a list of <code>AssessmentSelectionInfo</code> objects
	 * 
	 * @return a list of <code>AssessmentSelectionInfo</code> objects
	 */
	public List<AssessmentSelectionInfo> getAssessments() {
		return assessments;
	}

	/**
	 * 
	 * @return a list of <code>QueryPartInfo</code> objects
	 */
	public List<QueryPartInfo> getQueryParts() {
		if (log.isDebugEnabled())
			log.debug("getQueryParts:" + queryParts);
		return queryParts;
	}

	/**
	 * 
	 * @return a list of <code>SubCorticalVarInfo</code> objects
	 */
	public List<SubCorticalVarInfo> getSubcorticalVars() {
		return subcorticalVars;
	}

	// indexed property
	public String getCombinator(int idx) {
		return combinators[idx];
	}

	public String[] getCombinators() {
		return combinators;
	}

	// indexed property
	public QueryPartInfo getQp(int idx) {
		return queryParts.get(idx);
	}

	// indexed property
	public SubCorticalVarInfo getSv(int idx) {
		return subcorticalVars.get(idx);
	}

	public AssessmentSelectionInfo getAsi(int idx) {
		if (log.isDebugEnabled())
			log.debug("getAsi: size=" + assessments.size() + ", idx=" + idx);
		if (idx > assessments.size())
			return null;
		return assessments.get(idx);
	}

	public String getState() {
		return this.state;
	}

	public void setState(String newState) {
		this.state = newState;
		log.info("**** State is set to " + newState);
	}

	public void setExpSelector(ExperimentSelector newExpSelector) {
		this.expSelector = newExpSelector;
	}

	public ExperimentSelector getExpSelector() {
		// log.info("getExpSelector(): " + this.expSelector);
		return this.expSelector;
	}

	public void setSvHeader(ScoreValueSummaryHeader svHeader) {
		this.svHeader = svHeader;
	}

	public void setSummaryList(List<ScoreValueSummary> summaryList) {
		this.summaryList = summaryList;
	}

	public List<ScoreValueSummary> getSummaryList() {
		return summaryList;
	}

	public List<HeaderInfo> getHeaders() {
		return svHeader.getHeaders();
	}

	public int getHeadersColumnCount() {
		int size = 0;
		try {
			for (HeaderInfo hi : svHeader.getHeaders()) {
				size += hi.getSize();
			}
		} catch (RuntimeException t) {
			t.printStackTrace();
			throw t;
		}

		if (size == 0) {
			size = 1;
		}
		return size;
	}

	/**
	 * returns the total number of columns for the header divided by 2
	 * 
	 * @return
	 */
	public int getFirstHalfOfTotColumnCount() {
		int numCols = getHeadersColumnCount();
		return (numCols + 2) / 2;
	}

	public int getSecondHalfOfTotColumnCount() {
		int numCols = getHeadersColumnCount();
		return numCols + 2 - (numCols + 2) / 2;
	}

	public void clean() {
		this.state = Constants.SEL_ASSESSMENT;
		queryParts.clear();

		if (assessments != null) {
			assessments.clear();
			/*
			 * for (Iterator<AssessmentSelectionInfo> it = assessments.iterator();
			 * it .hasNext();) { AssessmentSelectionInfo asi = it.next(); if
			 * (asi.isSelected()) { asi.getScores().clear(); } }
			 */
		}
		resetCollectQuery();
		searchResultsIter = null;
		qsResultsIter = null;
		subcorticalVars.clear();
	}

	public void resetUserSelections() {
		for (Iterator<AssessmentSelectionInfo> it = assessments.iterator(); it
				.hasNext();) {
			AssessmentSelectionInfo asi = it.next();
			if (asi.isSelected()) {
				asi.setSelected(false);
				asi.getScores().clear();
			}
		}
		subcorticalVars.clear();
	}

	public void reset(ActionMapping mapping, HttpServletRequest request) {
		System.out.println("XXXXXXXX in RESET");
		if (state.equals(Constants.COLLECT_QUERY)) {
			resetCollectQuery();
		} else {
			for (Iterator<AssessmentSelectionInfo> it = assessments.iterator(); it
					.hasNext();) {
				AssessmentSelectionInfo asi = it.next();
				if (state.equals(Constants.SEL_ASSESSMENT)) {
					asi.setSelected(false);
				} else if (state.equals(Constants.SEL_SCORE)) {
					if (asi.isSelected()) {
						for (AsScoreInfo si : asi.getScores()) {
							si.setSelected(false);
						}
					}
				}
			}// for
		}
	}

	public void resetCollectQuery() {
		for (Iterator<QueryPartInfo> it = getQueryParts().iterator(); it
				.hasNext();) {
			QueryPartInfo qpi = it.next();
			qpi.setOperator(SearchPredicate.EQUAL);
			qpi.setRhs("");
			if (qpi.getScoreInfo() != null) {
				if (!qpi.getScoreInfo().getType().equals("varchar")) {
					qpi.setLowBound("");
					qpi.setUppBound("");
				}
			}
		}
		setSummaryList(null);
		setSvHeader(null);
	}

	public void setCombinator(int idx, String value) {
		combinators[idx] = value;
	}

	public void setCombinators(String[] combinators) {
		this.combinators = combinators;
	}

	public void setAsSelected(int idx, boolean value) {
		assessments.get(idx).setSelected(value);
	}

	/*
	 * public SearchResultsIterator getSearchResultsIterator() { return
	 * getSearchResultsIterator(false); }
	

	public SearchResultsIterator getSearchResultsIterator(boolean forceRenew) {
		if (forceRenew) {
			searchResultsIter = new SearchResultsIterator(summaryList, 20);
		} else {

			if (searchResultsIter == null && summaryList != null) {
				searchResultsIter = new SearchResultsIterator(summaryList, 20);
			}
		}
		return searchResultsIter;
	}
*/
	
	public SearchResultsIterator getQsSearchResultsIter() {
		return getQsSearchResultsIter(false);
	}

	public SearchResultsIterator getQsSearchResultsIter(boolean forceRenew) {
		if (forceRenew) {
			qsResultsIter = new SearchResultsIterator(qsList, 10);
		} else {
			if (qsResultsIter == null && qsList != null)
				qsResultsIter = new SearchResultsIterator(qsList, 10);
		}
		return qsResultsIter;
	}

	// for tree expand/collapse support
	public void setExpandCollapseKey(String newExpandCollapseKey) {
		this.expandCollapseKey = newExpandCollapseKey;
	}

	public String getExpandCollapseKey() {
		return this.expandCollapseKey;
	}

	// validation
	public ActionErrors validate(ActionMapping mapping,
			HttpServletRequest request) {
		ActionErrors errors = new ActionErrors();

		return errors;
	}

	public List<SubjectAsScoreValueSummary> getSasvsList() {
		return sasvsList;
	}

	public void setSasvsList(List<SubjectAsScoreValueSummary> sasvsList) {
		this.sasvsList = sasvsList;
	}

	public QueryScopeSelector getQueryScopeSelector() {
		return queryScopeSelector;
	}

	public QueryInfo getQueryInfo() {
		return queryInfo;
	}

	public void setQueryInfo(QueryInfo queryInfo) {
		this.queryInfo = queryInfo;
	}

	public List<QuerySummary> getQsList() {
		return qsList;
	}

	public void setQsList(List<QuerySummary> qsList) {
		this.qsList = qsList;
	}

	public String getCaQueryString() {
		return caQueryString;
	}

	public void setCaQueryString(String caQueryString) {
		this.caQueryString = caQueryString;
	}

	public String getDdQueryString() {
		return ddQueryString;
	}

	public void setDdQueryString(String ddQueryString) {
		this.ddQueryString = ddQueryString;
	}

	public void setSupportAnalysisQuery(boolean supportAnalysisQuery) {
		this.supportAnalysisQuery = supportAnalysisQuery;
	}

	public boolean isSupportAnalysisQuery() {
		return supportAnalysisQuery;
	}

	public void setSupportAssessmentQuery(boolean supportAssessmentQuery) {
		this.supportAssessmentQuery = supportAssessmentQuery;
	}

	public boolean isSupportAssessmentQuery() {
		return supportAssessmentQuery;
	}

	//Jinran added. To clear all items in assessment.
	public void deleteAssessment(){
		if(this.assessments!=null){
			this.assessments.clear();	
		}
	}
	
	public void setChipIdAND(String chipIdAND) {
		this.chipIdAND = chipIdAND;
	}
	
	public String getChipIdAND() {
		return chipIdAND;
	}
	
	public void setGenomeAND(String genomeAND) {
		this.genomeAND = genomeAND;
	}
	
	public String getGenomeAND() {
		return genomeAND;
	}
	
	public void setSnpAND(String snpAND) {
		this.snpAND = snpAND;
	}
	
	public String getSnpAND() {
		return snpAND;
	}
	
	public void setGeneAND(String geneAND) {
		this.geneAND = geneAND;
	}
	
	public String getGeneAND() {
		return geneAND;
	}
	
	public void setChromAND(String chromAND) {
		this.chromAND = chromAND;
	}
	
	public String getChromAND() {
		return chromAND;
	}
	
	public void setRefseqAND(String refseqAND) {
	     this.refseqAND = refseqAND;
	}
	
	public String getRefseqAND() {
	     return refseqAND;
	}
	
	public void setGcScoreAND(String gcScoreAND) {
	     this.gcScoreAND = gcScoreAND;
	}
	
	public String getGcScoreAND() {
	     return gcScoreAND;
	}
	
	public void setPositionAND(String positionAND) {
	     this.positionAND = positionAND;
	}
	
	public String getPositionAND() {
	     return positionAND;
	}
	
	public void setChromAll(boolean chromAll) {
	    this.chromAll = chromAll;
	}
	
	public boolean isChromAll() {
	    return chromAll;
	}
	
	public void setChromArr(boolean chromArr[]) {
	    this.chromArr = chromArr;
	}
	
	public boolean[] getChromArr() {
	    return chromArr;
	}
	
	public void setRefSeq(String refSeq) {
	    this.refSeq = refSeq;
	}
	
	public String getRefSeq() {
	    return refSeq;
	}
	
	public void setRefSeqOpList(Collection<LabelValueBean> refSeqOpList) {
	    this.refSeqOpList = refSeqOpList;
	}
	
	public Collection<LabelValueBean> getRefSeqOpList() {
	    return refSeqOpList;
	}
			
	public void setPosition(String position) {
	    this.position = position;
	}
	
	public String getPosition() {
	    return position;
	}
	public void setPositionLB(String positionLB) {
	    this.positionLB = positionLB;
	}
	
	public String getPositionLB() {
	    return positionLB;
	}
	
	public void setPositionUB(String positionUB) {
	    this.positionUB = positionUB;
	}
	
	public String getPositionUB() {
	    return positionUB;
	}

	public void setSnpName(String snpName) {
		this.snpName = snpName;
	}

	public String getSnpName() {
		return snpName;
	}

	public void setSnpValue(String snpValue) {
		this.snpValue = snpValue;
	}

	public String getSnpValue() {
		return snpValue;
	}
	
	public String getSNPListColsJSONStr() {
		try {
			JSONArray jsArr = new JSONArray();
			for(SnpList sl : geneticObj.getSnpListCols()){
				jsArr.put(sl.getName());
			}
			return jsArr.toString(2);
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return "[]";
	}

	public String getGENEListColsJSONStr() {
		try {
			JSONArray jsArr = new JSONArray();
			for(GeneList sl : geneticObj.getGeneListCols()){
				jsArr.put(sl.getName());
			}
			return jsArr.toString(2);
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return "[]";
	}

	public void setGeneticObj(GeneticObjs geneticObj) {
		this.geneticObj = geneticObj;
	}

	public GeneticObjs getGeneticObj() {
		return geneticObj;
	}

	public void setGeneQResults(GeneQueryResults geneQResults) {
		this.geneQResults = geneQResults;
	}

	public GeneQueryResults getGeneQResults() {
		return geneQResults;
	}

	public void setResults(boolean results[]) {
		this.results = results;
	}

	public boolean[] getResults() {
		return results;
	}

	public void setGcScore(double gcScore) {
		this.gcScore = gcScore;
	}

	public double getGcScore() {
		return gcScore;
	}

	public void setGcScoreLB(double gcScoreLB) {
		this.gcScoreLB = gcScoreLB;
	}

	public double getGcScoreLB() {
		return gcScoreLB;
	}

	public void setGcScoreUB(double gcScoreUB) {
		this.gcScoreUB = gcScoreUB;
	}

	public double getGcScoreUB() {
		return gcScoreUB;
	}

	public void setSelectedRefSeqOp(String selectedRefSeqOp) {
		this.selectedRefSeqOp = selectedRefSeqOp;
	}

	public String getSelectedRefSeqOp() {
		return selectedRefSeqOp;
	}

	public void setSelectedRefSeqOpLabel(String selectedRefSeqOpLabel) {
		this.selectedRefSeqOpLabel = selectedRefSeqOpLabel;
	}

	public String getSelectedRefSeqOpLabel() {
		if(this.refSeqOpList!=null){
			for(LabelValueBean lvb : this.refSeqOpList){
				if(lvb.getValue().equals(this.selectedRefSeqOp)){
					selectedRefSeqOpLabel = lvb.getLabel();
				}
			}			
		}
		return selectedRefSeqOpLabel;
	}

	public void setGcscoreOpList(Collection<LabelValueBean> gcscoreOpList) {
		this.gcscoreOpList = gcscoreOpList;
	}

	public Collection<LabelValueBean> getGcscoreOpList() {
		return gcscoreOpList;
	}

	public void setSelectedGcscoreOp(String selectedGcscoreOp) {
		this.selectedGcscoreOp = selectedGcscoreOp;
	}

	public String getSelectedGcscoreOp() {
		return selectedGcscoreOp;
	}

	public void setSelectedGcscoreOpLabel(String selectedGcscoreOpLabel) {
		this.selectedGcscoreOpLabel = selectedGcscoreOpLabel;
	}

	public String getSelectedGcscoreOpLabel() {
		if(this.gcscoreOpList!=null){
			for(LabelValueBean lvb : this.gcscoreOpList){
				if(lvb.getValue().equals(this.selectedGcscoreOp)){
					selectedGcscoreOpLabel = lvb.getLabel();
				}
			}			
		}
		return selectedGcscoreOpLabel;
	}

	public void setPosOpList(Collection<LabelValueBean> posOpList) {
		this.posOpList = posOpList;
	}

	public Collection<LabelValueBean> getPosOpList() {
		return posOpList;
	}

	public void setSelectedPosOp(String selectedPosOp) {
		this.selectedPosOp = selectedPosOp;
	}

	public String getSelectedPosOp() {
		return selectedPosOp;
	}

	public void setSelectedPosOpLabel(String selectedPosOpLabel) {
		this.selectedPosOpLabel = selectedPosOpLabel;
	}

	public String getSelectedPosOpLabel() {
		if(this.posOpList!=null){
			for(LabelValueBean lvb : this.posOpList){
				if(lvb.getValue().equals(this.selectedPosOp)){
					selectedPosOpLabel = lvb.getLabel();
				}
			}			
		}
		return selectedPosOpLabel;
	}

	public void setGeneName(String geneName) {
		this.geneName = geneName;
	}

	public String getGeneName() {
		return geneName;
	}

	public void setGeneValue(String geneValue) {
		this.geneValue = geneValue;
	}

	public String getGeneValue() {
		return geneValue;
	}

	public void setExpSessionSel(ExperimentSessionSelector expSessionSel) {
		this.expSessionSel = expSessionSel;
	}

	public ExperimentSessionSelector getExpSessionSel() {
		return expSessionSel;
	}

	public void setProSelector(ProtocolSelector proSelector) {
		this.proSelector = proSelector;
	}

	public ProtocolSelector getProSelector() {
		return proSelector;
	}
	
	public List<Protocol> getProtocols(String dbID, UserInfo ui)throws BaseException {
		IDBCache dbCache = ServiceFactory.getDBCache(dbID);
		List<Protocol> protocols = dbCache.getProtocols(ui, false);
		return protocols;
	}

	public List<Expsegment> getExpSegments(String dbID, UserInfo ui)throws BaseException {
		IDBCache dbCache = ServiceFactory.getDBCache(dbID);
		List<Expsegment> expSegments = dbCache.getExpsegments(ui, false);
		return expSegments;
	}
	
	public void setSelectedProtocols(String[] selectedProtocols) {
		this.selectedProtocols = selectedProtocols;
	}

	public String[] getSelectedProtocols() {
		return selectedProtocols;
	}

	public void setAllProtocols(String[] allProtocols) {
		this.allProtocols = allProtocols;
	}

	public String[] getAllProtocols() {
		String[] allPros = new String[proSelector.getProtocolCols().size()];
		int i = 0;
		for(LabelValueBean lvb : this.proSelector.getProtocolCols()){
			allPros[i++] = lvb.getLabel();
		}		
		return allPros;
	}

	public void setSelectedSegments(String[] selectedSegments) {
		this.selectedSegments = selectedSegments;
	}

	public String[] getSelectedSegments() {
		return selectedSegments;
	}

	public void setAllSegments(String[] allSegments) {
		this.allSegments = allSegments;
	}

	public String[] getAllSegments() {
		return allSegments;
	}

	public void setListExpSegments(List<Expsegment> listExpSegments) {
		this.listExpSegments = listExpSegments;
	}

	public List<Expsegment> getListExpSegments() {
		return listExpSegments;
	}

	public void setSelectedDataTypes(String[] selectedDataTypes) {
		this.selectedDataTypes = selectedDataTypes;
	}

	public String[] getSelectedDataTypes() {
		return selectedDataTypes;
	}

	public void setSelectedProVers(String[] selectedProVers) {
		this.selectedProVers = selectedProVers;
	}

	public String[] getSelectedProVers() {
		return selectedProVers;
	}
	
	public String getJSONStr() {
		try {
			JSONArray jsArr = toJSON();
			return jsArr.toString(2);
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return "[]";
	}

	public JSONArray toJSON() throws JSONException {
		JSONArray jsArr = new JSONArray();
		for (Object qs : getQsSearchResultsIter().getData() ) {
			QuerySummary qqss = (QuerySummary)qs;			
			jsArr.put(qqss.toJSON(new JSONObject()));
		}
		return jsArr;
	}

	public void setStrValidated(String strValidated) {
		this.strValidated = strValidated;
	}

	public String getStrValidated() {
		return strValidated;
	}

}


