package clinical.web.forms;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.LabelValueBean;

import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.IAppConfigService;
import clinical.web.ServiceFactory;
import clinical.web.exception.BaseException;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: LogonForm.java 91 2009-08-17 23:38:26Z bozyurt $
 */

public class LogonForm extends ActionForm implements Serializable {
	private static final long serialVersionUID = -6348223375212020522L;
	protected String username;
	private String password;
	private String dbID;
	private List<LabelValueBean> dbIDList;
	private LoginDBSelector loginDBSelector;
	private String errMessage;

	public LogonForm() {
		super();
	}

	public LogonForm(HttpServletRequest req) {
		super();
	}

	public ActionErrors validate(ActionMapping mapping,
			HttpServletRequest request) {
		ActionErrors errors = new ActionErrors();
		/** @todo */
		return errors;
	}

	public void reset(ActionMapping mapping, HttpServletRequest request) {
		username = null;
		password = null;
	}

	public void populateDbIDList(String[] dbIDs) {
		dbIDList = new ArrayList<LabelValueBean>(dbIDs.length);
		for (int i = 0; i < dbIDs.length; i++) {
			dbIDList.add(new LabelValueBean(dbIDs[i], dbIDs[i]));
		}

	}

	public String getDbIDList(int idx) {
		return ((LabelValueBean) dbIDList.get(idx)).getValue();
	}

	public Collection<LabelValueBean> getDbIDList() {
		if (dbIDList == null) {
			String[] dbIds = (String[]) super.getServlet().getServletContext()
					.getAttribute(Constants.DBID_LIST_KEY);

			populateDbIDList(dbIds);
		}
		return dbIDList;
	}

	public Collection<LabelValueBean> getList() {
		if (dbIDList == null) {
			String[] dbIds = (String[]) super.getServlet().getServletContext()
					.getAttribute(Constants.DBID_LIST_KEY);

			populateDbIDList(dbIds);
		}
		return (Collection<LabelValueBean>) dbIDList;
	}

	public String getUsername() {
		return username;
	}

	public String getPassword() {
		return password;
	}

	public String getDbID() {
		return this.dbID;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public void setDbID(String newDbID) {
		this.dbID = newDbID;
	}

	public LoginDBSelector getLoginDBSelector() {
		if (loginDBSelector == null) {
			List<String> dbIDList = (List<String>) super.getServlet()
					.getServletContext().getAttribute(Constants.DBID_LIST_KEY);
			String[] dbIds = new String[dbIDList.size()];
			dbIds = dbIDList.toArray(dbIds);
			this.loginDBSelector = new LoginDBSelector(dbIds);
			String defaultDBID = (String) super.getServlet()
					.getServletContext().getAttribute(
							Constants.DEFAULT_DBID_KEY);
			if (defaultDBID != null) {
				loginDBSelector.setSelectedDatabase(defaultDBID);
			}
		}
		return loginDBSelector;
	}

	public boolean isInPublicMode() {
		try {
			IAppConfigService configService = ServiceFactory
					.getAppConfigService();
			boolean inPublicMode = GenUtils.toBoolean(configService
					.getParamValue(Constants.IN_PUBLIC_MODE), false);
			return inPublicMode;
		} catch (BaseException be) {
			be.printStackTrace();
		}
		return false;
	}

	public String getErrMessage() {
		return errMessage;
	}

	public void setErrMessage(String errMessage) {
		this.errMessage = errMessage;
	}
}
