package clinical.web.forms;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

import clinical.web.vo.AssessmentInfo;
import clinical.web.vo.ReconScoreValueInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ReconciliationForm.java 91 2009-08-17 23:38:26Z bozyurt $
 */

public class ReconciliationForm extends ActionForm {
	private static final long serialVersionUID = -8822640649103224184L;
	protected String selectedSubjectID;
	/** the current visit id */
	protected String selectedVisitID;
	protected String selectedSegmentID;
	protected String selectedStudyID;
	protected String experimentID;
	protected AssessmentInfo theAsi;
	/** holds ReconScoreValueInfo objects */
	protected List<ReconScoreValueInfo> rsviList = new ArrayList<ReconScoreValueInfo>();
	/** holds only those ReconScoreValueInfo objects which are mismatched */
	protected List<ReconScoreValueInfo> mismatchedList;

	protected String[] selEntryIDAsGoodArr;
	protected Map<String, ReconScoreValueInfo> reconMap;

	public ReconciliationForm() {
	}

	public void addRsvi(ReconScoreValueInfo rsvi) {
		rsviList.add(rsvi);
	}

	public List<ReconScoreValueInfo> getRsviList() {
		return rsviList;
	}

	public void setMismatchedList(List<ReconScoreValueInfo> mList) {
		mismatchedList = mList;
		selEntryIDAsGoodArr = new String[mismatchedList.size()];
		for (int i = 0; i < selEntryIDAsGoodArr.length; i++) {
			selEntryIDAsGoodArr[i] = String.valueOf(-1);
		}
	}

	public List<ReconScoreValueInfo> getMismatchedList() {
		return this.mismatchedList;
	}

	public String[] getSelEntryIDAsGoodArr() {
		return selEntryIDAsGoodArr;
	}

	// indexed property
	public String getSelEntryIDAsGoodArr(int idx) {
		return selEntryIDAsGoodArr[idx];
	}

	public void setSelEntryIDAsGoodArr(int idx, String value) {
		// System.out.println("setSelEntryIDAsGoodArr("+ idx + ")=" + value);
		selEntryIDAsGoodArr[idx] = value;
	}

	public void setReconMap(Map<String, ReconScoreValueInfo> reconMap) {
		this.reconMap = reconMap;
	}

	public Map<String, ReconScoreValueInfo> getReconMap() {
		return this.reconMap;
	}

	// indexed property
	public ReconScoreValueInfo getRsvi(int idx) {
		return mismatchedList.get(idx);
	}

	// ---------------------- setters --------------
	public void setSelectedSubjectID(String newSelectedSubjectID) {
		this.selectedSubjectID = newSelectedSubjectID;
	}

	public void setSelectedVisitID(String newSelectedVisitID) {
		this.selectedVisitID = newSelectedVisitID;
	}

	public void setSelectedSegmentID(String newSelectedSegmentID) {
		this.selectedSegmentID = newSelectedSegmentID;
	}

	public void setSelectedStudyID(String newSelectedStudyID) {
		this.selectedStudyID = newSelectedStudyID;
	}

	public void setTheAsi(AssessmentInfo newTheAsi) {
		this.theAsi = newTheAsi;
	}

	public void setExperimentID(String newExperimentID) {
		this.experimentID = newExperimentID;
	}

	// ---------------------- getters --------------
	public String getSelectedSubjectID() {
		return this.selectedSubjectID;
	}

	public String getSelectedVisitID() {
		return this.selectedVisitID;
	}

	public String getSelectedSegmentID() {
		return this.selectedSegmentID;
	}

	public String getSelectedStudyID() {
		return this.selectedStudyID;
	}

	public AssessmentInfo getTheAsi() {
		return this.theAsi;
	}

	public String getExperimentID() {
		return this.experimentID;
	}

	public ActionErrors validate(ActionMapping mapping,
			HttpServletRequest request) {
		ActionErrors errors = new ActionErrors();
		/** no op */
		return errors;
	}

	public void reset(ActionMapping mapping, HttpServletRequest request) {
		/** no op */
	}
}
