package clinical.web.game.forms;

import java.util.*;
import javax.servlet.http.*;
import java.text.*;

import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;
/**
  *
  * @version $Id: CDSForm.java 91 2009-08-17 23:38:26Z bozyurt $
  * @author Generated by Clinical Assessment Layout Manager (CALM)
  */

public class CDSForm extends ActionForm {

    private String ASS= "";
    private String TYPE= "";
    private String CAL1= "";
    private String CAL2= "";
    private String CAL3= "";
    private String CAL4= "";
    private String CAL5= "";
    private String CAL6= "";
    private String CAL7= "";
    private String CAL8= "";
    private String CAL9= "";
    private String date = "";
    private String time = "";
    private String informantid = "";
    private String informantrelation = "";
    private DynamicDropDownSelector clinicalrater;

    // variables standard for each generated Assessment Struts Form Bean
    private String assessmentID;
    private String subjectID;
    private String experimentID;
    private String visitID;
    private String segmentID;
    private int currentPageIdx = 1;
    private String selectedQuestion = "";
    private String skippedQuestions = "";
    private String dataClassificationForSkipped = "";

    private static Map pageQuestionsMap;
    private static Map variableMap = null;
    private static Map mandatoryFieldMetaDataMap = null;

    public CDSForm() {
    }

    public String getASS() {  return this.ASS; }
    public String getTYPE() {  return this.TYPE; }
    public String getCAL1() {  return this.CAL1; }
    public String getCAL2() {  return this.CAL2; }
    public String getCAL3() {  return this.CAL3; }
    public String getCAL4() {  return this.CAL4; }
    public String getCAL5() {  return this.CAL5; }
    public String getCAL6() {  return this.CAL6; }
    public String getCAL7() {  return this.CAL7; }
    public String getCAL8() {  return this.CAL8; }
    public String getCAL9() {  return this.CAL9; }
    public String getDate() {  return this.date; }
    public String getTime() {  return this.time; }
    public String getInformantid() {  return this.informantid; }
    public String getInformantrelation() {  return this.informantrelation; }
    public DynamicDropDownSelector getClinicalrater() {  return this.clinicalrater; }

    public void setASS(String newValue) {  this.ASS = newValue; }
    public void setTYPE(String newValue) {  this.TYPE = newValue; }
    public void setCAL1(String newValue) {  this.CAL1 = newValue; }
    public void setCAL2(String newValue) {  this.CAL2 = newValue; }
    public void setCAL3(String newValue) {  this.CAL3 = newValue; }
    public void setCAL4(String newValue) {  this.CAL4 = newValue; }
    public void setCAL5(String newValue) {  this.CAL5 = newValue; }
    public void setCAL6(String newValue) {  this.CAL6 = newValue; }
    public void setCAL7(String newValue) {  this.CAL7 = newValue; }
    public void setCAL8(String newValue) {  this.CAL8 = newValue; }
    public void setCAL9(String newValue) {  this.CAL9 = newValue; }
    public void setDate(String newValue) {  this.date = newValue; }
    public void setTime(String newValue) {  this.time = newValue; }
    public void setInformantid(String newValue) {  this.informantid = newValue; }
    public void setInformantrelation(String newValue) {  this.informantrelation = newValue; }
    public void setClinicalrater(DynamicDropDownSelector newValue) {  this.clinicalrater = newValue; }

                    
                    
                    


    public String getAssessmentID() {  return this.assessmentID; }
    public String getSubjectID() {  return this.subjectID; }
    public String getExperimentID() {  return this.experimentID; }
    public String getVisitID() {  return this.visitID; }
    public String getSegmentID() {  return this.segmentID; }
    public int getCurrentPageIdx() {  return this.currentPageIdx; }
    public String getSelectedQuestion() {  return this.selectedQuestion; }
    public String getSkippedQuestions() {  return this.skippedQuestions; }
    public String getDataClassificationForSkipped() {  return this.dataClassificationForSkipped; }

    public void setAssessmentID(String newValue) {  this.assessmentID = newValue; }
    public void setSubjectID(String newValue) {  this.subjectID = newValue; }
    public void setExperimentID(String newValue) {  this.experimentID = newValue; }
    public void setVisitID(String newValue) {  this.visitID = newValue; }
    public void setSegmentID(String newValue) {  this.segmentID = newValue; }
    public void setCurrentPageIdx(int newValue) {  this.currentPageIdx = newValue; }
    public void setSelectedQuestion(String newValue) {  this.selectedQuestion = newValue; }
    public void setSkippedQuestions(String newValue) {  this.skippedQuestions = newValue; }
    public void setDataClassificationForSkipped(String newValue) {  this.dataClassificationForSkipped = newValue; }

    
public static class PageVariableInfo {
      int pageNumber;
      String formVarName;
      String dbVarName;
      Map metaDataMap;
      public PageVariableInfo(int pageNumber, String formVarName, String dbVarName) {
        this.pageNumber = pageNumber;
        this.formVarName = formVarName;
        this.dbVarName = dbVarName;
      }

      public int getPageNumber() { return this.pageNumber; }
      public String getFormVarName() { return this.formVarName; }
      public String getDbVarName() { return this.dbVarName; }
      public void addMetaData(String name, String value) {
        if (metaDataMap == null) {
          metaDataMap = new HashMap(3);
        }
        metaDataMap.put(name, value);
      }
      public Map getMetaDataMap() { return metaDataMap; }
    }

    private final static String assessmentName = "Calgary Depression Scale";

    public static String getAssessmentName() { return assessmentName; }

    public static Map getVariableMap() {
      synchronized(CDSForm.class) {
        if (variableMap == null) {
      variableMap = new LinkedHashMap();
      PageVariableInfo pvi = null;

          variableMap.put("ASS", pvi = new PageVariableInfo(1,"ASS","ASS") );
          variableMap.put("TYPE", pvi = new PageVariableInfo(1,"TYPE","TYPE") );
          variableMap.put("CAL1", pvi = new PageVariableInfo(2,"CAL1","CAL1") );
          variableMap.put("CAL2", pvi = new PageVariableInfo(2,"CAL2","CAL2") );
          variableMap.put("CAL3", pvi = new PageVariableInfo(2,"CAL3","CAL3") );
          variableMap.put("CAL4", pvi = new PageVariableInfo(2,"CAL4","CAL4") );
          variableMap.put("CAL5", pvi = new PageVariableInfo(2,"CAL5","CAL5") );
          variableMap.put("CAL6", pvi = new PageVariableInfo(3,"CAL6","CAL6") );
          variableMap.put("CAL7", pvi = new PageVariableInfo(3,"CAL7","CAL7") );
          variableMap.put("CAL8", pvi = new PageVariableInfo(3,"CAL8","CAL8") );
          variableMap.put("CAL9", pvi = new PageVariableInfo(3,"CAL9","CAL9") );
        }
      }
      return variableMap;
    }
    public static Map getMandatoryFieldMetaDataMap() {
      if (mandatoryFieldMetaDataMap == null) {
        mandatoryFieldMetaDataMap = new HashMap(3);
        Map mdMap = new HashMap(3);
        mandatoryFieldMetaDataMap.put("clinicalrater",mdMap);
        mdMap.put("query","select a.name from nc_databaseuser a, nc_userclass b where a.userclass = b.uniqueid and b.name = 'researcher'");
      }
      return mandatoryFieldMetaDataMap;
    }


 public static class PageQuestionInfo {
    int pageNumber;
    int questionNumber;
    String type;
    int minAnswer;
    int maxAnswer;
    List scoreNames = new LinkedList();
    Map scoreNameIDMAp = new HashMap(3);

    public PageQuestionInfo(int pageNumber, int questionNumber, String type) {
      this(pageNumber, questionNumber, type, 1, 1);
    }

    public PageQuestionInfo(int pageNumber, int questionNumber, String type,
                            int minAnswer, int maxAnswer)
    {
      this.pageNumber = pageNumber;
      this.questionNumber = questionNumber;
      this.type = type;
      this.minAnswer = minAnswer;
      this.maxAnswer = maxAnswer;
    }

    public int getPageNumber() { return pageNumber; }
    public int getQuestionNumber() { return questionNumber; }
    public String getType() { return type; }
    public int getMinAnswer() { return minAnswer; }
    public int getMaxAnswer() { return maxAnswer; }

    public void addScoreNameIDAssoc(String scoreName, int id) {
       scoreNameIDMAp.put(scoreName, new Integer(id));
    }

    public Integer getIDForScoreName(String scoreName) {
       return (Integer) scoreNameIDMAp.get(scoreName);
    }

    public void addScoreName(String scoreName) {
      scoreNames.add(scoreName);
    }

    public List getScoreNames() { return scoreNames; }
  }


    public static Map getPageQuestionsMap() {
      synchronized(CDSForm.class) {
        if (pageQuestionsMap == null) {
          pageQuestionsMap = new LinkedHashMap();

          List list = null;
          PageQuestionInfo pqi = null;
          list = new LinkedList();
          pageQuestionsMap.put( new Integer(2), list);
          list.add( pqi = new PageQuestionInfo(2,3,"regular") );
          pqi.addScoreName("CAL1");
          pqi.addScoreNameIDAssoc("CAL1",0);
          list.add( pqi = new PageQuestionInfo(2,7,"regular") );
          pqi.addScoreName("CAL5");
          pqi.addScoreNameIDAssoc("CAL5",0);
          list.add( pqi = new PageQuestionInfo(2,6,"regular") );
          pqi.addScoreName("CAL4");
          pqi.addScoreNameIDAssoc("CAL4",0);
          list.add( pqi = new PageQuestionInfo(2,5,"regular") );
          pqi.addScoreName("CAL3");
          pqi.addScoreNameIDAssoc("CAL3",0);
          list.add( pqi = new PageQuestionInfo(2,13,"regular") );
          pqi.addScoreName("CAL2");
          pqi.addScoreNameIDAssoc("CAL2",0);
          list = new LinkedList();
          pageQuestionsMap.put( new Integer(1), list);
          list.add( pqi = new PageQuestionInfo(1,2,"regular") );
          pqi.addScoreName("TYPE");
          pqi.addScoreNameIDAssoc("TYPE",0);
          list.add( pqi = new PageQuestionInfo(1,1,"regular") );
          pqi.addScoreName("ASS");
          pqi.addScoreNameIDAssoc("ASS",0);
          list = new LinkedList();
          pageQuestionsMap.put( new Integer(3), list);
          list.add( pqi = new PageQuestionInfo(3,10,"regular") );
          pqi.addScoreName("CAL8");
          pqi.addScoreNameIDAssoc("CAL8",0);
          list.add( pqi = new PageQuestionInfo(3,9,"regular") );
          pqi.addScoreName("CAL7");
          pqi.addScoreNameIDAssoc("CAL7",0);
          list.add( pqi = new PageQuestionInfo(3,11,"regular") );
          pqi.addScoreName("CAL9");
          pqi.addScoreNameIDAssoc("CAL9",0);
          list.add( pqi = new PageQuestionInfo(3,8,"regular") );
          pqi.addScoreName("CAL6");
          pqi.addScoreNameIDAssoc("CAL6",0);
        }
      }
      return pageQuestionsMap;
    }

    private String q3_notes = "";
    private String q7_notes = "";
    private String q2_notes = "";
    private String q6_notes = "";
    private String q1_notes = "";
    private String q10_notes = "";
    private String q5_notes = "";
    private String q13_notes = "";
    private String q9_notes = "";
    private String q11_notes = "";
    private String q8_notes = "";

    public String getQ3_notes() {  return this.q3_notes; }
    public void setQ3_notes(String newValue) {  this.q3_notes = newValue; }
    public String getQ7_notes() {  return this.q7_notes; }
    public void setQ7_notes(String newValue) {  this.q7_notes = newValue; }
    public String getQ2_notes() {  return this.q2_notes; }
    public void setQ2_notes(String newValue) {  this.q2_notes = newValue; }
    public String getQ6_notes() {  return this.q6_notes; }
    public void setQ6_notes(String newValue) {  this.q6_notes = newValue; }
    public String getQ1_notes() {  return this.q1_notes; }
    public void setQ1_notes(String newValue) {  this.q1_notes = newValue; }
    public String getQ10_notes() {  return this.q10_notes; }
    public void setQ10_notes(String newValue) {  this.q10_notes = newValue; }
    public String getQ5_notes() {  return this.q5_notes; }
    public void setQ5_notes(String newValue) {  this.q5_notes = newValue; }
    public String getQ13_notes() {  return this.q13_notes; }
    public void setQ13_notes(String newValue) {  this.q13_notes = newValue; }
    public String getQ9_notes() {  return this.q9_notes; }
    public void setQ9_notes(String newValue) {  this.q9_notes = newValue; }
    public String getQ11_notes() {  return this.q11_notes; }
    public void setQ11_notes(String newValue) {  this.q11_notes = newValue; }
    public String getQ8_notes() {  return this.q8_notes; }
    public void setQ8_notes(String newValue) {  this.q8_notes = newValue; }
    
    public void reset(ActionMapping mapping, HttpServletRequest request) {
    }
}
