package clinical.web.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.struts.util.LabelValueBean;

import clinical.server.vo.Experiment;

public class ExperimentSessionSelector {
	private static final long serialVersionUID = 1L;
	protected Collection<LabelValueBean> experimentInfos;
	protected int selectedExpSessionID;
	public final static int ALL_EXPERIMENTS = -1;

	public ExperimentSessionSelector(List<Experiment> experiments) {
		experimentInfos = new ArrayList<LabelValueBean>(experiments.size() + 2);
		LabelValueBean lvb = new LabelValueBean("All Experiments Sessions", String
				.valueOf(ALL_EXPERIMENTS));
		experimentInfos.add(lvb);
		for (Experiment exp : experiments) {
			lvb = new LabelValueBean(exp.getName() + " Sessions", exp.getUniqueid()
					.toString());
			experimentInfos.add(lvb);
		}
		selectedExpSessionID = ALL_EXPERIMENTS;
	}

	public Collection<LabelValueBean> getExperimentInfos() {
		return this.experimentInfos;
	}

	public void setSelectedExpSessionID(int newSelectedExpSessionID) {
		this.selectedExpSessionID = newSelectedExpSessionID;
	}

	public int getSelectedExpSessionID() {
		return this.selectedExpSessionID;
	}

}
