package clinical.web.helpers;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import clinical.server.dao.TuplecolumnsDAO;
import clinical.server.vo.Tuplecolumns;
import clinical.web.Constants;
import clinical.web.DAOFactory;
import clinical.xml.xcede2.AnatomicalEntityT;
import clinical.xml.xcede2.TerminologyStringT;
import clinical.xml.xcede2.ValueTypesT;

/**
 * @author I. Burak Ozyurt
 * @version $Id: ExtendedTupleHelper.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class ExtendedTupleHelper {
	protected String dbID;

	public ExtendedTupleHelper(String dbID) {
		super();
		this.dbID = dbID;
	}

	public List<Tuplecolumns> getColumnsForTuple(Connection con,
			BigDecimal extendedTupleID) throws Exception {
		TuplecolumnsDAO dao = DAOFactory.createTuplecolumnsDAO(dbID);

		Tuplecolumns cr = new Tuplecolumns();
		cr.setExtendedtupleid(extendedTupleID);

		return dao.find(con, cr);
	}
	
	public Map<String, Tuplecolumns> getColumMapForTuple(Connection con,
			BigDecimal extendedTupleID) throws Exception {
		List<Tuplecolumns> tcList = getColumnsForTuple(con, extendedTupleID);
		Map<String, Tuplecolumns> tcMap = new HashMap<String, Tuplecolumns>();
		for (Tuplecolumns tc : tcList) {
			tcMap.put(tc.getColumnname(), tc);
		}
		return tcMap;
	}

	public static boolean hasUnit(String unitStr, String columnUnit) {
		if (columnUnit == null || !columnUnit.equals(unitStr)) {
			return false;
		}
		return !columnUnit.equals("unitless");
	}
	
	
	public void addAnatomicalEntity(String label, AnatomicalEntityT ae) {
		if ( ae.getLabel().isEmpty()) {
			TerminologyStringT ts = new TerminologyStringT();
			ae.getLabel().add(ts);
		} 
		ae.getLabel().get(0).setValue(label);				
	}
	
	public void addNomenclature(String nomenclature, AnatomicalEntityT ae) {
		if ( ae.getLabel().isEmpty()) {
			TerminologyStringT ts = new TerminologyStringT();
			ae.getLabel().add(ts);
		} 
		ae.getLabel().get(0).setNomenclature(nomenclature);		
	}
	
	public void addTermID(String termID, AnatomicalEntityT ae) {
		if ( ae.getLabel().isEmpty()) {
			TerminologyStringT ts = new TerminologyStringT();
			ae.getLabel().add(ts);
		} 
		ae.getLabel().get(0).setTermID(termID);		
	}
	
	public void addLaterality(String laterality, AnatomicalEntityT ae) {
		ae.setLaterality(laterality);
	}
	
	public void addTissueType(String tissueType, AnatomicalEntityT ae) {
		ae.setTissueType(tissueType);
	}
	
	
	public static ValueTypesT getColumnType(String columnTypeStr) {
		if ( columnTypeStr.equals(Constants.FLOAT_TYPE)) {
			return ValueTypesT.FLOAT;
		} else if ( columnTypeStr.equals(Constants.VARCHAR_TYPE) ) {
			return ValueTypesT.VARCHAR;
		} else if (columnTypeStr.equals(Constants.INTEGER_TYPE) ) {
			return ValueTypesT.INTEGER;
		} else {
			throw new IllegalArgumentException("Unsupported columnType:" + columnTypeStr);
		}
	}
}
