package clinical.web.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.apache.struts.util.LabelValueBean;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import com.sun.java.util.collections.Collections;

import clinical.server.vo.Protocol;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.xml.xcede.Label;

public class ProtocolSelector implements Serializable {	
	private static final long serialVersionUID = 1L;
	
	protected Collection<LabelValueBean> protocolCols = new ArrayList<LabelValueBean>();	
	protected BigDecimal[] selProtocolIds;
	
	protected Collection<LabelValueBean> protocolVers = new ArrayList<LabelValueBean>();
	protected BigDecimal[] selProtocolVers;

	private Collection<LabelValueBean> dataTypes = new ArrayList<LabelValueBean>();
	private BigDecimal[] selDataTypes;
	
	private List<String> selProDes;
	private List<String> selProNames;
	
	public final BigDecimal ALL_PROTOCOLS = BigDecimal.valueOf(-1);	
	public final BigDecimal ALL_VERSIONS = BigDecimal.valueOf(-1);
	public final BigDecimal ALL_TYPES = BigDecimal.valueOf(-1);

	
	public ProtocolSelector(List<Protocol> proList){		
		LabelValueBean lvb;		
		
		if(proList.size()>0){
			this.setProtocolCols(new ArrayList<LabelValueBean>(proList.size() + 1));		
			lvb = new LabelValueBean(Constants.ALL_PROTOCOLS, String.valueOf(ALL_PROTOCOLS));
			this.getProtocolCols().add(lvb);			
		}

		if(proList!=null){
			int i = 0;
			for(Protocol pro : proList){
				lvb = new LabelValueBean();
				lvb.setLabel(pro.getProtocolid());
				//lvb.setValue(pro.getUniqueid().toString());
				lvb.setValue(String.valueOf(i++));
				boolean bexist = false;
				for(LabelValueBean proLVB : this.getProtocolCols()){
					if(proLVB.getLabel().equals(lvb.getLabel())){
						bexist = true;
						break;
					}
				}
				if(bexist==false){
					this.getProtocolCols().add(lvb);
				}
			}
		}
		
		//add protocol versions to Collection protocolVers
		ArrayList<BigDecimal> proVerList = new ArrayList<BigDecimal>();
		for(Protocol pro : proList){
			boolean bExist = false;
			BigDecimal proVer = pro.getProtocolversion();
			for(BigDecimal bi : proVerList){
				if(proVer.equals(bi)){
					bExist = true;
					break;
				}
			}		
			if(bExist==false) {
				proVerList.add(proVer);
			}
		}
		if(proVerList.size()>0){
			this.setProtocolVers(new ArrayList<LabelValueBean>(proVerList.size()+1));
			lvb = new LabelValueBean(Constants.ALL_VERSIONS, String.valueOf(ALL_VERSIONS));
			this.protocolVers.add(lvb);			
		}
		if(proVerList!=null){
			for(BigDecimal bd : proVerList){
				lvb = new LabelValueBean();
				lvb.setLabel(bd.toString());
				lvb.setValue(bd.toString());
				this.protocolVers.add(lvb);
			}
		}
		
		//add data types to DataType list box
		Properties props = null;
		String []dataFormats = null;		
		try {
			props = GenUtils.loadProperties("/resources/application.properties");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}		
		for(String s : props.stringPropertyNames()){			
			if(s.equals("image.format")){
				dataFormats = props.getProperty(s).split(",");
				break;
			}
		}
		
		if(proList.size()>0){
			this.setDataTypes(new ArrayList<LabelValueBean>(dataFormats.length+1));
			lvb = new LabelValueBean(Constants.ALL_TYPES, String.valueOf(ALL_TYPES));
			this.getDataTypes().add(lvb);
			
			if(dataFormats!=null){
				int i=0;
				for(String sf : dataFormats){
					lvb = new LabelValueBean();
					lvb.setLabel(sf);
					lvb.setValue(String.valueOf(i++));
					this.dataTypes.add(lvb);
				}
			}			
		}		
	}

	public void setSelProDes(List<String> selProDes) {
		this.selProDes = selProDes;
	}

	public List<String> getSelProDes() {
		return selProDes;
	}

	public void setSelProNames(List<String> selProNames) {
		this.selProNames = selProNames;
	}

	public List<String> getSelProNames() {
		return selProNames;
	}

	public void setProtocolCols(Collection<LabelValueBean> protocolCols) {
		this.protocolCols = protocolCols;
	}

	public Collection<LabelValueBean> getProtocolCols() {
		return protocolCols;
	}

	public void setSelProtocolIds(BigDecimal[] selProtocolIds) {
		this.selProtocolIds = selProtocolIds;
	}

	public BigDecimal[] getSelProtocolIds() {
		return selProtocolIds;
	}

	public void setSelProtocolVers(BigDecimal[] selProtocolVers) {
		this.selProtocolVers = selProtocolVers;
	}

	public BigDecimal[] getSelProtocolVers() {
		return selProtocolVers;
	}

	public void setProtocolVers(Collection<LabelValueBean> protocolVers) {
		this.protocolVers = protocolVers;
	}

	public Collection<LabelValueBean> getProtocolVers() {
		return protocolVers;
	}

	public void setDataTypes(Collection<LabelValueBean> dataTypes) {
		this.dataTypes = dataTypes;
	}

	public Collection<LabelValueBean> getDataTypes() {
		return dataTypes;
	}

	public void setSelDataTypes(BigDecimal[] selDataTypes) {
		this.selDataTypes = selDataTypes;
	}

	public BigDecimal[] getSelDataTypes() {
		return selDataTypes;
	}

	public String getJSONStr(){
		JSONArray jsarray = new JSONArray();
		
		try {
			for(LabelValueBean lvb : protocolCols){
				JSONObject js = new JSONObject();			
				js.put("name", lvb.getLabel());
				js.put("id", lvb.getValue());
				jsarray.put(js);
			}
			
			return jsarray.toString(2);
			
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}		
	}
	
	public String getJSONStrVer(){
		JSONArray jsarray = new JSONArray();
		
		try {			
			for(LabelValueBean lvb : protocolVers){
				JSONObject js = new JSONObject();
				js.put("verName", lvb.getLabel());
				js.put("verId", lvb.getValue());
				jsarray.put(js);
			}
			return jsarray.toString(2);						
			
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}
	}
	
	public String getJSONStrTypes(){
		JSONArray jsarray = new JSONArray();
		
		try {			
			for(LabelValueBean lvb : dataTypes){
				JSONObject js = new JSONObject();
				js.put("typeName", lvb.getLabel());
				js.put("typeId", lvb.getValue());
				jsarray.put(js);
			}
			return jsarray.toString(2);						
			
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}
	}
}

