package clinical.web.helpers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.web.Constants;
import clinical.web.vo.AssessmentInfo;
import clinical.web.vo.AssessmentScoreValues;
import clinical.web.vo.ScoreValue;
import clinical.web.vo.AssessmentInfo.ScoreInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ScoreValuesDisplayHelper.java,v 1.10 2005/12/10 01:50:19
 *          bozyurt Exp $
 */
public class ScoreValuesDisplayHelper {
	private static Log log = LogFactory.getLog(ScoreValuesDisplayHelper.class);

	private ScoreValuesDisplayHelper() {
	}

	/**
	 * assuming each segment will have only a single assessment of the same type
	 * 
	 * @param asName
	 * @param segmentID
	 * @return
	 */
	public static String createScoreValueMapKey(String asName, int segmentID,
			int visitID) {
		StringBuilder sb = new StringBuilder();
		sb.append(asName).append(':').append(segmentID).append(':').append(
				visitID);
		return sb.toString();
	}

	public static ScoreValuesDisplayLayout getScoreValuesDisplayLayout(
			AssessmentInfo asi, int selSegmentID, int selVisitID,
			Map<String, AssessmentScoreValues> asScoreValuesMap)
			throws Throwable {
		ScoreValuesDisplayLayout svdl = new ScoreValuesDisplayLayout();

		String scoreValueMapKey = createScoreValueMapKey(asi.getName(),
				selSegmentID, selVisitID);

		AssessmentScoreValues asv = (AssessmentScoreValues) asScoreValuesMap
				.get(scoreValueMapKey);

		if (asv == null) {
			for (String key : asScoreValuesMap.keySet()) {
				log.info(" asScoreValuesMap key=" + key);
			}
		}

		if (asv == null) {
			// this means unless there is a bug in the code that will result asv
			// being null even though it should not be, there are no scores for this
			// assessment
			return svdl;
		}

		if (log.isDebugEnabled()) {
			log.debug("asv " + asv.getAssessmentName() + " segmentID="
					+ asv.getSegmentID());
			asv.dumpScoreInfos();
		}

		prepareScoreValuesLayoutForCA(asi, svdl, asv);

		return svdl;
	}

	public static void prepareScoreValuesLayoutForCA(AssessmentInfo asi,
			ScoreValuesDisplayLayout svdl, AssessmentScoreValues asv)
			throws Throwable {
		MultiValuedScoreGroupLayout mvScoreGroupLayout = null;
		int count;
		if (asv == null) {
			return;
		}

		Iterator<ScoreInfo> it = asi.getScores().iterator();
		while (it.hasNext()) {
			count = 0;
			List<String> scoreNames = new ArrayList<String>();
			List<ScoreValue> scoreValues = new ArrayList<ScoreValue>();
			while (count < Constants.MAX_COLUMNS_PER_ROW && it.hasNext()) {
				AssessmentInfo.ScoreInfo si = (AssessmentInfo.ScoreInfo) it
						.next();
				int noValues = asv.getScoreValueCount(si.getName());
				if (noValues > 1) {
					// log.info("score=" + si.getName() + " noValues=" +
					// noValues);
					if (mvScoreGroupLayout == null) {
						mvScoreGroupLayout = new MultiValuedScoreGroupLayout(
								asi.getName());
						svdl.setMvScoreGroupLayout(mvScoreGroupLayout);
					}

					MultiValuedScoreLayout mvsl = new MultiValuedScoreLayout(si
							.getName(), asi.getName());
					for (int i = 1; i <= noValues; i++) {
						ScoreValue sv = asv.getScoreValue(si.getName(), i);
						if (sv == null) {
							// create an empty one as place holder
							sv = new ScoreValue(si.getName(), null, 1);
							sv
									.setReason(Constants.MISSING_VALUE_CLASSIFICATION);
						}
						mvsl.addValue(sv.getValue());
					}
					mvScoreGroupLayout.addMultiValuedScoreLayout(mvsl);
					// since multi-valued scores are handled differently skip
					// this score
					continue;
				}

				scoreNames.add(si.getName());

				if (log.isDebugEnabled()) {
					log.debug(">> score=" + si.getName() + " value="
							+ asv.getScoreValue(si.getName(), 1));
				}

				/** @todo how to display missing values */
				ScoreValue sv = asv.getScoreValue(si.getName(), 1);
				if (sv == null) {
					// create an empty one as place holder
					sv = new ScoreValue(si.getName(), null, 1);
					sv.setReason(Constants.MISSING_VALUE_CLASSIFICATION);
				}
				scoreValues.add(sv);
				++count;
			}
			if (count == 0) {
				break;
			}

			ScoreNameRowInfo snri = new ScoreNameRowInfo(scoreNames,
					scoreValues);
			svdl.addScoreNameRowInfo(snri);
		}
	}
}// ;
