package clinical.web.image;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.web.IAppConfigService;
import clinical.web.ImageHandler;
import clinical.web.ServiceFactory;

/**
 * @author I. Burak Ozyurt
 * @version $Id: ConversionWorker.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class ConversionWorker implements Runnable {

	private String subjectID;
	private String cacheRoot, dataURI;
	private boolean finished = false;
	private String tarFileName;
	private Log log = LogFactory.getLog("worker");

	public ConversionWorker(String subjectID, String cacheRoot, String dataURI) {
		this.cacheRoot = cacheRoot;
		this.dataURI = dataURI;
		this.subjectID = subjectID;
	}

	public synchronized boolean isFinished() {
		return finished;
	}

	private synchronized void setFinished(boolean val) {
		finished = val;
		log.info("*******>>finished=" + finished);
	}

	public String getSubjectID() {
		return subjectID;
	}

	public String getTarFileName() {
		return tarFileName;
	}

	public String getCacheRoot() {
		return cacheRoot;
	}

	public String getDataURI() {
		return dataURI;
	}


	public void run() {
		// for test
		log.debug("started conversion...");
		ImageHandler imgHandler = null;
		try {
			imgHandler = ServiceFactory.getImageHandlerService();
            IAppConfigService configService = ServiceFactory.getAppConfigService();
			String tarFile = imgHandler.retrieveMRISeriesForSubject(cacheRoot,
					dataURI, configService);
			log.debug("got tarFile:" + tarFile);
			this.tarFileName = tarFile;

		} catch (Exception x) {
			log.error(x, x);
		}
		setFinished(true);
		log.debug("finished conversion");
	}
}