package clinical.web.scheduler;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import org.jdom.Element;

import clinical.utils.GenUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: JobRecord.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class JobRecord implements Serializable {
	private static final long serialVersionUID = 1L;
	protected String jobID;
	protected String type;
	protected String user;
	protected String description;
	protected Date date;
	protected String status;
	protected String errorMsg;
	protected String[] savedResultsFiles;
	protected boolean newlyAdded = false;
	protected Date dateFinished;
	protected int downloadCount;
	protected Date lastDownloadTime;
	protected long jobSize;

	public JobRecord(String user, String type, String jobid, Date date,
			String status, String description, String[] savedResultsFiles,
			boolean newlyAdded) {
		super();
		this.user = user;
		this.type = type;
		jobID = jobid;
		this.date = date;
		this.status = status;
		this.description = description;
		this.savedResultsFiles = savedResultsFiles;
		this.newlyAdded = newlyAdded;
	}

	public Element toXML() {
		Element e = new Element("job");
		e.setAttribute("id", jobID);
		e.setAttribute("type", type);
		e.setAttribute("user", user);
		e.setAttribute("date", String.valueOf(date.getTime()));
		e.setAttribute("status", status);
		e.setAttribute("new", String.valueOf(newlyAdded));
		Element de = new Element("desc");
		if (description != null) {
			de.addContent(description);
		}
		e.addContent(de);

		Element srfElem = new Element("resultFiles");
		for (int i = 0; i < savedResultsFiles.length; i++) {
			Element srfEl = new Element("resultFile");
			srfEl.addContent(savedResultsFiles[i]);
			srfElem.addContent(srfEl);
		}
		e.addContent(srfElem);

		if (errorMsg != null) {
			Element errElem = new Element("error");
			errElem.addContent(errorMsg);
			e.addContent(errElem);
		}
		return e;
	}

	public static JobRecord fromXML(Element elem) {
		String id = elem.getAttributeValue("id");
		String user = elem.getAttributeValue("user");
		String type = elem.getAttributeValue("type");
		long date = Long.parseLong(elem.getAttributeValue("date"));
		String status = elem.getAttributeValue("status");
		String desc = elem.getChildTextTrim("desc");
		List<?> children = elem.getChild("resultFiles").getChildren(
				"resultFile");
		String[] srfArr = new String[children.size()];
		for (int i = 0; i < srfArr.length; i++) {
			srfArr[i] = ((Element) children.get(i)).getTextTrim();
		}
		String v = elem.getAttributeValue("new");
		boolean newlyAdded = (v != null && v.equals("true"));
		JobRecord jr = new JobRecord(user, type, id, new Date(date), status,
				desc, srfArr, newlyAdded);
		if (elem.getChild("error") != null) {
			jr.errorMsg = elem.getChildTextTrim("error");
		}
		return jr;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("JobRecord::[");
		buf.append("jobID=").append(jobID);
		buf.append(",type=").append(type);
		buf.append(",user=").append(user);
		buf.append(",status=").append(status);
		buf.append(",date=").append(date);
		buf.append(",savedResultsFiles=").append(savedResultsFiles);
		buf.append(']');
		return buf.toString();
	}

	public Date getDate() {
		return date;
	}

	public String getErrorMsg() {
		return errorMsg;
	}

	public String getJobID() {
		return jobID;
	}

	public String getStatus() {
		return status;
	}

	public String getUser() {
		return user;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	void setStatus(String status) {
		this.status = status;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getType() {
		return type;
	}

	public String[] getSavedResultFiles() {
		return savedResultsFiles;
	}

	public boolean isNewlyAdded() {
		return newlyAdded;
	}

	public void setNewlyAdded(boolean newlyAdded) {
		this.newlyAdded = newlyAdded;
	}

	public Date getDateFinished() {
		return dateFinished;
	}

	public void setDateFinished(Date dateFinished) {
		this.dateFinished = dateFinished;
	}

	public int getDownloadCount() {
		return downloadCount;
	}

	public long getJobSize() {
		return jobSize;
	}

	public String getFormattedJobSize() {
		if (jobSize == 0)
			return "N/A";
		return GenUtils.formatFileSize(jobSize);
	}

	public void setDownloadCount(int downloadCount) {
		this.downloadCount = downloadCount;
	}

	public void setJobSize(long jobSize) {
		this.jobSize = jobSize;
	}

	public void setErrorMsg(String errorMsg) {
		this.errorMsg = errorMsg;
	}

	public Date getLastDownloadTime() {
		return lastDownloadTime;
	}

	public void setLastDownloadTime(Date lastDownloadTime) {
		this.lastDownloadTime = lastDownloadTime;
	}
}