package clinical.web.services;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.server.ReceivedfilesInfo;
import clinical.server.SelectedFileInfo;
import clinical.server.dao.CollectionequipmentDAO;
import clinical.server.dao.ConfParamsDAO;
import clinical.server.dao.DataobjectDAO;
import clinical.server.dao.DataobjecttypeDAO;
import clinical.server.dao.ExpsegmentDAO;
import clinical.server.dao.ProtocolDAO;
import clinical.server.dao.RawdataDAO;
import clinical.server.dao.ReceivedfilesDAO;
import clinical.server.dao.ReceivedfilesdcmtagDAO;
import clinical.server.dao.SiteDAO;
import clinical.server.dao.TableidDAO;
import clinical.server.vo.Collectionequipment;
import clinical.server.vo.ConfParams;
import clinical.server.vo.Databaseuser;
import clinical.server.vo.Dataobject;
import clinical.server.vo.Dataobjecttype;
import clinical.server.vo.Experiment;
import clinical.server.vo.Expsegment;
import clinical.server.vo.Protocol;
import clinical.server.vo.Rawdata;
import clinical.server.vo.Receivedfiles;
import clinical.server.vo.Receivedfilesdcmtag;
import clinical.server.vo.Site;
import clinical.server.vo.Tableid;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.DAOFactory;
import clinical.web.DBUtils;
import clinical.web.IImagingFileService;
import clinical.web.ISequenceHelper;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBPoolService;
import clinical.web.common.ISecurityService;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.web.exception.DBPoolServiceException;
import clinical.web.helpers.ExpSubjInfo;

public class ImagingFileService implements IImagingFileService{
	/** Connection pool service interface */
	protected IDBPoolService dbPoolService;
	protected String dbType;
	protected ISecurityService securityService;

	/**
	 * interface for retrieving and caching nearly static data from the
	 * database.
	 */
	protected DBCache dbCache;
	/** unique number generator for primary keys */
	protected ISequenceHelper seqHelper;
	protected String dbID;
	private Log log = LogFactory.getLog(JobManagementServiceImpl.class);

	public ImagingFileService(String dbID) throws BaseException {
		dbPoolService = ServiceFactory.getPoolService(dbID);
		dbCache = DBCache.getInstance(dbID);
		seqHelper = ServiceFactory.getSequenceHelper(dbID);
		this.dbID = dbID;
		securityService = ServiceFactory.getSecurityService();
		this.dbType = securityService.getDBType(dbID);
	}

	@Override
	public List<Receivedfiles> getAllReceivedFiles(UserInfo ui)
			throws Exception {
		Connection con = null;
		try {
			con = dbPoolService.getConnection(ui.getName());
			ReceivedfilesDAO dao = DAOFactory.createReceivedfilesDAO(dbID);
			Receivedfiles criteriaBean = new Receivedfiles();
			return dao.find(con, criteriaBean);
		} catch (Exception x) {
			log.error("Error in getAllJobs", x);
			throw new Exception(x);
		} finally {
			releaseConnection(con, ui);
		}
	}

	protected void releaseConnection(Connection con, UserInfo ui) {
		if (con == null) {
			return;
		}
		try {
			dbPoolService.releaseConnection(ui.getName(), con);
		} catch (DBPoolServiceException x) {
			log.error("Cannot release connection for user " + ui.getName(), x);
		}
	}

	@Override
	public List<Receivedfilesdcmtag> getAllReceivedFilesDcmTags(UserInfo ui)
			throws Exception {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<ReceivedfilesInfo> getAllReceivedFilesInfo(UserInfo ui)
			throws Exception {
		Connection con = null;
		try {
			con = dbPoolService.getConnection(ui.getName());
			ReceivedfilesdcmtagDAO dao = DAOFactory.createReceivedfilesdcmtagDAO(dbID);
			ReceivedfilesInfo criteriaBean = new ReceivedfilesInfo();
			return dao.findReceivedFilesWithDcmTags(con, criteriaBean);
		} catch (Exception x) {
			log.error("Error in getAllJobs", x);
			throw new Exception(x);
		} finally {
			releaseConnection(con, ui);
		}	
	}
	
	public List<ReceivedfilesInfo> getDistinctReceivedFilesInfo(UserInfo ui)
			throws Exception {
		Connection con = null;
		try {
			con = dbPoolService.getConnection(ui.getName());
			ReceivedfilesdcmtagDAO dao = DAOFactory.createReceivedfilesdcmtagDAO(dbID);
			ReceivedfilesInfo criteriaBean = new ReceivedfilesInfo();
			return dao.findUnprocessedReceivedFilesBySeriesNoTime(con, criteriaBean);
		} catch (Exception x) {
			log.error("Error in getAllJobs", x);
			throw new Exception(x);
		} finally {
			releaseConnection(con, ui);
		}
		
	}
	
	public List<Experiment> getAllExperiments(UserInfo ui)
			throws Exception {		
		try {			
			List<Experiment> experiments = dbCache.getExperiments(ui, true);
			return experiments;
		} catch (Exception x) {
			log.error("Error in getAllJobs", x);
			throw new Exception(x);
		}		
	}
	
	public List<Experiment> getLocalStoredExperiments(UserInfo ui)
		throws Exception{
		try {			
			List<Experiment> experiments = dbCache.getLocalStoredExperiments(ui, true);
			return experiments;
		} catch (Exception x) {
			log.error("Error in getLocalStoredExperiment", x);
			throw new Exception(x);
		}
	}

	public List<ExpSubjInfo> getAllExpSubjInfo(UserInfo ui, boolean forceCache)
		throws Exception {		
		
		try{
			return dbCache.getAllExpSubjInfo(ui, forceCache);
		
//		Connection con = null;
//		List<ExpSubjInfo> expSubjInfos = new ArrayList<ExpSubjInfo>();
//		
//		try {			
//			con = dbPoolService.getConnection(ui.getName());
//			ISubjectVisitHandler handler = null;
//			handler = ServiceFactory.getSubjectVisitHandler();
//			
//			List<Experiment> exps = dbCache.getExperiments(ui, true);
//			for(Experiment exp : exps)
//			{
//				ExpSubjInfo expSubj = new ExpSubjInfo();
//				expSubj.setExperimentId(exp.getUniqueid().toString());
//				expSubj.setExperimentName(exp.getName());
//								
//				SubjexperimentDAO dao = DAOFactory.createSubjexperimentDAO(dbID);
//				Subjexperiment cr = new Subjexperiment();
//				cr.setNcExperimentUniqueid(exp.getUniqueid());
//
//				List<Subjexperiment> subjExps = dao.find(con, cr);
//				
//				for(Subjexperiment subjExp : subjExps){					
//					List<VisitInfo> visitInfos = handler.getVisitInfos(dbID, con, subjExp.getSubjectid());
//					subjExp.setVisitInfos(visitInfos);
//				}
//				expSubj.setSubjExps(subjExps);
//				
//				expSubjInfos.add(expSubj);
//			}			
			
		} catch (Exception x) {			
			log.error("Error in getAllJobs", x);
			throw new Exception(x);
		}		
	}
	
	public List<Protocol> getAllImageProtocols(UserInfo ui)
			throws Exception {		
		Connection con = null;
		try {
			con = dbPoolService.getConnection(ui.getName());
			ProtocolDAO dao = DAOFactory.createProtocolDAO(dbID);
			Protocol criteriaBean = new Protocol();
			return dao.find(con, criteriaBean);
		} catch (Exception x) {
			log.error("Error in getAllJobs", x);
			throw new Exception(x);
		} finally {
			releaseConnection(con, ui);
		}
	}
	
	
	public Boolean insertRawData(UserInfo ui, List<SelectedFileInfo> listFiles)
		throws Exception {
		Connection con = null;
		try{
			con = dbPoolService.getConnection(ui.getName());
			for(int i=0; i<listFiles.size(); i++){
				String subjectid = listFiles.get(i).getSubjectId();
				BigDecimal segmentId;
				
				RawdataDAO dao = DAOFactory.createRawdataDAO(dbID);
				Rawdata bean = new Rawdata();
				bean.setSubjectid(subjectid);				//set subjectid
				
				//get experiment uniqueid
				BigDecimal expUniqueId = new BigDecimal(listFiles.get(0).getExpId());				
				bean.setNcExperimentUniqueid(expUniqueId);	//set nc_experiment_uniqueid
				
				//get protocolid, protocolversion
				String[] sPro = listFiles.get(0).getProtocol().split(";;;");				
				BigDecimal protocolVersion = new BigDecimal(sPro[0]);
				String proId = sPro[1];
				bean.setProtocolid(proId);					//set protocolid
				bean.setProtocolversion(protocolVersion);	//set protocolversion
								
				//get component id
				String[] sVisit = listFiles.get(0).getVisit().split(";;;");
				BigDecimal compId = new BigDecimal(sVisit[0]);
				bean.setComponentid(compId);				//set componentid
				
				//get segment id
				ExpsegmentDAO segDao = DAOFactory.createExpsegmentDAO(dbID);
				Expsegment segBean = new Expsegment();
				segBean.setNcExperimentUniqueid(expUniqueId);
				segBean.setSubjectid(subjectid);
				segBean.setComponentid(compId);
				segBean.setStudyid(BigDecimal.valueOf(1));
				segBean.setName(proId);
				List<Expsegment> listExpSeg = segDao.find(con, segBean);
				segmentId = listExpSeg.get(0).getSegmentid();
				bean.setSegmentid(segmentId);				//set segmentid
				
				//get next uniqueid
				RawdataDAO rawdataDao = DAOFactory.createRawdataDAO(dbID);				
				BigDecimal uId = BigDecimal.valueOf(rawdataDao.getMaxUniqueId(con).intValueExact() + 1);
				bean.setUniqueid(uId);						//set uniquieid
				
				//get tableid, owner
				Rawdata oneRowRd = rawdataDao.getOneRowData(con);
				BigDecimal tableId = oneRowRd.getTableid();
				BigDecimal ownerId = oneRowRd.getOwner();
				BigDecimal scannerId = oneRowRd.getNcColequipmentUniqueid();
				bean.setTableid(tableId);					//set tableid
				bean.setOwner(ownerId);						//set ownerid
				bean.setModuser(ownerId);					//set moduser
				Date dt = new Date();			
				bean.setModtime(dt);						//set modtime
				bean.setExtensionname("nc_rawdata");		//set extension
				bean.setNcColequipmentUniqueid(scannerId);	//set scannerid
				bean.setIsraw(true);						//set israw
				bean.setOntologysource("UNKNOWN");			//set ontology
				bean.setConceptid("9999");					//set conceptid
				bean.setIsbad(false);						//set isbad
				
				
				
				dao.insert(con, bean);
			}
			return null;	
		}catch(Exception ex){
			log.error("Error in insertRawData", ex);
			throw new Exception(ex);
		}finally{
			releaseConnection(con, ui);
		}		
	}

	
	public Boolean insertExpSegment(UserInfo ui, SelectedFileInfo fileInfo)
		throws Exception {
		Connection con = null;
		try{
			con = dbPoolService.getConnection(ui.getName());
			ExpsegmentDAO dao = DAOFactory.createExpsegmentDAO(dbID);
			Expsegment bean = new Expsegment();
			
			String subjectid = fileInfo.getSubjectId();			
			bean.setSubjectid(subjectid);				//set subjectid
						
			//get experiment uniqueid
			BigDecimal expUniqueId = new BigDecimal(fileInfo.getExpId());				
			bean.setNcExperimentUniqueid(expUniqueId);	//set nc_experiment_uniqueid
			
			//get protocolid, protocolversion
			String[] sPro = fileInfo.getProtocol().split(";;;");				
			BigDecimal protocolVersion = new BigDecimal(sPro[0]);
			String proId = sPro[1];
			bean.setProtocolid(proId);					//set protocolid
			bean.setProtocolversion(protocolVersion);	//set protocolversion
							
			//get component id
			String[] sVisit = fileInfo.getVisit().split(";;;");
			BigDecimal compId = new BigDecimal(sVisit[0]);
			bean.setComponentid(compId);				//set componentid
			
			//get segmentid			
			Expsegment criteria = new Expsegment();
			criteria.setSubjectid(subjectid);
			criteria.setComponentid(compId);
			criteria.setNcExperimentUniqueid(expUniqueId);			
			List<?> segments = dao.find(con, criteria);
			int maxSegmentID = -1;
			for (Iterator<?> iter = segments.iterator(); iter.hasNext();) {
				Expsegment segment = (Expsegment) iter.next();
				if (segment.getSegmentid().intValue() > maxSegmentID) {
					maxSegmentID = segment.getSegmentid().intValue();
				}
			}
			if (maxSegmentID > 0) {
				maxSegmentID++;
			} else {
				maxSegmentID = 1;
			}
			bean.setSegmentid(GenUtils.toBigDecimal(maxSegmentID));							//set segmentid
			
			//get study id 
			String[] sStudy = fileInfo.getStudy().split(";;;");
			BigDecimal studyId = new BigDecimal(sStudy[0]);
			bean.setStudyid(studyId);															//set studyid
						
			//get next uniqueid			
			bean.setUniqueid(seqHelper.getNextUID(ui, Constants.SEGMENT_DB_TABLE, "uniqueid"));	//set uniquieid
			
			//get tableid, owner
			Expsegment expsegBean = new Expsegment();
			expsegBean.setSubjectid(subjectid);
			expsegBean.setNcExperimentUniqueid(expUniqueId);
			List<Expsegment> listrd = dao.find(con, expsegBean);
			BigDecimal tableId;
			BigDecimal ownerId; 
			if(listrd.size()<1){
				TableidDAO tDao = DAOFactory.createTableidDAO(dbID);
				Tableid tbBean = new Tableid();
				tbBean.setTablename(Constants.NCExpSegment);
				List<Tableid> listTB = tDao.find(con, tbBean);
				if(listTB.size()<1){
					log.error("Error in insertExpSegment. No TableId can be found.", new Exception());
					return false;
				}				
				tableId = listTB.get(0).getTableid();
				ownerId = listTB.get(0).getOwner();				
			}else{
				Expsegment oneRowRd = listrd.get(0);
				tableId = oneRowRd.getTableid();
				ownerId = oneRowRd.getOwner();					
			}
			bean.setTableid(tableId);					//set tableid
			bean.setOwner(ownerId);						//set ownerid
			bean.setModuser(ownerId);					//set moduser
			Date dt = new Date();			
			bean.setModtime(dt);						//set modtime
			Timestamp ts = new Timestamp(dt.getTime());	
			bean.setTimeStamp(ts);						//set timestamp
			bean.setIstimeinterval(false);				//set istimeinterval
			bean.setIsbad(false);						//set isbad
			bean.setDescription("");					//set description
			bean.setName("");							//set name
			
			dao.insert(con, bean);
			
			return true;	
		}catch(Exception ex){
			log.error("Error in insertExpsegment", ex);
			throw new Exception(ex);			
		}finally{
			releaseConnection(con, ui);
		}		
	}

	
	public Boolean insertRawData(UserInfo ui, SelectedFileInfo fileInfo, String equipment, 
			List<BigDecimal> uId )
		throws Exception {
		Connection con = null;
		try{
			con = dbPoolService.getConnection(ui.getName());
			RawdataDAO dao = DAOFactory.createRawdataDAO(dbID);
			Rawdata bean = new Rawdata();
			
			String subjectid = fileInfo.getSubjectId();			
			bean.setSubjectid(subjectid);				//set subjectid
			
			//get experiment uniqueid
			BigDecimal expUniqueId = new BigDecimal(fileInfo.getExpId());				
			bean.setNcExperimentUniqueid(expUniqueId);	//set nc_experiment_uniqueid
			
			//get protocolid, protocolversion
			String[] sPro = fileInfo.getProtocol().split(";;;");				
			BigDecimal protocolVersion = new BigDecimal(sPro[0]);
			String proId = sPro[1];
			bean.setProtocolid(proId);					//set protocolid
			bean.setProtocolversion(protocolVersion);	//set protocolversion
							
			//get component id
			String[] sVisit = fileInfo.getVisit().split(";;;");
			BigDecimal compId = new BigDecimal(sVisit[0]);
			bean.setComponentid(compId);				//set componentid
			
			//get study id 
			String[] sStudy = fileInfo.getStudy().split(";;;");
			BigDecimal studyId = new BigDecimal(sStudy[0]);			
			
			//get segment id
			BigDecimal segmentId;
			ExpsegmentDAO segDao = DAOFactory.createExpsegmentDAO(dbID);
			Expsegment segBean = new Expsegment();
			segBean.setNcExperimentUniqueid(expUniqueId);
			segBean.setSubjectid(subjectid);
			segBean.setComponentid(compId);
			segBean.setStudyid(studyId);
			segBean.setProtocolid(proId);
			List<Expsegment> listExpSeg = segDao.find(con, segBean);		
			//check listExpseg here
			if(listExpSeg.size()<1){
				log.error("expId: " + expUniqueId + "\n subjId: " + subjectid + "\n compId: " + compId + " \nproId: "+ proId);
				log.error("Error in insertRawData. No segmentid has been found.", new Exception());
				return false;
			}
			segmentId = listExpSeg.get(0).getSegmentid();
			bean.setSegmentid(segmentId);				//set segmentid
			
			//get next uniqueid
//			RawdataDAO rawdataDao = DAOFactory.createRawdataDAO(dbID);
//			if(rawdataDao.getMaxUniqueId(con)!=null){
//				uId.add(BigDecimal.valueOf(rawdataDao.getMaxUniqueId(con).intValueExact() + 1));	
//			}else{
//				uId.add(BigDecimal.valueOf(1));
//			}
//			
//			bean.setUniqueid(uId.get(0));						//set uniquieid
			
			//get next uniqueid
			uId.add(seqHelper.getNextUID(ui, Constants.NCRawData, "uniqueid"));
			bean.setUniqueid(uId.get(0));	//set uniquieid
			
			//get tableid, owner
			Rawdata rdBean = new Rawdata();
			rdBean.setSubjectid(subjectid);
			rdBean.setNcExperimentUniqueid(expUniqueId);
			List<Rawdata> listrd = dao.find(con, rdBean);
			BigDecimal tableId;
			BigDecimal ownerId; 
			if(listrd.size()<1){
				TableidDAO tDao = DAOFactory.createTableidDAO(dbID);
				Tableid tbBean = new Tableid();
				tbBean.setTablename(Constants.NCRawData);
				List<Tableid> listTB = tDao.find(con, tbBean);
				if(listTB.size()<1){
					log.error("Error in insertRawData. No TableId can be found.", new Exception());
					return false;
				}				
				tableId = listTB.get(0).getTableid();
				ownerId = listTB.get(0).getOwner();				
			}else{
				Rawdata oneRowRd = listrd.get(0);
				tableId = oneRowRd.getTableid();
				ownerId = oneRowRd.getOwner();					
			}
			bean.setTableid(tableId);					//set tableid
			bean.setOwner(ownerId);						//set ownerid
			bean.setModuser(ownerId);					//set moduser
			Date dt = new Date();			
			bean.setModtime(dt);						//set modtime
			bean.setExtensionname("nc_rawdata");		//set extension			
			bean.setIsraw(true);						//set israw
			bean.setOntologysource("UNKNOWN");			//set ontology
			bean.setConceptid("9999");					//set conceptid
			bean.setIsbad(false);						//set isbad
			
			//get equipment id	
			BigDecimal scannerId = BigDecimal.valueOf(Double.valueOf(equipment));
			bean.setNcColequipmentUniqueid(scannerId);	//set scannerid						
			
			// get target directory
			String targetDir = fileInfo.getTemplocation();					
			bean.setDatauri(targetDir);					//set datauri
			
			dao.insert(con, bean);
			
			return true;	
		}catch(Exception ex){
			log.error("Error in insertRawData", ex);
			throw new Exception(ex);			
		}finally{
			releaseConnection(con, ui);
		}		
	}

	
	public Boolean insertDataObject(UserInfo ui, SelectedFileInfo fileInfo, BigDecimal rawDataId, long fileSize)
		throws Exception {
		Connection con = null;
		try{
			con = dbPoolService.getConnection(ui.getName());
			DataobjectDAO dao = DAOFactory.createDataobjectDAO(dbID);
			Dataobject bean = new Dataobject();
			
			//get next uniqueid
//			BigDecimal uId =null;
//			if(dao.getMaxUniqueId(con)!=null){
//				uId = BigDecimal.valueOf(dao.getMaxUniqueId(con).intValueExact() + 1);	
//			}else{
//				uId = BigDecimal.valueOf(1);
//			}			
//			bean.setUniqueid(uId);						//set uniquieid
			bean.setUniqueid(seqHelper.getNextUID(ui, Constants.NCDataObject, "uniqueid"));	//set uniquieid
			
			//get tableid, owner, etc.
			BigDecimal tableId = null;
			BigDecimal ownerId = null;
			String extension = null;
			Dataobject doBean = new Dataobject();
			List<Dataobject> lstDO = dao.find(con, doBean);
			if(lstDO.size()<1){
				TableidDAO tDao = DAOFactory.createTableidDAO(dbID);
				Tableid tbBean = new Tableid();
				tbBean.setTablename(Constants.NCDataObject);
				List<Tableid> listTB = tDao.find(con, tbBean);
				if(listTB.size()<1){
					log.error("Error in insertDataObject. No TableId can be found.", new Exception());
					return false;
				}				
				tableId = listTB.get(0).getTableid();
				ownerId = listTB.get(0).getOwner();
				extension = "rawData";
			}else{
				tableId = lstDO.get(0).getTableid();
				ownerId = lstDO.get(0).getOwner();
				extension = lstDO.get(0).getExtensionname();	
			}		
			
			bean.setTableid(tableId);					//set tableid
			bean.setOwner(ownerId);						//set ownerid
			bean.setModuser(ownerId);					//set moduser
			Date dt = new Date();			
			bean.setModtime(dt);						//set modtime
			bean.setExtensionname(extension);			//set extension			
			bean.setObjectname("");						//set objectname
			bean.setDescription(""); 					//set description		
			
			//set dataid
			bean.setDataid(rawDataId);					//set dataid
			
			//set objecttype
			DataobjecttypeDAO dotDao = DAOFactory.createDataobjecttypeDAO(dbID);
			Dataobjecttype dotBean = new Dataobjecttype();
			dotBean.setObjecttype(Constants.LOCAL_DICOM_FILE);
			List<Dataobjecttype> listDOT = dotDao.find(con, dotBean);
			BigDecimal dotUniqueId ;
			if(listDOT.size()>0){
				dotUniqueId = listDOT.get(0).getUniqueid();	
			}else{
				log.error("Erro in finding DataObjectType uniqueid");
				return false;
			}
			bean.setObjecttypeid(dotUniqueId);						//set objecttypeid
			
			bean.setObjectsize(BigDecimal.valueOf(fileSize));		//set objectsize
			
			dao.insert(con, bean);
			
			return true;	
		}catch(Exception ex){
			log.error("Error in insertRawData", ex);
			throw new Exception(ex);
		}finally{
			releaseConnection(con, ui);
		}		
	}

	
	
	public List<Site> getAllSites(UserInfo ui) 
			throws Exception{
		Connection con = null;
		try {
			con = dbPoolService.getConnection(ui.getName());
			SiteDAO siteDAO = DAOFactory.createSiteDAO(dbID);
			Site bean = new Site();			
			List<Site> sites = siteDAO.find(con, bean);
			return sites;
		} catch (Exception x) {
			log.error("Error in getLocalStoredExperiment", x);
			throw new Exception(x);
		}finally{
			releaseConnection(con, ui);
		}		
	}

	public List<Collectionequipment> getAllEquips(UserInfo ui) throws Exception {
		Connection con = null;
		try {
			con = dbPoolService.getConnection(ui.getName());
			CollectionequipmentDAO equipDAO = DAOFactory.createCollectionequipmentDAO(dbID);
			Collectionequipment bean = new Collectionequipment();		
			List<Collectionequipment> equips = equipDAO.find(con, bean);
			return equips;
		} catch (Exception x) {
			log.error("Error in getLocalStoredExperiment", x);
			throw new Exception(x);
		}finally{
			releaseConnection(con, ui);
		}
	}

	public String getDicomDir(UserInfo ui) throws Exception {
		String dicomDir = "";
		Connection con = null;
		
		try {			
			con = dbPoolService.getConnection(ui.getName());
			ConfParamsDAO dao = DAOFactory.createConfParamsDAO(dbID);
			ConfParams bean = new ConfParams();
			bean.setName(Constants.DICOM_DIR_FROM_DICOMRECEIVER);
			List<ConfParams> listConfParams = dao.find(con, bean);
			if(listConfParams.size()>0){
				dicomDir = listConfParams.get(0).getValue();	
			}			
			return dicomDir;
		} catch (Exception x) {
			log.error("Error in getLocalStoredExperiment", x);
			throw x;
		}finally{
			releaseConnection(con, ui);
		}
	}

	public boolean saveDicomDir(UserInfo ui, String dir) 
			throws Exception {		
		Connection con = null;
		
		try {			
			con = dbPoolService.getConnection(ui.getName());
			ConfParamsDAO dao = DAOFactory.createConfParamsDAO(dbID);
			ConfParams bean = new ConfParams();
			bean.setName(Constants.DICOM_DIR_FROM_DICOMRECEIVER);			
			List<ConfParams> listConfParams = dao.find(con, bean);
			if(listConfParams.size()>0){
				ConfParams newValue = new ConfParams();
				newValue.setValue(dir);
				dao.update(con, newValue, bean);	
			}else{
				Databaseuser dbUser = DBUtils.getDatabaseUser(dbID, con, ui.getName());
				bean.setValue(dir);
				bean.setType("string");
				bean.setOwner(dbUser.getUniqueid());
				bean.setModTime(new Date());				
				bean.setModUser(dbUser.getUniqueid());
				dao.insert(con, bean);
			}			
			return true;
		} catch (Exception x) {
			log.error("Error in getLocalStoredExperiment", x);
			throw x;
		}finally{
			releaseConnection(con, ui);
		}	
	}
	
}
