package clinical.web.vo;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.server.vo.Expsegment;
import clinical.web.download.ImageSeriesDataInfo;
import clinical.web.helpers.ScoreValuesDisplayHelper;
import clinical.web.helpers.ScoreValuesDisplayLayout;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: StudySegment.java 152 2010-01-26 00:27:26Z bozyurt $
 */

public class StudySegment {
	protected int segmentID;
	protected int studyID = -1;
	protected int visitID;
	protected int experimentID;
	protected String subjectID;
	protected java.sql.Timestamp timeStamp;
	protected String description;
	protected int protocolVersion;
	protected String protocolID;
	protected CollectionEquipment equipment;
	protected String name = "";
	/**
	 * holds a list of <code>clinical.web.vo.AssessmentInfo</code> objects for
	 * the current subject
	 */
	protected List<AssessmentInfo> assessmentInfos = new LinkedList<AssessmentInfo>();
	protected boolean dirty;

	/**
	 * holds a map of assessment name versus
	 * <code>clinical.web.vo.AssessmentScoreValues</code> objects for the
	 * current subject
	 */
	protected Map<String, AssessmentScoreValues> asScoreValuesMap;
	protected int maxScoreNumber = -1;
	protected int currentAsIdx = 0;
	 /** holds info to build and request image data to view */
   protected ImageSeriesDataInfo isdi;
	private Log log = LogFactory.getLog(StudySegment.class);

	public StudySegment() {
	}

	public StudySegment(Expsegment seg) {
		segmentID = seg.getSegmentid().intValue();
		if (seg.getStudyid() != null) {
			studyID = seg.getStudyid().intValue();
		} else {
			/**
			 * @todo CHECK if default causes problem with existing NULL study
			 *       Ids
			 */
			// default study ID
			studyID = 1;
		}
		visitID = seg.getComponentid().intValue();
		experimentID = seg.getNcExperimentUniqueid().intValue();
		subjectID = seg.getSubjectid();
		timeStamp = seg.getTimeStamp();
		description = seg.getDescription();
		protocolVersion = seg.getProtocolversion().intValue();
		protocolID = seg.getProtocolid();
		name = seg.getName();
	}

	public StudySegment(StudySegment other) {
		segmentID = other.getSegmentID();
		studyID = other.getStudyID();
		visitID = other.getVisitID();
		experimentID = other.getExperimentID();
		subjectID = other.getSubjectID();
		timeStamp = other.getTimeStamp();
		description = other.getDescription();
		protocolVersion = other.getProtocolVersion();
		protocolID = other.getProtocolID();
		name = other.getName();
	}

	// ---------------------- setters --------------
	public void setSegmentID(int newSegmentID) {
		this.segmentID = newSegmentID;
		this.dirty = true;
	}

	public void setVisitID(int newComponentid) {
		this.visitID = newComponentid;
		this.dirty = true;
	}

	public void setExperimentID(int newExperimentID) {
		this.experimentID = newExperimentID;
		this.dirty = true;
	}

	public void setSubjectID(String newSubjectID) {
		this.subjectID = newSubjectID;
		this.dirty = true;
	}

	public void setTimeStamp(java.sql.Timestamp newTimeStamp) {
		this.timeStamp = newTimeStamp;
		this.dirty = true;
	}

	public void setDescription(String newDescription) {
		this.description = newDescription;
		this.dirty = true;
		// System.out.println("setDescription studySegment " + toString());
	}

	public void setProtocolVersion(int newProtocolVersion) {
		this.protocolVersion = newProtocolVersion;
		this.dirty = true;
	}

	public void setProtocolID(String newProtocolID) {
		this.protocolID = newProtocolID;
		this.dirty = true;
	}

	public void setEquipment(CollectionEquipment newEquipment) {
		this.equipment = newEquipment;
		this.dirty = true;
	}

	public void setName(String newName) {
		this.name = newName;
		this.dirty = true;
	}

	public void setStudyID(int newStudyID) {
		this.studyID = newStudyID;
		this.dirty = true;
	}

	public void setDirty(boolean newDirty) {
		this.dirty = newDirty;
	}

	// ---------------------- getters --------------
	public int getSegmentID() {
		return this.segmentID;
	}

	public int getVisitID() {
		return this.visitID;
	}

	public int getExperimentID() {
		return this.experimentID;
	}

	public String getSubjectID() {
		return this.subjectID;
	}

	public java.sql.Timestamp getTimeStamp() {
		return this.timeStamp;
	}

	public String getDescription() {
		return this.description;
	}

	public int getProtocolVersion() {
		return this.protocolVersion;
	}

	public String getProtocolID() {
		return this.protocolID;
	}

	public CollectionEquipment getEquipment() {
		return this.equipment;
	}

	public String getName() {
		return name;
	}

	public int getStudyID() {
		return this.studyID;
	}

	public boolean getDirty() {
		return this.dirty;
	}

	public Expsegment toExpSegment() {
		Expsegment segment = new Expsegment();
		segment.setSegmentid(new BigDecimal(String.valueOf(segmentID)));
		segment.setStudyid(new BigDecimal(String.valueOf(studyID)));
		segment.setComponentid(new BigDecimal(String.valueOf(visitID)));
		segment.setNcExperimentUniqueid(new BigDecimal(String
				.valueOf(experimentID)));
		segment.setSubjectid(subjectID);
		segment.setTimeStamp(timeStamp);
		segment.setDescription(description);
		segment.setProtocolversion(new BigDecimal(String
				.valueOf(protocolVersion)));
		segment.setProtocolid(protocolID);
		segment.setName(name);

		return segment;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer(200);
		buf.append("StudySegment::[").append("segmentID=").append(segmentID);
		buf.append(",studyID=").append(studyID);
		buf.append(",visitID=").append(visitID).append(",subjectID=").append(
				subjectID);
		buf.append(",experimentID=").append(experimentID).append(",timestamp=")
				.append(timeStamp);
		if (description != null) {
			buf.append(",description=").append(description);
		}
		if (name != null) {
			buf.append(",name=").append(name);
		}
		buf.append(']');
		return buf.toString();
	}

	// for assessments associated with this segment

	public void resetAssessments() {
		currentAsIdx = 0;
	}

	public void setAsScoreValuesMap(List<AssessmentScoreValues> newAsvList) {
		asScoreValuesMap = new HashMap<String, AssessmentScoreValues>(17);
		for(AssessmentScoreValues asv :  newAsvList) {
			String key = ScoreValuesDisplayHelper.createScoreValueMapKey(asv
					.getAssessmentName(), asv.getSegmentID(), asv.getVisitID());
			asScoreValuesMap.put(key, asv);
		}
	}

	public Map<String, AssessmentScoreValues> getScoreValuesMap() {
		return asScoreValuesMap;
	}

	public int findAndSetAssessmentInfos(List<AssessmentInfo> newAsiList) {
		for(AssessmentInfo asi : newAsiList) {
			if (asi.getVisitID() == visitID && asi.getSegmentID() == segmentID) {
				assessmentInfos.add(asi);
			}
		}
		return assessmentInfos.size();
	}

	public Collection<AssessmentInfo> getAssessmentInfos() {
		return assessmentInfos;
	}

	public ScoreValuesDisplayLayout getScoreValuesDisplayLayout() {
		try {
			if (assessmentInfos.isEmpty()) {
				return new ScoreValuesDisplayLayout();
			}

			AssessmentInfo asi = assessmentInfos
					.get(currentAsIdx);

			String key = ScoreValuesDisplayHelper.createScoreValueMapKey(asi
					.getName(), this.segmentID, this.visitID);
			AssessmentScoreValues asv = asScoreValuesMap
					.get(key);
			ScoreValuesDisplayLayout svdl = new ScoreValuesDisplayLayout();
			ScoreValuesDisplayHelper.prepareScoreValuesLayoutForCA(asi, svdl,
					asv);

			// move to the next assessment
			++currentAsIdx;

			return svdl;
		} catch (Throwable t) {
			log.error("", t);
			if (t instanceof RuntimeException) {
				throw (RuntimeException) t;
			}
			return null;
		}
	}

	public ImageSeriesDataInfo getIsdi() {
		return isdi;
	}

	public void setIsdi(ImageSeriesDataInfo isdi) {
		this.isdi = isdi;
	}

}
