<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>

<script type="text/javascript">

	var sessionNamesList = <c:out value="${geneNewSessionForm.geneObj.geneSessionNamesJSONStr}" escapeXml="false" />;

	function okSession(elem){		
 		var sName = $('sessionNameId');
		
 		if(sName.value==''){
 			alert("The Session name can not be empty!");
 			sName.focus();
			sName.select();
 			return false;
 		}
 		
		for(i=0; i<sessionNamesList.length; i++){
			if(sName.value==sessionNamesList[i]){
				alert("The Session '" + sName.value + "' already exists. Please enter another name!");
				sName.focus();
				sName.select();
				return false;
			}
		}
		
		var form = elem.form;
		form.actionParam.value = 'addSession';		
		form.submit();
		return true;
	}
	
	
	function cancelSession(){
		window.location='<html:rewrite page="/caquery.do?actionParam=Show"/>';	
	}

	function chkAll(elem){
		var form = elem.form;	
		var inputs = form.elements;  
		var cbs = []; //will contain all checkboxes		  
		var chrAll = $('checkAll');
		if(chrAll.checked){
			//check all chromsomes			
			for (var i = 0; i < inputs.length; i++) {  
			  if (inputs[i].type == "checkbox" && inputs[i].id.indexOf("chr")===0) {
				  inputs[i].checked = true;
			  }  
			}  
		}else{
			for (var i = 0; i < inputs.length; i++) {  
				  if (inputs[i].type == "checkbox" && inputs[i].id.indexOf("chr")===0) {
					  inputs[i].checked = false;
				  }  
			}	
		}
	}
	
	function chkChr(elem){
		var form = elem.form;	
		var inputs = form.elements;  
		var cbs = []; //will contain all checkboxes
		var checked = []; //will contain all checked checkboxes  
		var chrAll = $('checkAll');
		var allChecked = true;
		
		if(elem.checked){
			//check all chromsomes			
			for (var i = 0; i < inputs.length; i++) {  
				if (inputs[i].type == "checkbox" && inputs[i].id.indexOf("chr")===0) {
					cbs.push(inputs[i]);  
					if (inputs[i].checked) {  
						checked.push(inputs[i]);  
					}
			  	}  
			}
			if(cbs.length!=checked.length){				
				allChecked = false;
			}
			
			if(allChecked==true){				
				chrAll.checked = true;
			}else{
				chrAll.checked = false;
			}
			
		}else{
			chrAll.checked = false;	
		}
	}
 
</script>

<style>
	#gns {
		float:left;
		padding:0px;
		padding-bottom: 1em;
		margin-left:10px;
		background-color: #d3d3d3;
		width: 70%;
	}
 
	.divMainSectionTitle {
		background-color: #00659c;
		color: #fff;
		font-weight: bold;
		font-size: larger;
		margin: 0px;
		padding: 0px;
		padding-left:5px;
	}

</style>

<div class="error">
  <html:errors/>
</div>

<html:form action="/genenewsession" styleId="gSessionForm" >
<input type="hidden" name="actionParam" value=""/>

 	<div id="gns">	
	<div class="divMainSectionTitle">
    	Upload Genetics Final Report
	</div> 
    <div style="border-left: 2px #00659c solid; border-right: 2px #00659c solid; border-bottom: 2px #00659c solid" > 
    
	<table>		
 		<tr>
			<td align="right"><label class="lbl">Session Name:</label></td>
             <td class="bottomborder">
            	<html:text property="sessionName" styleId="sessionNameId" ></html:text>
            </td>
		</tr>
		<tr>
			<td align="right"><label class="lbl">Session Description:</label></td>
            <td class="bottomborder">
            	<html:text property="sessionDesc"></html:text>                                                
            </td>
        </tr>   
        <bean:define id="chipIdList" name="geneNewSessionForm" property="geneObj.geneChip" type="java.util.Collection"></bean:define>     
 	    <tr>
        	<td align="right"><label class="lbl">Chip ID:</label></td>
            <td class="bottomborder">            	            	
                <html:select name="geneNewSessionForm" property="geneObj.selectedGeneChipId">
             		<html:options collection="chipIdList" property="chipId" labelProperty="chipName"/>
        		</html:select>
            </td>            
        </tr>
     	<tr>
            <td align="right"><label class="lbl">Report:</label></td>
            <td class="bottomborder">            	
				<html:text property="reportFile"></html:text>
			</td>
		</tr>
        <tr>
			<td align="right"><label class="lbl">Annotation:</label></td>
            <td class="bottomborder">			                            
				<html:radio property="annotation" value="illu" disabled="false" >From Illumina</html:radio>
				<html:radio property="annotation" value="ucsc" disabled="false">From UCSC Genome Browser</html:radio>	                                                                                  
			</td>
		</tr>
		<tr>
			<td></td>
			<td>
				<html:text property="annotationFile"></html:text>
			</td>
		</tr>
		<tr>
			<td align="right"><label class="lbl">Chromosome:</label></td>
			<td>
				<table cellpadding="-1" cellspacing="-1" width="100%" >
	                <tr>
	                    <td align="center" width="9px" >All</td>	                    
	                    <td align="center">1</td>
	                    <td align="center">2</td>
	                    <td align="center">3</td>
	                    <td align="center">4</td>
	                    <td align="center">5</td>
	                    <td align="center">6</td>
	                    <td align="center">7</td>
	                    <td align="center">8</td>
	                    <td align="center">9</td>
	                    <td align="center">10</td>
	                    <td align="center">11</td>
	                    <td align="center">12</td>
	                    <td align="center">13</td>
	                    <td align="center">14</td>
	                    <td align="center">15</td>
	                    <td align="center">16</td>
	                    <td align="center">17</td>
	                    <td align="center">18</td>
	                    <td align="center">19</td>
	                    <td align="center">20</td>
	                    <td align="center">21</td>
	                    <td align="center">22</td>
	                    <td align="center">M</td>
	                    <td align="center">X</td>
	                    <td align="center">XY</td>
	                    <td align="center">Y</td>
	                </tr>
	                <tr>
						<td align="center"><html:checkbox styleId="checkAll" property="chromAll" onclick="chkAll(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr01" property="chromArr[0]" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr02" property="chromArr[1]" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr03" property="chromArr[2]" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr04" property="chromArr[3]" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr05" property="chromArr[4]" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr06" property="chromArr[5]" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr07" property="chromArr[6]" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr08" property="chromArr[7]" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr09" property="chromArr[8]" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr10" property="chromArr[9]" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr11" property="chromArr[10]" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr12" property="chromArr[11]" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr13" property="chromArr[12]" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr14" property="chromArr[13]" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr15" property="chromArr[14]" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr16" property="chromArr[15]" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr17" property="chromArr[16]" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr18" property="chromArr[17]" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr19" property="chromArr[18]" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr20" property="chromArr[19]" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr21" property="chromArr[20]" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chr22" property="chromArr[21]" onclick="chkChr(this)"></html:checkbox></td>                
	                    <td align="center"><html:checkbox styleId="chrM" property="chromM" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chrX" property="chromX" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chrXY" property="chromXY" onclick="chkChr(this)"></html:checkbox></td>
	                    <td align="center"><html:checkbox styleId="chrY" property="chromY" onclick="chkChr(this)"></html:checkbox></td>
					</tr>
                </table>
			</td>
		</tr>
        <tr>
			<td align="right"><label class="lbl">Fields:</label></td>
			<td class="bottomborder">
				<html:checkbox property="fieldsCall">Call</html:checkbox>
                <html:checkbox property="fieldsBase">Base</html:checkbox>
                <html:checkbox property="fieldsGCScore">GCScore</html:checkbox>
                <html:checkbox property="fieldsXY">XY</html:checkbox>
                <html:checkbox property="fieldsXYRaw">XY Raw</html:checkbox>                                                
			</td>
		</tr>
		<tr>
			<td></td>
			<td>
				<input type="button" value="OK" class="submit-button" style="width: 50px" onclick="okSession(this)" ></input>
				<input type="button" value="Cancel" class="submit-button" style="width: 50px" onclick="cancelSession()" ></input>								
			</td>	
		</tr>
		<tr>
			<td></td>
			<td></td>
		</tr>
	</table>
	</div>
	</div>
</html:form>

<script>	
     var divElem = $('gns');
     //var options = {color: "#00659c", corners: 'top'};
     //Rico.Corner.round( divElem, {color: "transparent"} );
     Rico.Corner.round( divElem,  {color: "#00659c", corners: 'top bottom'});
</script>