<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic" %>
<%@ taglib uri="/WEB-INF/loci-sec.tld" prefix="sec" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>

<div class="error">
<html:errors/>
</div>
<br>
<br>
<center>
<style>
     .job-normal {
        color: black;
     }
     .job-changed {
        color: red;
        font-weight: bold;
     }
</style>
<script>
   var logger = null;

      function prepareDD() {
        var url = '<html:rewrite page="/jobman.do?action=check4Jobs"/>';
	    var options = { normalCellStyle : 'job-normal', 
	                     updatedCellStyle : 'job-changed' };
        var dt = null;
        if ( logger != null) {
          dt = new clinical.DynamicTable('jobs1', url, options, onSuccessCB, getInitialRowData('jobs1') , logger);
        } else {
          dt = new clinical.DynamicTable('jobs1', url, options, onSuccessCB, getInitialRowData('jobs1') );
        }  
        dt.periodicCheck();
     }

     //08/02/07
     function cancelJob(elem, jobID) {
	    elem.form.jobID.value = jobID;
        elem.form.action.value='Cancel';
     }

     //08/02/07 
     function removeJob(elem, jobID) {
        elem.form.jobID.value = jobID;
        elem.form.action.value='Remove';
     }     
     
     function onSuccessCB(ajaxResponse) {
       var jobs = parseJobs(ajaxResponse);
       var rowData = [];
       for(var i = 0, len = jobs.length; i < len; i++) {
           var job = jobs[i];
           var htmlStr = prepButtonHTML(job.status, job.id, job.partNum); 
           var color = null;
           if (job.error) {
              color = 'red';
           }
           var rd = { rowId : job.id + '_' + job.partNum, partNum : job.partNum, cols : [ {text : job.id}, {text : job.type},
             {text : job.date}, {text: job.desc}, { text : job.status, title : job.error,  color : color },
	        {text: job.size}, {text: job.count},  {html: htmlStr} ] };
	        
	       // alert ("onSuccessCB::  partNum:" + rd.partNum + ", id: " + rd.rowId + "\n" + htmlStr);
	       rowData.push(rd);   
       }
       return rowData;		
     }
     
     // 8/2/07
     function prepButtonHTML(jobStatus, jobID, partNum) {
         var htmlStr = '';
         if ( jobStatus=='running') {            
             htmlStr = '<input type="submit" class="submit-button" value="Cancel" onclick="cancelJob(this,' + "'" 
                  + jobID + "')" + '" >';
         }  else if (jobStatus == 'finished') {
            htmlStr = '<input type="submit" class="submit-button" value="Download" onclick="go(this,' + "'" 
                  + jobID + "','" + partNum + "')" + '" > &nbsp;';
            htmlStr += '<input type="submit" class="submit-button" value="Remove" onclick="removeJob(this,' 
                + "'"   + jobID + "')" + '" >';
         } else if (jobStatus == 'not_started') {
        	 htmlStr = '<input type="submit" class="submit-button" value="Cancel" onclick="cancelJob(this,' + "'" 
             + jobID + "')" + '" >';
         } else if (jobStatus == 'finished_with_err'){
        	 htmlStr = '<input type="submit" class="submit-button" value="Remove" onclick="removeJob(this,' + "'" 
             + jobID + "')" + '" >';
         }
         else if (jobStatus.indexOf('err') == -1) {
             htmlStr = '<input type="submit" class="submit-button" value="Download" onclick="go(this,' + "'" 
                  + jobID + "')" + '" >';
	     }
	     
	     return htmlStr;
     }
          
     function getInitialRowData(tableId) {
         if (logger) { logger.append("getInitialRowData"); }
         var tableElem = xGetElementById(tableId);
         var rows = (tableElem) ? xGetElementsByTagName('tr', tableElem) : null;
         if ( logger) {
           logger.append("getInitialRowData - rows:" + rows.length);
         }
         var rowData = [];
         if ( !rows || rows.length == 0) return rowData;
         for(var i = 1, len = rows.length; i < len; i++) {
             if ( rows[i].id) {
               
               var cols = rows[i].getElementsByTagName("td");
               var jobID = getCellText(cols[0]);
               var partNum = getTableRowAttribute(rows[i], 'partNum');
               var jobType = getCellText(cols[1]);
               var date = getCellText(cols[2]);
               var descr = getCellText(cols[3]);
               var status = getCellText(cols[4]);
               var errMsg = getCellAttribute(cols[4],'title');
               var size = getCellText(cols[5]);
               var dwCount = getCellText(cols[6]);
               var color = null;
               if ( errMsg) {
                  color = 'red';
               }
               
               var htmlStr = prepButtonHTML(status, jobID, partNum);
               //alert ("partNum:" + partNum + ", id: " + rows[i].id + "\n" + htmlStr);
                                   
               var rd = { rowId : rows[i].id + '_' + partNum, partNum : partNum, 
                    cols : [ {text : jobID}, {text: jobType},
                    {text : date}, {text: descr}, { text : status, title: errMsg, color : color }, 
                      { text: size}, 
                       {text : dwCount}, {html: htmlStr } ] };
	           if (logger) {     
	             var str = "jobID:" + jobID + " user:" + user + " date:" + date + " status:" + status;     
	             logger.append("rd:" + str);     
	           }
	           rowData.push(rd);
             }
         }
         return rowData;
     }
     
     function getCellAttribute(cell, attrName) {
        var spans =  xGetElementsByTagName("span", cell);
        var value = null;
        if ( spans && spans.length > 0) {
          for(var j = 0; j < spans[0].attributes.length; ++j) {
             var nodeName = entry.attributes[j].nodeName.toLowerCase();
             if ( nodeName == attrName) {
                return entry.attributes[j].nodeValue;
             }
          }   
        }
        return null;
     }
     
     function getTableRowAttribute(trEl, attrName) {
        for(var j = 0; j < trEl.attributes.length; ++j) {
           var nodeName = entry.attributes[j].nodeName.toLowerCase();
           if ( nodeName == attrName) {
              return entry.attributes[j].nodeValue;
           }
          }   
        return null;
     }
     
     function getCellText(cell) {
        var spans =  xGetElementsByTagName("span", cell);
        var value = null;
        if ( spans && spans.length > 0) {
            if ( spans[0].firstChild) {
               value = spans[0].firstChild.nodeValue;
            } else {
               if (spans[0].nodeValue) {
                   value = spans[0].nodeValue;
               } 
            }   
        } else {
           value = cell.firstChild.nodeValue;
        }        
        if ( value) {
           return utils.trim(value);
        }
        return '';
     }

     function parseJobs(ajaxResponse) {
       var jobs = [];
       if ( !ajaxResponse) return jobs;
       var entries = ajaxResponse.getElementsByTagName('jr');
       if (entries) {
           for(var i = 0; i < entries.length; ++i) {
	         var entry = entries[i];
	         var id = "";
	         var status = "";
	         var user = "";
	         var jrDate = "";
	         var jrDesc = "";
	         var jrType = "";
	         var jrSize = "N/A";
             var jrDownloadCount = "N/A"
             var jrErrMsg = null;
             var jrPartNum = 0;
	         for(var j = 0; j < entry.attributes.length; ++j) {
	             var nodeName = entry.attributes[j].nodeName.toLowerCase();
	             var nodeValue = entry.attributes[j].nodeValue;
	             if ( nodeName == 'id') {
	                 id = nodeValue;
	             } else if ( nodeName == 'status') {
	                 status = nodeValue;
	             } else if ( nodeName == 'user') {
	                 user = nodeValue;
	             } else if ( nodeName == 'date') {
                         jrDate = nodeValue;
	             } else if ( nodeName == 'type') {
	                 jrType = nodeValue;
	             } else if ( nodeName == 'size') {
                    jrSize = nodeValue;
		         } else if ( nodeName == 'count') {
		    	    jrDownloadCount = nodeValue;
		         } else if ( nodeName == 'partnum') {
		           jrPartNum = nodeValue;
		         }                                      
	         } //j
	         jrDesc = getNodeText(entry,'desc');     
	         jrErrMsg = getNodeText(entry, 'error'); 
	         
	         jobs.push( { id: id, status : status, user : user, date : jrDate, desc: jrDesc, type: jrType, 
	             size: jrSize, count: jrDownloadCount, error : jrErrMsg, partNum : jrPartNum  } );
           } //i
      } // if
      return jobs;
    }
    
    function getNodeText(entry, tagName) {
       var children = entry.childNodes;
       if ( children && children.length > 0) {
          for(var i = 0; i < children.length; i++) {
              if ( children[i] && children[i].nodeName == tagName) {
                   if ( children[i].lastChild && children[i].lastChild.nodeValue) {
	             return children[i].lastChild.nodeValue;
	           } 
              }
          }
       }
       return null;
    } 
    
    function go(elem, jobID, fileID) {
       elem.form.jobID.value = jobID;
       elem.form.fileID.value = fileID;
    }
    
   
    function prepLogger() {
        logger = new Console("console");
        logger.append("initialized logger");
    }
    
    // window.addOnLoadListener(prepLogger);
    window.addOnLoadListener(prepareDD);  
    
  </script>
  
<html:form action="/jobman">
<input type="hidden" name="action" value="download">
<input type="hidden" name="jobID" value="">
<input type="hidden" name="fileID" value="">

<span id="jobs_man_header">Scheduled Jobs for '<c:out value="${jmForm.user}"/>'</span>  
<table class="jobtable" border="0" width="80%"  id="jobs1">
<tr bgcolor="#00659c">
   <td class="jt_header">JobID</th>
   <td class="jt_header">Type</th>
   <td class="jt_header">Date</th>
   <td class="jt_header">Description</th>
   <td class="jt_header">Status</th>
   <td class="jt_header">Size</th>
   <td class="jt_header"># Downloads</th> 
   <td class="jt_header">&nbsp;</th>
</tr>

<c:forEach var="jr" items="${bgForm.jrList}">
  <c:forEach var="dfile" items="${jr.savedResultsFiles}" varStatus="vs">
  <tr id="<c:out value="${jr.jobID}"/>"  partNum="<c:out value="${vs.index}"/>">
     <td><div><c:out value="${jr.jobID}"/></div></td>
     <td><div><c:out value="${jr.type}" /></div></td>
     <td><div><c:out value="${jr.date}" /></div></td>
     <td><div><c:out value="${jr.description}" /></div></td>  
     <c:if test="${not empty jr.errorMsg}">   
       <td><div title='<c:out value="${jr.errorMsg}"/>'><span style="color:red"><c:out value="${jr.status}" /></span></div></td>
     </c:if>
     <c:if test="${empty jr.errorMsg}">   
       <td><div><c:out value="${jr.status}" /></div></td>
     </c:if>
     <td><div><c:out value="${jr.formattedJobSize}" /></div></td>
     <td><div><c:out value="${jr.downloadCount}" /></div></td>
     
     <td>
     <div>
       <c:choose>
       <c:when test="${jr.status == 'finished'}">  
         <input type="submit" class="submit-button" value="Download" onclick="go(this,'<c:out value="${jr.jobID}"/>','<c:out value="${vs.index}"/>')" ></input> 
         &nbsp;
         <input type="submit" class="submit-button" value="Remove" onclick="removeJob(this,'<bean:write name="jr" property="jobID"/>')" ></input> 
        
       </c:when>
       <c:when test="${jr.status == 'running'}">
            <input type="submit" class="submit-button" value="Cancel" onclick="cancelJob(this,'<c:out value="${jr.jobID}"/>')" ></input>
       </c:when>
       <c:otherwise>
           <input type="submit" class="submit-button" value="Remove" onclick="removeJob(this,'<bean:write name="jr" property="jobID"/>')" ></input>
       </c:otherwise>  
       </c:choose>
      </div>
     </td>
  </tr>
   </c:forEach>
</c:forEach>
</table>
<div id="console"></div>
</html:form>
</center>
