// common JavaScript functions

 
 function helpHandler(spanId) {
      if (!spanId) {
        return false;
      }
      var mainSpan = document.getElementById(spanId);
      if ( mainSpan) {
        var msgId = spanId.substring( spanId.lastIndexOf('_') + 1);
        var content = helpSystem.findHelpMessage( msgId );
        // alert("msgId=" + msgId + " content=" + content);
        if ( content ) {
           bal.InfoViewer.showPopup(mainSpan, content);
        } 
      }
      return false;
   }
 
 /* ----- ajax components  (IBO) -------------------*/
  
 var clinical = new Object();
  
 clinical.BatchJobStatsComp = function(containerId, url, manageURL, options) {
     var parent = document.getElementById(containerId);
     this.url = url;
     this.manageURL = manageURL;
     this.options = options;
     this.prevNumOfFinishedJobs = -1;
     // create the UI of the component and add to the parent
     this.ui = document.createElement("div");
     this.actionLink = document.createElement("div");
     this.actionLink.innerHTML = '&nbsp;<a class="smenulink" href="' + this.manageURL + 
                  '">Manage Jobs</a><br><br>';
     //this.actionLink.style.border = "solid green 1px";
     this.ui.id = "bjs_main_" + containerId;
     this.ui.className = "bjsMain";
     //this.txtNode = document.createTextNode("No Batch Jobs");
     this.txtNode = document.createTextNode("No Downloads Ready");
     this.ui.appendChild(this.actionLink);
//     this.emptyNode = document.creatElement("div");
//     this.emptyNode.innerHTML = '<br>&nbsp;'
//     this.ui.appendChild(this.emptyNode);
     parent.appendChild(this.ui);
     this.ui.appendChild(this.txtNode);
     
     
     
     this.ajaxHelper = new net.ContentLoader(this, url, "POST", 
                   options.requestParameters || [] );  
  }
  
  clinical.BatchJobStatsComp.prototype.ajaxUpdate=function(request) {
         if(!request || !request.responseXML) return;  
         var jobs = this.handleResponse( request.responseXML.documentElement );
         if (jobs && jobs.length > 0) {
           
            var finishedJobs = 0;
            var chrashedJobs = 0;
            var newJobs = 0;
            for(var i = 0; i < jobs.length; i++) {
                var jr = jobs[i];
                if ( jr.status == 'finished' ) {
                   finishedJobs++;
                   if ( jr.newlyAdded == 'true') {
                      newJobs++;
                   }
                } else if (jr.status == 'finished_with_err' ) {
                   chrashedJobs++;
                }                 
            }
            // update ui
            this.updateUI(finishedJobs, chrashedJobs, newJobs, jobs);
         }
     };
     
     clinical.BatchJobStatsComp.prototype.periodicCheck=function() {
         this.ajaxHelper.sendRequest();
         var thisObj = this;
         var checker = function() {                        
              thisObj.periodicCheck();
         }
         
         var checkInterval = (this.options && this.options.checkInterval) ? 
                        this.options.checkInterval : 5000;
         setTimeout(checker, checkInterval);  
     };
     
  clinical.BatchJobStatsComp.prototype.handleError = function(request) {
      if ( this.options.errorHandler ) {
         this.options.errorHandler(request);
      }
   };
     
  clinical.BatchJobStatsComp.prototype.updateUI=function(finishedJobs, chrashedJobs, newJobs, jobs) {
      var str = "";
      var newlyAdded = new Array();
      if ( finishedJobs > 0) {              
        str = finishedJobs + " new results"; 
          this.txtNode.nodeValue = str;             
          this.ui.className = "bjsMainNew";              
      }
          
      if ( newJobs > 0) {	
         new Effect.Pulsate(this.ui); 
         if ( this.options && this.options.cbURL && jobs) {
                
            var param = "jobIDs=";
            var len = jobs.length;
            for(var i = 0; i < len; ++i) {
               param += jobs[i].id;
               if ( (i + 1) < len) param += ",";
            }
            var cbAjaxHelper = new net.ContentLoader(this, options.cbURL, "POST",[param]);
            cbAjaxHelper.sendRequest();
	 }                                        
      }          
   };
    
     
   clinical.BatchJobStatsComp.prototype.handleResponse = function(ajaxResponse) {
      var jobs = [];
      if (!ajaxResponse) return;
      var entries = ajaxResponse.getElementsByTagName('jr');
        
      if (entries && entries.length > 0) {
         for(var i = 0; i < entries.length; ++i) {
           var entry = entries[i];
	   var id = "";
           var status = "";
           var user = "";
	   var jrDate = "";
	   var jrDesc = "";
	   var newlyAdded = "false";
	   var jrSize = "N/A";
	   var jrDownloadCount = "N/A"
	   var jrErrMsg = null;
                
	   if ( entry.attributes) { 
	      for(var j = 0; j < entry.attributes.length; ++j) {
                 var nodeName = entry.attributes[j].nodeName.toLowerCase();
		 var nodeValue = entry.attributes[j].nodeValue;
		 if ( nodeName == 'id') {
                    id = nodeValue;
		 } else if ( nodeName == 'status') {
		    status = nodeValue;
		 } else if ( nodeName == 'user') {
                    user = nodeValue;
		 } else if ( nodeName == 'date') {
                    jrDate = nodeValue;
		 } else if ( nodeName == 'new') {
                    newlyAdded = nodeValue;
		 } else if ( nodeName == 'size') {
                    jrSize = nodeValue;
		 } else if ( nodeName == 'count') {
		    jrDownloadCount = nodeValue;
		 }                                    
	      }
	   }
	   var descElems = entry.getElementsByTagName("desc");
	   if ( descElems && descElems.length > 0) {
               jrDesc = descElems[0].value;
	   }
	   var errElems = entry.getElementsByTagName("error");
	   if ( errElems && errElems.length > 0) {
              jrErrMsg = errElems[0].value;
	   } 
              
	   jobs.push( { id: id, status : status, user : user, date : jrDate, 
	    desc: jrDesc, newlyAdded : newlyAdded, size: jrSize, 
	    count: jrDownloadCount, error : jrErrMsg } );
	 }
      }        
      return jobs;
   };
 
  
 /* ----------------------------- Ajax Dynamic Table ----------------------- */ 
clinical.DynamicTable = function(tableId, url, options, onSuccessCB, initRowData, aLogger) {
   this.tableId = tableId;
   this.url = url;
   
   if ( !options || options.length == 0 ) {
      this.options = { normalCellStyle : 'normal', updatedCellStyle : 'hilite',
         twoShadeColor : '#E0E0E0' };
   } else {
      this.options = options;
      if ( !this.options.normalCellStyle) this.options.normalCellStyle='normal';
      if ( !this.options.updatedCellStyle) this.options.updatedCellStyle='hilite';
      if ( !this.options.twoShadeColor) this.options.twoShadeColor='#E0E0E0';
   }
   
   this.logger = (aLogger) ? aLogger : null;
   if ( this.logger) {
       this.logger.append("DynamicTable - constructor");
   } 
   this.table = document.getElementById(tableId);
   var rows = this.table.getElementsByTagName('tr');
   
   this.numRows = (rows) ? rows.length : 0;
   var cols = (rows) ? rows[0].getElementsByTagName('td') : 0;
   this.numCols = (cols) ? cols.length : 0;
   this.rowDataCache = [];
   if ( initRowData) {
      this.rowDataCache = initRowData; 
   }
   this.onSuccessCB = onSuccessCB;
   this.applyTwoColor();
   if ( url) {
      this.ajaxHelper = new net.ContentLoader(this, url, "POST", 
					      this.options.requestParameters || [] );
   }
}

clinical.DynamicTable.prototype.applyTwoColor=function() {
   if ( this.logger) {
       this.logger.append("DynamicTable.applyTwoColor");
   } 
   var rows = document.getElementById(this.tableId).getElementsByTagName('tr');
   if ( !rows || rows.length == 0) return;
   // alert("rows:" + rows.length);
   if ( this.logger) {
       this.logger.append("DynamicTable.applyTwoColor - rows:" + rows.length);
   } 
   var bgColor = rows[0].style.backgroundColor;
   // assuming the first row as the header row
   for(var i = 1, len = rows.length; i < len; i++) {
      if ( ( (i - 1) % 2) == 1 ) {
	      rows[i].style.backgroundColor = this.options.twoShadeColor;
      } else {
          rows[i].style.backgroundColor = 'white';
         if ( this.logger) {       
            this.logger.append("DynamicTable.applyTwoColor - rows[" + i + "]: white");
         }
      }
   }
}

clinical.DynamicTable.prototype.getNumRows=function() {
   return this.numRows;
}

clinical.DynamicTable.prototype.getNumCols=function() {
   return this.numCols;
}

clinical.DynamicTable.prototype.updateColumnsById=function(rowId, colData) {
   if (!colData || !rowId) return;
   var theRow = document.getElementById(rowId);
 
   if (!theRow) {
     return;
   }
   for(var i = 0; i < colData.length; ++i) {
	var colIdx = colData[i].colIdx;
	var tableCol = theRow.cells[colIdx];
	if ( colData[i].textContent ) {
	   var e = tableCol.getElementsByTagName('span')[0];
	   tableCol.getElementsByTagName('div')[0].innerHTML = colData[i].textContent;
	   if ( colData[i].title) {
	      tableCol.getElementsByTagName('div')[0].setAttribute("title", colData[i].title);
	   }  
	}
	if ( colData[i].newStyleClass ) {
	   utils.xAddClass( tableCol.getElementsByTagName('div')[0],  colData[i].newStyleClass);
	}
   }
}

clinical.DynamicTable.prototype.addRow=function(rowData) {
   var tblElem = document.getElementById(this.tableId);
   var rows = tblElem.rows;
   var trElem = null;
   if ( tblElem.insertRow) {
     trElem = tblElem.insertRow(rows.length);
   } else {
     trElem = document.createElement("tr");
   }
   trElem.id = rowData.rowId;
   trElem.partNum = rowData.partNum;
   
   var noCols = rowData.cols.length;
   for(var i = 0; i < noCols; i++) {
       var tdElem = document.createElement("td");
       trElem.appendChild(tdElem);
       var divElem = document.createElement("div");
       if ( rowData.cols[i].styleClass) {
	     utils.xAddClass(divElem, rowData.cols[i].styleClass);
       } else {
	     utils.xAddClass(divElem, this.options.normalCellStyle );
       }
	   tdElem.appendChild(divElem);
	   var tn = null;
	   if (rowData.cols[i].text) {
	     tn = document.createTextNode( rowData.cols[i].text);
	     if ( rowData.cols[i].color) {
	        var spanEl = document.createElement("span");
	        spanEl.style.color = rowData.cols[i].color;
	        spanEl.appendChild(tn);
	        divElem.appendChild(spanEl);
	     } else {
	       divElem.appendChild(tn);
	     }
	   } else {
	      if ( rowData.cols[i].html) {
	        divElem.innerHTML = rowData.cols[i].html;
	      } else {
	        tn = document.createTextNode("");
	        divElem.appendChild(tn);
	      }
	   }
	   if ( rowData.cols[i].title) {
	      divElem.setAttribute("title", rowData.cols[i].title); 
	   }
   } //i
   if ( !tblElem.insertRow) {
     tblElem.appendChild(trElem);
   }
   this.applyTwoColor();
}


// ajax methods

clinical.DynamicTable.prototype.periodicCheck=function() {
   this.ajaxHelper.sendRequest();
   var thisObj = this;
   var checker = function() {
      thisObj.periodicCheck();
   };
   setTimeout(checker, 15000);
}

clinical.DynamicTable.prototype.ajaxUpdate=function(request) {
   rowData = this.onSuccessCB( request.responseXML.documentElement );
   var newRows = [];
   var updatedRows = [];
   if ( rowData ) {
      if ( this.rowDataCache && this.rowDataCache.length > 0) {
	 var rowIdMap =  new utils.Hash();
	 for(var i = 0, len = this.rowDataCache.length; i < len; ++i) {
	    var cr = this.rowDataCache[i];
	    rowIdMap.setItem(cr.rowId , i);
	 } 
	 for(var i = 0, len = rowData.length; i < len; ++i) {
	    var row = rowData[i];           
	    if ( rowIdMap.hasItem(row.rowId) ) {
	       var crIdx = rowIdMap.getItem( row.rowId);
	       var cr = this.rowDataCache[crIdx];
	       // check for any changes
	       var cols = row.cols;
	       var cachedCols = cr.cols;
	       var rowUpdated = false;
	       var updatedRow = { rowId: cr.rowId, cols : [] };
	       for(var j = 0; j < cols.length; ++j) {
		   if (cols[j].text && cachedCols[j].text &&  cols[j].text != cachedCols[j].text) 
		   {
		      // alert("changed col: " + cols[j].text + " rowId:" + updatedRow.rowId);
		      var titleStr = null;
		      if (cols[j].title) titleStr = cols[j].title;
		      var col = { colIdx : j, textContent : cols[j].text, title: titleStr};
		      if ( cols[j].styleClass ) {
			 col.newStyleClass = cols[j].styleClass;
		      } else {
			 col.newStyleClass = this.options.updatedCellStyle;
		      }
		      if ( cols[j].color) {
			 col.textContent = '<span style="color :' 
			   + cols[j].color + ';">' + col.textContent + '</span>';			   
		      }
			   
		      // alert("updated col=" + col.colIdx + " ,text:" + col.textContent);		      
		      updatedRow.cols.push(col);
		      rowUpdated = true; 
		   } // if 
		   // 8/3/07
		   if ( cols[j].html && cachedCols[j].html && cols[j].html != cachedCols[j].html) {                
		      var titleStr = null;
		      if (cols[j].title) titleStr = cols[j].title;			 
		      var col = { colIdx : j, textContent : cols[j].html, title: titleStr};
		      if ( cols[j].styleClass ) {
			 col.newStyleClass = cols[j].styleClass;
		      } else {
			 col.newStyleClass = this.options.updatedCellStyle;
		      }
		      if ( cols[j].color) {
			  col.textContent = '<span style="color :' + cols[j].color + ';">' 
			    + col.textContent + '</span>';			   
		      } 
		      updatedRow.cols.push(col);
		      rowUpdated = true;  
		   }// if	             
	       } //j
	       if ( rowUpdated) {
		  updatedRows.push( updatedRow );
		  this.rowDataCache[crIdx] = row;
	       }
	    } else {
	       newRows.push(row );
	       this.rowDataCache.push(row);
	    }
	 } //i
      } else {
         for(var i = 0, len = rowData.length; i < len; ++i) {
	     newRows.push(rowData[i]);
	     this.rowDataCache.push(rowData[i]);
	 }
      } 
      if ( updatedRows) {
	  for(var i = 0, len = updatedRows.length; i < len; ++i) {
	     var ur = updatedRows[i];
	     this.updateColumnsById(ur.rowId, ur.cols);
	  }
      }
      if ( newRows) {
	 for(var i = 0, len = newRows.length; i < len; ++i) 
            this.addRow(newRows[i]);	   
      }
   }
}

var qb = new Object();

qb.removeQueryPart = function(divId) {
     var div = $(divId);
	  if (div) {
       var parent = $(div.parentNode);
       if ( parent ) {
			 var els = parent.getElementsByTagName('div');
          if (!els || els.length <= 2) {
				 var count = 0 
				 for(var i = 0; i < els.length; i++) {
					 if (els[i].id && els[i].id.indexOf("__") == -1) 
						 count++;
				 }
				 if ( count <= 1) {
					 var nsList = parent.nextSiblings();
					 if (nsList && nsList.length == 1) {
						 if (nsList[0].tagName.toLowerCase() == 'div') {
							 els = nsList[0].getElementsByTagName('div');
							 var conCount = 0;
							 for(var i = 0; i < els.length; i++) 
							 if (els[i].id &&  utils.strEndsWith(els[i].id,"__connector") ) {
								 orphan = els[i];
								 conCount++;
							 }
							 if (conCount == 1)
								 Element.remove(orphan);
						 }
					 }
					 Element.remove(parent); 
					 return false; 
				}   			     
			 }
			 qb.handleOrphanConnector(divId, els);	        
		 } 
       Element.remove(divId);
     }
     return false;
  }
  
  qb.handleOrphanConnector = function(divId, els) {
     if (!els) return;
     // check for an orphan connector div and remove if so
     var hasOrphan = true;
     var divConnecterId = divId.replace(/__qp$/,'__connector');
     for(var i = 0; i < els.length; i++) {
		  if (els[i].id == divConnecterId) {
			  hasOrphan = false;	
			  break;
		  }
	  }
     if (hasOrphan) {
		  var orphan = null;
		  for(var i = 0; i < els.length; i++) {
			  if (els[i].id &&  utils.strEndsWith(els[i].id,"__connector") ) {
				  orphan = els[i];
				  break;
			  }
		  }
		  if (orphan)
			  Element.remove(orphan.id);
	  }// hasOrphan
  }
  

//Jinran added common fun
  	function setCookie(c_name,value,exdays)
	{
		var exdate=new Date();
		exdate.setDate(exdate.getDate() + exdays);
		var c_value=escape(value) + ((exdays==null) ? "" : "; expires="+exdate.toUTCString());
		document.cookie=c_name + "=" + c_value;
	}
	
	function getCookie(c_name)
	{
		var i,x,y,ARRcookies=document.cookie.split(";");
		for (i=0;i<ARRcookies.length;i++)
		  {
		  x=ARRcookies[i].substr(0,ARRcookies[i].indexOf("="));
		  y=ARRcookies[i].substr(ARRcookies[i].indexOf("=")+1);
		  x=x.replace(/^\s+|\s+$/g,"");
		  if (x==c_name)
		    {
		    return unescape(y);
		    }
		  }
	}
	
	function deleteCookie(c_name) 
	{		
		document.cookie = c_name +
		'=; expires=Thu, 01-Jan-70 00:00:01 GMT;';
	} 
	
	// Check if array a contains object obj, return true if does, false otherwise
	function contains(a, obj) {
	    var i = a.length;
	    while (i--) {
	       if (a[i] === obj) {
	           return true;
	       }
	    }
	    return false;
	}


	//The following function is to simulate a mouse click on a target element
	function simulate(element, eventName)
    {
        var options = extend(defaultOptions, arguments[2] || {});
        var oEvent, eventType = null;

        for (var name in eventMatchers)
        {
            if (eventMatchers[name].test(eventName)) { eventType = name; break; }
        }

        if (!eventType)
            throw new SyntaxError('Only HTMLEvents and MouseEvents interfaces are supported');

        if (document.createEvent)
        {
            oEvent = document.createEvent(eventType);
            if (eventType == 'HTMLEvents')
            {
                oEvent.initEvent(eventName, options.bubbles, options.cancelable);
            }
            else
            {
                oEvent.initMouseEvent(eventName, options.bubbles, options.cancelable, document.defaultView,
          options.button, options.pointerX, options.pointerY, options.pointerX, options.pointerY,
          options.ctrlKey, options.altKey, options.shiftKey, options.metaKey, options.button, element);
            }
            element.dispatchEvent(oEvent);
        }
        else
        {
            options.clientX = options.pointerX;
            options.clientY = options.pointerY;
            var evt = document.createEventObject();
            oEvent = extend(evt, options);
            element.fireEvent('on' + eventName, oEvent);
        }
        return element;
    }

    function extend(destination, source) {
        for (var property in source)
          destination[property] = source[property];
        return destination;
    }

	var eventMatchers = {
	    'HTMLEvents': /^(?:load|unload|abort|error|select|change|submit|reset|focus|blur|resize|scroll)$/,
	    'MouseEvents': /^(?:click|dblclick|mouse(?:down|up|over|move|out))$/
	}
	var defaultOptions = {
	    pointerX: 0,
	    pointerY: 0,
	    button: 0,
	    ctrlKey: false,
	    altKey: false,
	    shiftKey: false,
	    metaKey: false,
	    bubbles: true,
	    cancelable: true
	}

	//The following function is to simulate a mouse click on a target element. Previous function does not work in IE.
	function fakeClick(event, anchorObj) {
		if (anchorObj.click) {
			anchorObj.click()
		} else if(document.createEvent) {
			if(event.target !== anchorObj) {
				var evt = document.createEvent("MouseEvents"); 
				evt.initMouseEvent("click", true, true, window, 
		          0, 0, 0, 0, 0, false, false, false, false, 0, null); 
				var allowDefault = anchorObj.dispatchEvent(evt);
				// you can check allowDefault for false to see if
				// any handler called evt.preventDefault().
				// Firefox will *not* redirect to anchorObj.href
				// for you. However every other browser will.
			}
		}
	}
	
	//Some version of IE does not support getElementsByClassName,
	//Implement my own version here
	function getElementsByClassName(classname, tag, node) {
		if (node.getElementsByClassName)
			return node.getElementsByClassName(classname);
		else {
			// your custom function
			var classElements = new Array();
			if ( node == null )
			    node = document;
			if ( tag == null )
				tag = '*';
			var els = node.getElementsByTagName(tag);
			var elsLen = els.length;
			var pattern = new RegExp("(^|\\s)"+classname+"(\\s|$)");
			for (i = 0, j = 0; i < elsLen; i++) {
				if ( pattern.test(els[i].className) ) {
					classElements[j] = els[i];
				    j++;
				}
			}
			return classElements;
		}
	}
	
	/*
	Developed by Robert Nyman, http://www.robertnyman.com
	Code/licensing: http://code.google.com/p/getelementsbyclassname/
	 */	
/*var getElementsByClassName = function (className, tag, elm){
	if (document.getElementsByClassName) {
		getElementsByClassName = function (className, tag, elm) {
			elm = elm || document;
			var elements = elm.getElementsByClassName(className), nodeName = (tag)? new RegExp("\\b" + tag + "\\b", "i") : null, returnElements = [], current;
			for(var i=0, il=elements.length; i<il; i+=1){
				current = elements[i];
				if(!nodeName || nodeName.test(current.nodeName)) {
					returnElements.push(current);
				}
			}
			return returnElements;
		};
	}
	else if (document.evaluate) {
		getElementsByClassName = function (className, tag, elm) {
			tag = tag || "*";
			elm = elm || document;
			var classes = className.split(" "),
				classesToCheck = "",
				xhtmlNamespace = "http://www.w3.org/1999/xhtml",
				namespaceResolver = (document.documentElement.namespaceURI === xhtmlNamespace)? xhtmlNamespace : null,
				returnElements = [],
				elements,
				node;
			for(var j=0, jl=classes.length; j<jl; j+=1){
				classesToCheck += "[contains(concat(' ', @class, ' '), ' " + classes[j] + " ')]";
			}
			try	{
				elements = document.evaluate(".//" + tag + classesToCheck, elm, namespaceResolver, 0, null);
			}
			catch (e) {
				elements = document.evaluate(".//" + tag + classesToCheck, elm, null, 0, null);
			}
			while ((node = elements.iterateNext())) {
				returnElements.push(node);
			}
			return returnElements;
		};
	}
	else {
		getElementsByClassName = function (className, tag, elm) {
			tag = tag || "*";
			elm = elm || document;
			var classes = className.split(" "),
				classesToCheck = [],
				elements = (tag === "*" && elm.all)? elm.all : elm.getElementsByTagName(tag),current,returnElements = [],match;
			for(var k=0, kl=classes.length; k<kl; k+=1){
				classesToCheck.push(new RegExp("(^|\\s)" + classes[k] + "(\\s|$)"));
			}
			for(var l=0, ll=elements.length; l<ll; l+=1){
				current = elements[l];
				match = false;
				for(var m=0, ml=classesToCheck.length; m<ml; m+=1){
					match = classesToCheck[m].test(current.className);
					if (!match) {
						break;
					}
				}
				if (match) {
					returnElements.push(current);
				}
			}
			return returnElements;
		};
	}
	return getElementsByClassName(className, tag, elm);
};
*/