package clinical.server;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.server.vo.Collectionequipment;
import clinical.server.vo.Expcomponent;
import clinical.server.vo.Expsegment;
import clinical.server.vo.Expstudy;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: VisitInfo.java 844 2014-02-27 18:51:10Z jinranc $
 */
public class VisitInfo {
	protected Expcomponent visit;
	protected List<Expsegment> segments = new LinkedList<Expsegment>();
	protected Collectionequipment equipment;
	protected Map<String, Collectionequipment> equipmentMap = new HashMap<String, Collectionequipment>(
			3);
	
	private List<Expstudy> studies;

	public VisitInfo(Expcomponent visit) {
		this.visit = visit;
	}

	public Expcomponent getVisit() {
		return this.visit;
	}

	public void addSegment(Expsegment segment) {
		if (!segments.contains(segment))
			segments.add(segment);
	}

	public boolean hasSegments() {
		return !segments.isEmpty();
	}

	public List<Expsegment> getSegments() {
		return segments;
	}

	public void setEquipment(Expsegment segment,
			Collectionequipment newEquipment) {
		System.out.println("registering equipment for segment "
				+ segment.getSegmentid().toString());
		equipmentMap.put(segment.getSegmentid().toString(), newEquipment);
	}

	public void setEquipment(int segmentID, Collectionequipment newEquipment) {
		equipmentMap.put(String.valueOf(segmentID), newEquipment);
	}

	public Collectionequipment getEquipment(Expsegment segment) {
		return equipmentMap.get(segment.getSegmentid().toString());
	}

	public Collectionequipment getEquipment(int segmentID) {
		return equipmentMap.get(String.valueOf(segmentID));
	}
	
	public JSONObject toJSON(JSONObject js){
		try {
			js.put("visitnumber", visit.getComponentid());
			js.put("visittype", visit.getVisittype());
			js.put("visitname", visit.getName());
			JSONArray jsarr = new JSONArray();
			for(Expstudy study : studies){
				jsarr.put(study.toJSON(new JSONObject()));
			}
			js.put("studies", jsarr);
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return js;
	}

	public void setStudies(List<Expstudy> studies) {
		this.studies = studies;
	}

	public List<Expstudy> getStudies() {
		return studies;
	}
}
