package clinical.server.dao.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.utils.OracleUtils;
import clinical.server.vo.Machine;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class MachineDAO implements clinical.server.dao.MachineDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public MachineDAO() {
	}

	public void insert(Connection con, Machine bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_MACHINE ");
			buf
					.append(" (UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER,ARCHITECTURE,OS,OSVERSION,DESCRIPTION,ADDRESS) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 10; ++i) {
				buf.append('?');
				if (i < 9)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getUniqueid(),
					Types.NUMERIC);
			ps.setObject(2, (java.math.BigDecimal) bean.getTableid(),
					Types.NUMERIC);
			ps.setObject(3, (java.math.BigDecimal) bean.getOwner(),
					Types.NUMERIC);
			ps.setTimestamp(4, bean.getModtime() == null ? null
					: new java.sql.Timestamp(bean.getModtime().getTime()));
			ps.setObject(5, (java.math.BigDecimal) bean.getModuser(),
					Types.NUMERIC);
			ps.setObject(6, (String) bean.getArchitecture(), Types.VARCHAR);
			ps.setObject(7, (String) bean.getOs(), Types.VARCHAR);
			ps.setObject(8, (String) bean.getOsversion(), Types.VARCHAR);
			ps.setObject(9, OracleUtils.getCLOB(con, bean.getDescription()),
					Types.CLOB);
			ps.setObject(10, (String) bean.getAddress(), Types.VARCHAR);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Machine bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("UNIQUEID");
		buf.append(',');
		buf.append("TABLEID");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("ARCHITECTURE");
		buf.append(',');
		buf.append("OS");
		buf.append(',');
		buf.append("OSVERSION");
		buf.append(',');
		buf.append("DESCRIPTION");
		buf.append(',');
		buf.append("ADDRESS");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Machine bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUEID=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getArchitecture() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ARCHITECTURE=?");
			qi.values.add(bean.getArchitecture());
			valueSet = true;
		}
		if (bean.getOs() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OS=?");
			qi.values.add(bean.getOs());
			valueSet = true;
		}
		if (bean.getOsversion() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OSVERSION=?");
			qi.values.add(bean.getOsversion());
			valueSet = true;
		}
		if (bean.getDescription() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DESCRIPTION=?");
			qi.values.add(bean.getDescription());
			valueSet = true;
		}
		if (bean.getAddress() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ADDRESS=?");
			qi.values.add(bean.getAddress());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Machine bean, Machine criteria)
			throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_MACHINE SET ");

		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getArchitecture() != null || bean.isNull("architecture")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ARCHITECTURE=? ");
			uqi.setValues.add(bean.getArchitecture());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("architecture"), uqi);
			valueSet = true;
		}
		if (bean.getOs() != null || bean.isNull("os")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OS=? ");
			uqi.setValues.add(bean.getOs());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("os"), uqi);
			valueSet = true;
		}
		if (bean.getOsversion() != null || bean.isNull("osversion")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OSVERSION=? ");
			uqi.setValues.add(bean.getOsversion());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("osversion"), uqi);
			valueSet = true;
		}
		if (bean.getDescription() != null || bean.isNull("description")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DESCRIPTION=? ");
			uqi.setValues.add(bean.getDescription());
			uqi.sqlTypes.add(new Integer(Types.CLOB));
			prepareNullSetListValue(bean.isNull("description"), uqi);
			valueSet = true;
		}
		if (bean.getAddress() != null || bean.isNull("address")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ADDRESS=? ");
			uqi.setValues.add(bean.getAddress());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("address"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public Machine createObject(ResultSet rs) throws SQLException {
		Machine obj = new Machine();
		obj.setUniqueid((java.math.BigDecimal) rs.getObject(1));
		obj.setTableid((java.math.BigDecimal) rs.getObject(2));
		obj.setOwner((java.math.BigDecimal) rs.getObject(3));
		if (rs.getTimestamp(4) != null) {
			obj.setModtime(new java.util.Date(rs.getTimestamp(4).getTime()));
		}
		obj.setModuser((java.math.BigDecimal) rs.getObject(5));
		obj.setArchitecture((String) rs.getObject(6));
		obj.setOs((String) rs.getObject(7));
		obj.setOsversion((String) rs.getObject(8));
		obj.setDescription(OracleUtils.readCLOB((oracle.sql.CLOB) rs
				.getObject(9)));
		obj.setAddress((String) rs.getObject(10));
		return obj;
	}

	public List<Machine> find(Connection con, Machine criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Machine> results = new LinkedList<Machine>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_MACHINE ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Machine item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Machine bean, Machine criteria)
			throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Machine criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_MACHINE ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
