package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import clinical.server.vo.Expcomponent;
import clinical.server.vo.ExpcomponentView;
import clinical.utils.GenUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ExpComponentDAOAdapter.java,v 1.2 2006/01/23 19:56:53 bozyurt
 *          Exp $
 */
public class ExpComponentDAOAdapter implements
		clinical.server.dao.ExpcomponentDAO {
	protected boolean useView = false;
	protected ExpcomponentViewDAO viewDAO;
	protected ExpcomponentDAO dao;

	public ExpComponentDAOAdapter(Map availableTablesMap) {
		if (availableTablesMap.get("NC_EXPCOMPONENT") != null) {
			useView = false;
			dao = new ExpcomponentDAO();
		} else if (availableTablesMap.get("NC_EXPCOMPONENT_VIEW") != null) {
			useView = true;
			viewDAO = new ExpcomponentViewDAO();
		} else {
			throw new RuntimeException(
					"No table NC_EXPCOMPONENT or view NC_EXPCOMPONENT_VIEW is found!");
		}
	}

	public void insert(Connection con, Expcomponent bean) throws Exception {
		if (useView) {
			ExpcomponentView view = toView(bean);
			viewDAO.insert(con, view);
		} else {
			dao.insert(con, bean);
		}

	}

	public List<Expcomponent> find(Connection con, Expcomponent criteria)
			throws Exception {
		if (useView) {
			ExpcomponentView view = toView(criteria);
			List<ExpcomponentView> r = viewDAO.find(con, view);
			List<Expcomponent> results = new LinkedList<Expcomponent>();
			for (Iterator<ExpcomponentView> iter = r.iterator(); iter.hasNext();) {
				ExpcomponentView v = iter.next();
				results.add(toVisit(v));
				iter.remove();
			}
			return results;
		} else {
			return dao.find(con, criteria);
		}
	}

	public void update(Connection con, Expcomponent bean, Expcomponent criteria)
			throws Exception {
		if (useView) {
			ExpcomponentView beanView = toView(bean);
			ExpcomponentView cView = toView(criteria);
			viewDAO.update(con, beanView, cView);
		} else {
			dao.update(con, bean, criteria);
		}
	}

	public void delete(Connection con, Expcomponent criteria) throws Exception {
		if (useView) {
			viewDAO.delete(con, toView(criteria));
		} else {
			dao.delete(con, criteria);
		}
	}

	protected ExpcomponentView toView(Expcomponent visit) {
		ExpcomponentView view = new ExpcomponentView();

		view.setComponentid(visit.getComponentid());
		view.setSubjectid(visit.getSubjectid());
		view.setModuser(visit.getModuser());
		view.setNcExperimentUniqueid(visit.getNcExperimentUniqueid());
		view.setOwner(visit.getOwner());
		view.setTableid(visit.getTableid());
		view.setUniqueid(visit.getUniqueid());
		view.setVisittype(visit.getVisittype());
		return view;
	}

	protected Expcomponent toVisit(ExpcomponentView view) {
		Expcomponent visit = new Expcomponent();

		visit.setComponentid(view.getComponentid());
		visit.setSubjectid(view.getSubjectid());
		visit.setModuser(view.getModuser());
		visit.setNcExperimentUniqueid(view.getNcExperimentUniqueid());
		visit.setOwner(view.getOwner());
		visit.setTableid(view.getTableid());
		visit.setUniqueid(view.getUniqueid());
		visit.setVisittype(view.getVisittype());

		return visit;
	}

	protected void findProperDatabaseObject(Connection con) throws SQLException {
		Statement st = null;

		try {
			st = con.createStatement();
			ResultSet rs = st.executeQuery("select 1 from nc_expcomponent");
			rs.close();
			DatabaseMetaData md = con.getMetaData();
			String[] tableTypes = new String[2];
			tableTypes[0] = "TABLE";
			tableTypes[1] = "VIEW";
			rs = md.getTables("", "UCSD_FMRI", "%", tableTypes);
			while (rs.next()) {
				String tableName = rs.getString(3);
				if (tableName.startsWith("NC_")
						&& canAccessTable(con, tableName)) {
					System.out.println(tableName);
				}
			}

		} catch (SQLException x) {
			if (x.getMessage().indexOf("ORA-00942") != -1) {
				System.out.println("table does not exists using the view");
				useView = true;
			}
		} finally {
			if (st != null)
				try {
					st.close();
				} catch (Exception x) {
				}
		}
	}

	public static boolean canAccessTable(Connection con, String tableName) {
		Statement st = null;
		try {
			st = con.createStatement();
			ResultSet rs = st.executeQuery("select 1 from " + tableName);
			rs.close();
			return true;
		} catch (SQLException x) {
			return false;
		} finally {
			if (st != null)
				try {
					st.close();
				} catch (Exception x) {
				}
		}

	}

	public static void main(String[] args) {

		Connection con = null;
		try {
			Class.forName("oracle.jdbc.driver.OracleDriver");
			Properties props = GenUtils.loadProperties("test.properties");
			String dbURL = props.getProperty("mbirn.dburl");
			String user = props.getProperty("mbirn.user");
			String pwd = props.getProperty("mbirn.pwd");

			con = DriverManager.getConnection(dbURL, user, pwd);
			ExpComponentDAOAdapter dao = new ExpComponentDAOAdapter(null);
			dao.findProperDatabaseObject(con);
		} catch (Exception x) {
			x.printStackTrace();
		} finally {
			if (con != null)
				try {
					con.close();
				} catch (Exception x) {
				}
		}

	}
}
