package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.math.BigDecimal;
import java.math.BigInteger;


import clinical.web.exception.ValidationException;
import clinical.server.vo.Receivedfiles;
import clinical.web.DBUtils;

public class ReceivedfilesDAO implements clinical.server.dao.ReceivedfilesDAO {
/*+++    */
  // Enter your declarations here
/*+++    */

public ReceivedfilesDAO () {}

public void insert(Connection con, Receivedfiles bean) throws Exception
{
   PreparedStatement ps = null;
   StringBuffer buf = new StringBuffer(200);

   if ( bean == null)
       return;
   try {
     buf.append("INSERT INTO nc_receivedfiles VALUES ");
     buf.append('(');
for(int i = 0; i < 5; ++i) {
  buf.append('?');
  if ( i <  4)
     buf.append(',');
}
buf.append(")");
     ps = con.prepareStatement( buf.toString() );
     ps.clearParameters();
                         ps.setObject(1,  bean.getFilename(), Types.VARCHAR);
                     
                         ps.setObject(2,  bean.getTemplocation(), Types.VARCHAR);
                     
                         ps.setObject(3,  bean.getPermlocation(), Types.VARCHAR);
                     
                    ps.setObject(4,        bean.getProcessed()
   );
              
                         ps.setObject(5,  bean.getFileid(), Types.NUMERIC);
                     
          ps.executeUpdate();

   } finally {
      DBUtils.close(ps);
   }
}


protected String prepareColList(Receivedfiles bean) {
  StringBuffer buf = new StringBuffer(200);
    buf.append("filename" );
   buf.append(',');     buf.append("templocation" );
   buf.append(',');     buf.append("permlocation" );
   buf.append(',');     buf.append("processed" );
   buf.append(',');     buf.append("fileid" );
      buf.append(' ');
  return buf.toString();
}

protected QueryInfo prepareWhereClause(Receivedfiles bean) {
  StringBuffer buf = new StringBuffer(200);
    QueryInfo qi = new QueryInfo();
  boolean valueSet = false;
  buf.append("WHERE ");
    if (bean.getFilename() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("filename=?");
                   qi.values.add(bean.getFilename());
                 valueSet = true;
  }
    if (bean.getTemplocation() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("templocation=?");
                   qi.values.add(bean.getTemplocation());
                 valueSet = true;
  }
    if (bean.getPermlocation() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("permlocation=?");
                   qi.values.add(bean.getPermlocation());
                 valueSet = true;
  }
    if (bean.getProcessed() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("processed=?");
                  qi.values.add( bean.getProcessed() );
            valueSet = true;
  }
    if (bean.getFileid() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("fileid=?");
                   qi.values.add(bean.getFileid());
                 valueSet = true;
  }
    qi.whereClause = (!valueSet) ? "" : buf.toString();
  return qi;
}

protected UpdateQueryInfo prepareUpdateQuery(Receivedfiles bean,Receivedfiles criteria ) throws ValidationException
{
  StringBuffer buf = new StringBuffer(200);
    UpdateQueryInfo uqi = new UpdateQueryInfo();
  boolean valueSet = false;
  buf.append("UPDATE nc_receivedfiles SET ");
    if (bean.getFilename() != null || bean.isNull("filename")) {
    if (valueSet)  buf.append(", ");
    buf.append("filename=? ");
                    uqi.setValues.add(bean.getFilename()); 
                  uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
     prepareNullSetListValue( bean.isNull("filename"), uqi);
     valueSet = true;
  }
    if (bean.getTemplocation() != null || bean.isNull("templocation")) {
    if (valueSet)  buf.append(", ");
    buf.append("templocation=? ");
                    uqi.setValues.add(bean.getTemplocation()); 
                  uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
     prepareNullSetListValue( bean.isNull("templocation"), uqi);
     valueSet = true;
  }
    if (bean.getPermlocation() != null || bean.isNull("permlocation")) {
    if (valueSet)  buf.append(", ");
    buf.append("permlocation=? ");
                    uqi.setValues.add(bean.getPermlocation()); 
                  uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
     prepareNullSetListValue( bean.isNull("permlocation"), uqi);
     valueSet = true;
  }
    if (bean.getProcessed() != null || bean.isNull("processed")) {
    if (valueSet)  buf.append(", ");
    buf.append("processed=? ");
                 uqi.setValues.add( bean.getProcessed() );
            uqi.sqlTypes.add(new Integer( Types.BOOLEAN ) );
     prepareNullSetListValue( bean.isNull("processed"), uqi);
     valueSet = true;
  }
    if (bean.getFileid() != null || bean.isNull("fileid")) {
    if (valueSet)  buf.append(", ");
    buf.append("fileid=? ");
                    uqi.setValues.add(bean.getFileid()); 
                  uqi.sqlTypes.add(new Integer( Types.NUMERIC ) );
     prepareNullSetListValue( bean.isNull("fileid"), uqi);
     valueSet = true;
  }
    if (!valueSet)
    throw new ValidationException("At least one field needs to be set for update!");

  uqi.query = buf.toString();
  QueryInfo qi = prepareWhereClause(criteria);
  uqi.query += qi.whereClause;
  uqi.whereValues = qi.values;
  return uqi;
}

protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
     if ( wasNull ) {
       uqi.nullSetList.add( new Boolean(true) );
     } else {
       uqi.nullSetList.add( new Boolean(false) );
     }
}

protected Boolean convert2Boolean(Object columnValue) {
  if (columnValue == null)
    return null;
  return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(true) : new Boolean(false);
}

protected BigDecimal boolean2Number(Boolean value) {
   if (value == null)
      return null;
    return ( (Boolean) value).booleanValue() ? new java.math.BigDecimal("1") : new java.math.BigDecimal("0");
}

protected String boolean2YN(Boolean value) {
   if (value == null)
       return null;
   return ( (Boolean) value).booleanValue() ? "Y" : "N";
}

public Receivedfiles createObject(ResultSet rs) throws SQLException {
   Receivedfiles obj = new Receivedfiles();
                      obj.setFilename( (String ) rs.getObject(1) );
                                   obj.setTemplocation( (String ) rs.getObject(2) );
                                   obj.setPermlocation( (String ) rs.getObject(3) );
                              obj.setProcessed(
                  (Boolean) rs.getObject(4)
          );
                            obj.setFileid( new BigInteger( rs.getObject(5).toString()) );
                   return obj;
}

public List<Receivedfiles> find(Connection con, Receivedfiles criteria) throws Exception
{

   PreparedStatement ps = null;
   ResultSet rs = null;
   List<Receivedfiles> results = new LinkedList<Receivedfiles>();
   StringBuffer buf = new StringBuffer(200);

   if ( criteria  == null)
       return null;
   buf.append("SELECT ");
   buf.append( prepareColList( criteria) );
   buf.append(" FROM nc_receivedfiles ");
   QueryInfo qi = prepareWhereClause(criteria);
   buf.append( qi.whereClause );
   try {
      ps = con.prepareStatement( buf.toString() );
      ps.clearParameters();
      int i = 0;
      for(Iterator<?> it = qi.values.iterator(); it.hasNext(); ) {
         ps.setObject(++i, it.next() );
      }
      rs = ps.executeQuery();
      while(rs.next() ) {
          Receivedfiles item = createObject(rs);
          results.add(item);
      }
   } finally {
      DBUtils.close(ps, rs);	
   }
   return results;
}

public void update(Connection con, Receivedfiles bean, Receivedfiles criteria) throws Exception
{
   PreparedStatement ps = null;

   if ( bean  == null)
       return;

   UpdateQueryInfo uqi =  prepareUpdateQuery(bean, criteria);
   try {
       ps = con.prepareStatement( uqi.query );
       ps.clearParameters();
       int i = 0;
       Iterator<Integer> it2 = uqi.sqlTypes.iterator();
       Iterator<Boolean> it3 = uqi.nullSetList.iterator();
       for(Iterator<?> it = uqi.setValues.iterator(); it.hasNext(); ) {
          Object value = it.next();
          Integer sqlType = (Integer) it2.next();
          boolean nullSet = ((Boolean) it3.next()).booleanValue();
          if ( nullSet) {
            ps.setNull(++i, sqlType.intValue() );
          } else {
             ps.setObject(++i, value);
          }
       }
       // for where part
       for(Iterator<?> it = uqi.whereValues.iterator(); it.hasNext(); ) {
          ps.setObject(++i, it.next() );
       }
       ps.executeUpdate();
   } finally {
      DBUtils.close(ps);	      
   }
}

public void delete(Connection con, Receivedfiles criteria) throws Exception
{
    PreparedStatement ps = null;
    StringBuffer buf = new StringBuffer(200);
    buf.append("DELETE FROM nc_receivedfiles ");

    QueryInfo qi = prepareWhereClause(criteria);
    buf.append( qi.whereClause );
    try {
       ps = con.prepareStatement( buf.toString() );
       ps.clearParameters();
       int i = 0;
       for(Iterator<?> it = qi.values.iterator(); it.hasNext(); ) {
          ps.setObject(++i, it.next() );
       }
       ps.executeUpdate();

    } finally {
      DBUtils.close(ps);	
    }
}

  public static class QueryInfo {
    String whereClause;
    List<? super Object> values = new LinkedList<Object>();
    public QueryInfo() {}
    public QueryInfo(String whereClause) {
       this.whereClause = whereClause;
    }
  }

  public static class UpdateQueryInfo {
     String query;
     List<? super Object> setValues = new LinkedList<Object>();
	 List<Integer> sqlTypes = new LinkedList<Integer>();
	 List<Boolean> nullSetList = new LinkedList<Boolean>();
	 List<? super Object> whereValues = new LinkedList<Object>();
	 
     public UpdateQueryInfo() {}
  }

/*+++    */
  // Enter your code here
/*+++    */
}//;
